/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.internal.OperationFuture;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.compatibility.CompatibilityCacheFactory;
import org.infinispan.it.compatibility.EmbeddedRestMemcachedHotRodTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.compatibility.DistMemcachedEmbeddedTest")
public class DistMemcachedEmbeddedTest
extends AbstractInfinispanTest {
    private final int numOwners = 1;
    private final int numEntries = 100;
    private final String cacheName = "memcachedCache";
    private CompatibilityCacheFactory<String, Object> cacheFactory1;
    private CompatibilityCacheFactory<String, Object> cacheFactory2;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory1 = new CompatibilityCacheFactory("memcachedCache", (Marshaller)new EmbeddedRestMemcachedHotRodTest.SpyMemcachedCompatibleMarshaller(), CacheMode.DIST_SYNC, 1).setup();
        this.cacheFactory2 = new CompatibilityCacheFactory("memcachedCache", (Marshaller)new EmbeddedRestMemcachedHotRodTest.SpyMemcachedCompatibleMarshaller(), CacheMode.DIST_SYNC, 1).setup(this.cacheFactory1.getMemcachedPort(), 100);
    }

    @AfterClass
    protected void teardown() {
        CompatibilityCacheFactory.killCacheFactories(this.cacheFactory1, this.cacheFactory2);
    }

    public void testMemcachedPutEmbeddedGet() throws Exception {
        int i;
        for (i = 0; i != 100; ++i) {
            OperationFuture f = this.cacheFactory2.getMemcachedClient().set("k" + i, 0, (Object)("v" + i));
            AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        }
        for (i = 0; i != 100; ++i) {
            AssertJUnit.assertEquals((Object)("v" + i), (Object)this.cacheFactory1.getEmbeddedCache().get((Object)("k" + i)));
            this.cacheFactory1.getEmbeddedCache().remove((Object)("k" + i));
        }
    }

    public void testEmbeddedPutMemcachedGet() throws IOException {
        int i;
        for (i = 0; i != 100; ++i) {
            AssertJUnit.assertEquals(null, (Object)this.cacheFactory2.getEmbeddedCache().put((Object)("k" + i), (Object)("v" + i)));
        }
        for (i = 0; i != 100; ++i) {
            AssertJUnit.assertEquals((Object)("v" + i), (Object)this.cacheFactory1.getMemcachedClient().get("k" + i));
        }
    }
}

