/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.compatibility.CompatibilityCacheFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.compatibility.DistEmbeddedHotRodBulkTest")
public class DistEmbeddedHotRodBulkTest
extends AbstractInfinispanTest {
    private final int numOwners = 1;
    private CompatibilityCacheFactory<String, Integer> cacheFactory1;
    private CompatibilityCacheFactory<String, Integer> cacheFactory2;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory1 = new CompatibilityCacheFactory(CacheMode.DIST_SYNC, 1, false).setup();
        this.cacheFactory2 = new CompatibilityCacheFactory(CacheMode.DIST_SYNC, 1, false).setup(this.cacheFactory1.getHotRodPort(), 100);
    }

    @AfterClass
    protected void teardown() {
        CompatibilityCacheFactory.killCacheFactories(this.cacheFactory1, this.cacheFactory2);
    }

    private void populateCacheManager(BasicCache cache) {
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)("key" + i), (Object)i);
        }
    }

    public void testEmbeddedPutHotRodKeySet() {
        Cache<String, Integer> embedded = this.cacheFactory1.getEmbeddedCache();
        RemoteCache<String, Integer> remote = this.cacheFactory2.getHotRodCache();
        this.populateCacheManager((BasicCache)embedded);
        Set keySet = remote.keySet();
        AssertJUnit.assertEquals((int)100, (int)keySet.size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)keySet.contains("key" + i));
        }
    }
}

