/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.compatibility.CompatibilityCacheFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.testng.internal.junit.ArrayAsserts;

@Test(groups={"functional"}, testName="it.compatibility.ReplEmbeddedHotRodTest")
public class ReplEmbeddedRestHotRodTest {
    CompatibilityCacheFactory<Object, Object> cacheFactory1;
    CompatibilityCacheFactory<Object, Object> cacheFactory2;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory1 = new CompatibilityCacheFactory(CacheMode.REPL_SYNC).setup();
        this.cacheFactory2 = new CompatibilityCacheFactory(CacheMode.REPL_SYNC).setup(this.cacheFactory1.getHotRodPort(), 100);
    }

    @AfterClass
    protected void teardown() {
        CompatibilityCacheFactory.killCacheFactories(this.cacheFactory1, this.cacheFactory2);
    }

    public void testRestPutEmbeddedHotRodGet() throws Exception {
        String key = "1";
        PutMethod put = new PutMethod(this.cacheFactory1.getRestUrl() + "/" + "1");
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity("<hey>ho</hey>".getBytes(), "application/octet-stream"));
        HttpClient restClient = this.cacheFactory1.getRestClient();
        restClient.executeMethod((HttpMethod)put);
        AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
        AssertJUnit.assertEquals((String)"", (String)put.getResponseBodyAsString().trim());
        ArrayAsserts.assertArrayEquals((byte[])"<hey>ho</hey>".getBytes(), (byte[])((byte[])this.cacheFactory2.getEmbeddedCache().get((Object)"1")));
        ArrayAsserts.assertArrayEquals((byte[])"<hey>ho</hey>".getBytes(), (byte[])((byte[])this.cacheFactory2.getHotRodCache().get((Object)"1")));
    }

    public void testEmbeddedPutRestHotRodGet() throws Exception {
        String key = "2";
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory2.getEmbeddedCache().put((Object)"2", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory1.getHotRodCache().get((Object)"2"));
        GetMethod get = new GetMethod(this.cacheFactory2.getRestUrl() + "/" + "2");
        this.cacheFactory2.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
    }

    public void testHotRodPutEmbeddedRestGet() throws Exception {
        String key = "3";
        RemoteCache<Object, Object> remote = this.cacheFactory1.getHotRodCache();
        AssertJUnit.assertEquals(null, (Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"3", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory2.getEmbeddedCache().get((Object)"3"));
        GetMethod get = new GetMethod(this.cacheFactory2.getRestUrl() + "/" + "3");
        this.cacheFactory2.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
    }
}

