/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import net.spy.memcached.MemcachedClient;
import org.apache.commons.httpclient.HttpClient;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.NettyRestServer;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;

public class CompatibilityCacheFactory<K, V> {
    private EmbeddedCacheManager cacheManager;
    private HotRodServer hotrod;
    private RemoteCacheManager hotrodClient;
    private Lifecycle rest;
    private MemcachedServer memcached;
    private Cache<K, V> embeddedCache;
    private RemoteCache<K, V> hotrodCache;
    private HttpClient restClient;
    private MemcachedClient memcachedClient;
    private final String cacheName;
    private final Marshaller marshaller;
    private final CacheMode cacheMode;
    private int restPort;
    private final int defaultNumOwners = 2;
    private int numOwners = 2;
    private Equivalence keyEquivalence = null;
    private Equivalence valueEquivalence = null;

    CompatibilityCacheFactory(CacheMode cacheMode) {
        this.cacheName = "";
        this.marshaller = null;
        this.cacheMode = cacheMode;
    }

    CompatibilityCacheFactory(CacheMode cacheMode, int numOwners) {
        this(cacheMode);
        this.numOwners = numOwners;
    }

    CompatibilityCacheFactory(String cacheName, Marshaller marshaller, CacheMode cacheMode) {
        this.cacheName = cacheName;
        this.marshaller = marshaller;
        this.cacheMode = cacheMode;
    }

    CompatibilityCacheFactory(String cacheName, Marshaller marshaller, CacheMode cacheMode, int numOwners) {
        this(cacheName, marshaller, cacheMode);
        this.numOwners = numOwners;
    }

    CompatibilityCacheFactory<K, V> keyEquivalence(Equivalence equivalence) {
        this.keyEquivalence = equivalence;
        return this;
    }

    CompatibilityCacheFactory<K, V> valueEquivalence(Equivalence equivalence) {
        this.valueEquivalence = equivalence;
        return this;
    }

    CompatibilityCacheFactory<K, V> setup() throws Exception {
        this.createEmbeddedCache();
        this.createHotRodCache();
        this.createRestMemcachedCaches();
        return this;
    }

    CompatibilityCacheFactory<K, V> setup(int baseHotRodPort, int portOffset) throws Exception {
        this.createEmbeddedCache();
        this.createHotRodCache(baseHotRodPort + portOffset);
        this.createRestMemcachedCaches(portOffset);
        return this;
    }

    private void createRestMemcachedCaches() throws Exception {
        this.restPort = this.hotrod.getPort() + 20;
        int memcachedPort = this.hotrod.getPort() + 40;
        this.createRestCache(this.restPort);
        this.createMemcachedCache(memcachedPort);
    }

    private void createRestMemcachedCaches(int portOffset) throws Exception {
        this.restPort = this.hotrod.getPort() + 20 + portOffset;
        int memcachedPort = this.hotrod.getPort() + 40 + portOffset;
        this.createRestCache(this.restPort);
        this.createMemcachedCache(memcachedPort);
    }

    void createEmbeddedCache() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.clustering().cacheMode(this.cacheMode).compatibility().enable().marshaller(this.marshaller);
        if (this.cacheMode.isDistributed() && this.numOwners != 2) {
            builder.clustering().hash().numOwners(this.numOwners);
        }
        if (this.keyEquivalence != null) {
            builder.dataContainer().keyEquivalence(this.keyEquivalence);
        }
        if (this.valueEquivalence != null) {
            builder.dataContainer().valueEquivalence(this.valueEquivalence);
        }
        this.cacheManager = this.cacheMode.isClustered() ? TestCacheManagerFactory.createClusteredCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder) : TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        this.embeddedCache = this.cacheName.isEmpty() ? this.cacheManager.getCache() : this.cacheManager.getCache(this.cacheName);
    }

    private void createHotRodCache() {
        this.createHotRodCache(HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager));
    }

    private void createHotRodCache(int port) {
        this.createHotRodCache(HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (int)port));
    }

    private void createHotRodCache(HotRodServer server) {
        this.hotrod = server;
        this.hotrodClient = new RemoteCacheManager(new ConfigurationBuilder().addServers("localhost:" + this.hotrod.getPort()).marshaller(this.marshaller).build());
        this.hotrodCache = this.cacheName.isEmpty() ? this.hotrodClient.getCache() : this.hotrodClient.getCache(this.cacheName);
    }

    void createRestCache(int port) throws Exception {
        RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
        builder.port(port);
        this.rest = NettyRestServer.apply((RestServerConfiguration)builder.build(), (EmbeddedCacheManager)this.cacheManager);
        this.rest.start();
        this.restClient = new HttpClient();
    }

    private void createMemcachedCache(int port) {
        this.memcached = MemcachedTestingUtil.startMemcachedTextServer((EmbeddedCacheManager)this.cacheManager, (int)port);
        this.memcachedClient = MemcachedTestingUtil.createMemcachedClient((long)60000L, (int)this.memcached.getPort());
    }

    static void killCacheFactories(CompatibilityCacheFactory ... cacheFactories) {
        if (cacheFactories != null) {
            for (CompatibilityCacheFactory cacheFactory : cacheFactories) {
                if (cacheFactory == null) continue;
                cacheFactory.teardown();
            }
        }
    }

    void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheManager)this.hotrodClient);
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotrod});
        this.killRestServer(this.rest);
        MemcachedTestingUtil.killMemcachedClient((MemcachedClient)this.memcachedClient);
        MemcachedTestingUtil.killMemcachedServer((MemcachedServer)this.memcached);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    void killRestServer(Lifecycle rest) {
        if (rest != null) {
            try {
                rest.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    Cache<K, V> getEmbeddedCache() {
        return this.embeddedCache;
    }

    RemoteCache<K, V> getHotRodCache() {
        return this.hotrodCache;
    }

    int getHotRodPort() {
        return this.hotrod.getPort();
    }

    HttpClient getRestClient() {
        return this.restClient;
    }

    MemcachedClient getMemcachedClient() {
        return this.memcachedClient;
    }

    int getMemcachedPort() {
        return this.memcached.getPort();
    }

    String getRestUrl() {
        String restCacheName = this.cacheName.isEmpty() ? "___defaultcache" : this.cacheName;
        return String.format("http://localhost:%s/rest/%s", this.restPort, restCacheName);
    }

    HotRodServer getHotrodServer() {
        return this.hotrod;
    }
}

