/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.compatibility.CompatibilityCacheFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.compatibility.CompatibilityTest")
public class EmbeddedHotRodTest
extends AbstractInfinispanTest {
    CompatibilityCacheFactory<Integer, String> cacheFactory;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory = new CompatibilityCacheFactory(CacheMode.LOCAL).setup();
        HotRodServer hotrod = this.cacheFactory.getHotrodServer();
        hotrod.addCacheEventFilterFactory("static-filter-factory", (CacheEventFilterFactory)new EventLogListener.StaticCacheEventFilterFactory());
        hotrod.addCacheEventFilterFactory("dynamic-filter-factory", (CacheEventFilterFactory)new EventLogListener.DynamicCacheEventFilterFactory());
        hotrod.addCacheEventConverterFactory("static-converter-factory", (CacheEventConverterFactory)new CustomEventLogListener.StaticConverterFactory());
        hotrod.addCacheEventConverterFactory("dynamic-converter-factory", (CacheEventConverterFactory)new CustomEventLogListener.DynamicConverterFactory());
    }

    @AfterClass
    protected void teardown() {
        CompatibilityCacheFactory.killCacheFactories(this.cacheFactory);
    }

    public void testEmbeddedPutHotRodGet() {
        Integer key = 1;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.put((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v2", (String)((String)embedded.remove((Object)key)));
    }

    public void testHotRodPutEmbeddedGet() {
        Integer key = 2;
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.get((Object)key)));
        AssertJUnit.assertEquals(null, (String)((String)remote.put((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v3")));
        AssertJUnit.assertEquals((String)"v3", (String)((String)embedded.get((Object)key)));
        AssertJUnit.assertEquals((String)"v3", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)key)));
    }

    public void testEmbeddedPutIfAbsentHotRodGet() {
        Integer key = 3;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.putIfAbsent((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.putIfAbsent((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.remove((Object)key)));
    }

    public void testHotRodPutIfAbsentEmbeddedGet() {
        Integer key = 4;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.get((Object)key)));
        AssertJUnit.assertEquals(null, (String)((String)remote.putIfAbsent((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.get((Object)key)));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)key)));
    }

    public void testEmbeddedReplaceHotRodGet() {
        Integer key = 5;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.replace((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.replace((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v2", (String)((String)embedded.remove((Object)key)));
    }

    public void testHotRodReplaceEmbeddedGet() {
        Integer key = 6;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).replace((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).replace((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)embedded.get((Object)key)));
    }

    public void testEmbeddedReplaceConditionalHotRodGet() {
        Integer key = 7;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertTrue((boolean)embedded.replace((Object)key, (Object)"v1", (Object)"v2"));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v2", (String)((String)embedded.remove((Object)key)));
    }

    public void testHotRodReplaceConditionalEmbeddedGet() {
        Integer key = 8;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.put((Object)key, (Object)"v1")));
        VersionedValue versioned = remote.getVersioned((Object)key);
        AssertJUnit.assertEquals((String)"v1", (String)((String)versioned.getValue()));
        AssertJUnit.assertTrue((0L != versioned.getVersion() ? 1 : 0) != 0);
        AssertJUnit.assertFalse((boolean)remote.replaceWithVersion((Object)key, (Object)"v2", Long.MAX_VALUE));
        AssertJUnit.assertTrue((boolean)remote.replaceWithVersion((Object)key, (Object)"v2", versioned.getVersion()));
        AssertJUnit.assertEquals((String)"v2", (String)((String)embedded.get((Object)key)));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)key)));
    }

    public void testEmbeddedRemoveHotRodGet() {
        Integer key = 9;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.remove((Object)key)));
        AssertJUnit.assertEquals(null, (String)((String)remote.get((Object)key)));
    }

    public void testHotRodRemoveEmbeddedGet() {
        Integer key = 10;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)key)));
        AssertJUnit.assertEquals(null, (String)((String)embedded.get((Object)key)));
    }

    public void testEmbeddedRemoveConditionalHotRodGet() {
        Integer key = 11;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertFalse((boolean)embedded.remove((Object)key, (Object)"vX"));
        AssertJUnit.assertTrue((boolean)embedded.remove((Object)key, (Object)"v1"));
        AssertJUnit.assertEquals(null, (String)((String)remote.get((Object)key)));
    }

    public void testHotRodRemoveConditionalEmbeddedGet() {
        Integer key = 12;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1")));
        VersionedValue versioned = remote.getVersioned((Object)key);
        AssertJUnit.assertFalse((boolean)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).removeWithVersion((Object)key, Long.MAX_VALUE));
        AssertJUnit.assertTrue((boolean)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).removeWithVersion((Object)key, versioned.getVersion()));
        AssertJUnit.assertEquals(null, (String)((String)embedded.get((Object)key)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventReceiveBasic() {
        EventLogListener eventListener = new EventLogListener(true);
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        remote.addClientListener((Object)eventListener);
        try {
            eventListener.expectNoEvents();
            remote.remove((Object)1);
            eventListener.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            AssertJUnit.assertEquals((String)"one", (String)((String)embedded.get((Object)1)));
            eventListener.expectOnlyCreatedEvent((Object)1, embedded);
            remote.put((Object)1, (Object)"new-one");
            AssertJUnit.assertEquals((String)"new-one", (String)((String)embedded.get((Object)1)));
            eventListener.expectOnlyModifiedEvent((Object)1, embedded);
            remote.remove((Object)1);
            eventListener.expectOnlyRemovedEvent((Object)1, embedded);
        }
        finally {
            remote.removeClientListener((Object)eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventReceiveConditional() {
        EventLogListener eventListener = new EventLogListener(true);
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        remote.addClientListener((Object)eventListener);
        try {
            eventListener.expectNoEvents();
            remote.putIfAbsent((Object)1, (Object)"one");
            eventListener.expectOnlyCreatedEvent((Object)1, embedded);
            remote.putIfAbsent((Object)1, (Object)"again");
            eventListener.expectNoEvents();
            remote.replace((Object)1, (Object)"newone");
            eventListener.expectOnlyModifiedEvent((Object)1, embedded);
            remote.replaceWithVersion((Object)1, (Object)"one", 0L);
            eventListener.expectNoEvents();
            VersionedValue versioned = remote.getVersioned((Object)1);
            remote.replaceWithVersion((Object)1, (Object)"one", versioned.getVersion());
            eventListener.expectOnlyModifiedEvent((Object)1, embedded);
            remote.removeWithVersion((Object)1, 0L);
            eventListener.expectNoEvents();
            versioned = remote.getVersioned((Object)1);
            remote.removeWithVersion((Object)1, versioned.getVersion());
            eventListener.expectOnlyRemovedEvent((Object)1, embedded);
        }
        finally {
            remote.removeClientListener((Object)eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventReplayAfterAddingListener() {
        EventLogWithStateListener eventListener = new EventLogWithStateListener(true);
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        remote.put((Object)1, (Object)"one");
        AssertJUnit.assertEquals((String)"one", (String)((String)embedded.get((Object)1)));
        remote.put((Object)2, (Object)"two");
        AssertJUnit.assertEquals((String)"two", (String)((String)embedded.get((Object)2)));
        remote.put((Object)3, (Object)"three");
        AssertJUnit.assertEquals((String)"three", (String)((String)embedded.get((Object)3)));
        remote.remove((Object)3);
        AssertJUnit.assertNull((Object)embedded.get((Object)3));
        eventListener.expectNoEvents();
        remote.addClientListener(eventListener);
        try {
            eventListener.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, new Integer[]{1, 2});
            remote.remove((Object)1);
            eventListener.expectOnlyRemovedEvent(1, embedded);
            remote.remove((Object)2);
            eventListener.expectOnlyRemovedEvent(2, embedded);
        }
        finally {
            remote.removeClientListener(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventNoReplayAfterAddingListener() {
        EventLogListener eventListener = new EventLogListener(true);
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        remote.put((Object)1, (Object)"one");
        AssertJUnit.assertEquals((String)"one", (String)((String)embedded.get((Object)1)));
        remote.put((Object)2, (Object)"two");
        AssertJUnit.assertEquals((String)"two", (String)((String)embedded.get((Object)2)));
        remote.put((Object)3, (Object)"three");
        AssertJUnit.assertEquals((String)"three", (String)((String)embedded.get((Object)3)));
        remote.remove((Object)3);
        AssertJUnit.assertNull((Object)embedded.get((Object)3));
        eventListener.expectNoEvents();
        remote.addClientListener((Object)eventListener);
        try {
            eventListener.expectNoEvents();
            remote.remove((Object)1);
            eventListener.expectOnlyRemovedEvent((Object)1, embedded);
            remote.remove((Object)2);
            eventListener.expectOnlyRemovedEvent((Object)2, embedded);
        }
        finally {
            remote.removeClientListener((Object)eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventFilteringStatic() {
        EventLogListener.StaticFilteredEventLogListener eventListener = new EventLogListener.StaticFilteredEventLogListener(true);
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        remote.addClientListener((Object)eventListener);
        try {
            eventListener.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            AssertJUnit.assertEquals((String)"one", (String)((String)embedded.get((Object)1)));
            eventListener.expectNoEvents();
            remote.put((Object)2, (Object)"two");
            AssertJUnit.assertEquals((String)"two", (String)((String)embedded.get((Object)2)));
            eventListener.expectOnlyCreatedEvent((Object)2, embedded);
            remote.remove((Object)1);
            AssertJUnit.assertNull((Object)embedded.get((Object)1));
            eventListener.expectNoEvents();
            remote.remove((Object)2);
            AssertJUnit.assertNull((Object)embedded.get((Object)2));
            eventListener.expectOnlyRemovedEvent((Object)2, embedded);
        }
        finally {
            remote.removeClientListener((Object)eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventFilteringDynamic() {
        EventLogListener.DynamicFilteredEventLogListener eventListener = new EventLogListener.DynamicFilteredEventLogListener(true);
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        remote.addClientListener((Object)eventListener, new Object[]{3}, null);
        try {
            eventListener.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            AssertJUnit.assertEquals((String)"one", (String)((String)embedded.get((Object)1)));
            eventListener.expectNoEvents();
            remote.put((Object)2, (Object)"two");
            AssertJUnit.assertEquals((String)"two", (String)((String)embedded.get((Object)2)));
            eventListener.expectNoEvents();
            remote.put((Object)3, (Object)"three");
            AssertJUnit.assertEquals((String)"three", (String)((String)embedded.get((Object)3)));
            eventListener.expectOnlyCreatedEvent((Object)3, embedded);
            remote.replace((Object)1, (Object)"new-one");
            AssertJUnit.assertEquals((String)"new-one", (String)((String)embedded.get((Object)1)));
            eventListener.expectNoEvents();
            remote.replace((Object)2, (Object)"new-two");
            AssertJUnit.assertEquals((String)"new-two", (String)((String)embedded.get((Object)2)));
            eventListener.expectNoEvents();
            remote.replace((Object)3, (Object)"new-three");
            AssertJUnit.assertEquals((String)"new-three", (String)((String)embedded.get((Object)3)));
            eventListener.expectOnlyModifiedEvent((Object)3, embedded);
            remote.remove((Object)1);
            AssertJUnit.assertNull((Object)embedded.get((Object)1));
            eventListener.expectNoEvents();
            remote.remove((Object)2);
            AssertJUnit.assertNull((Object)embedded.get((Object)2));
            eventListener.expectNoEvents();
            remote.remove((Object)3);
            AssertJUnit.assertNull((Object)embedded.get((Object)3));
            eventListener.expectOnlyRemovedEvent((Object)3, embedded);
        }
        finally {
            remote.removeClientListener((Object)eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomEvents() {
        CustomEventLogListener.StaticCustomEventLogListener eventListener = new CustomEventLogListener.StaticCustomEventLogListener();
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        remote.addClientListener((Object)eventListener);
        try {
            eventListener.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            AssertJUnit.assertEquals((String)"one", (String)((String)embedded.get((Object)1)));
            eventListener.expectOnlyCreatedCustomEvent(Integer.valueOf(1), "one");
            remote.put((Object)1, (Object)"new-one");
            AssertJUnit.assertEquals((String)"new-one", (String)((String)embedded.get((Object)1)));
            eventListener.expectOnlyModifiedCustomEvent(Integer.valueOf(1), "new-one");
            remote.remove((Object)1);
            AssertJUnit.assertNull((Object)embedded.get((Object)1));
            eventListener.expectOnlyRemovedCustomEvent(Integer.valueOf(1), null);
        }
        finally {
            remote.removeClientListener((Object)eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomEventsDynamic() {
        CustomEventLogListener.DynamicCustomEventLogListener eventListener = new CustomEventLogListener.DynamicCustomEventLogListener();
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        remote.addClientListener((Object)eventListener, null, new Object[]{2});
        try {
            eventListener.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            AssertJUnit.assertEquals((String)"one", (String)((String)embedded.get((Object)1)));
            eventListener.expectOnlyCreatedCustomEvent(Integer.valueOf(1), "one");
            remote.put((Object)2, (Object)"two");
            AssertJUnit.assertEquals((String)"two", (String)((String)embedded.get((Object)2)));
            eventListener.expectOnlyCreatedCustomEvent(Integer.valueOf(2), null);
            remote.remove((Object)1);
            AssertJUnit.assertNull((Object)embedded.get((Object)1));
            eventListener.expectOnlyRemovedCustomEvent(Integer.valueOf(1), null);
            remote.remove((Object)2);
            AssertJUnit.assertNull((Object)embedded.get((Object)2));
            eventListener.expectOnlyRemovedCustomEvent(Integer.valueOf(2), null);
        }
        finally {
            remote.removeClientListener((Object)eventListener);
        }
    }

    @ClientListener(includeCurrentState=true)
    public static class EventLogWithStateListener<K>
    extends EventLogListener<K> {
        public EventLogWithStateListener(boolean compatibility) {
            super(compatibility);
        }
    }
}

