/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import java.util.Collections;
import java.util.EventListener;
import javax.servlet.ServletContext;
import net.spy.memcached.MemcachedClient;
import org.apache.commons.httpclient.HttpClient;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.Marshaller;
import org.infinispan.rest.ServerBootstrap;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.Context;

public class CompatibilityCacheFactory<K, V> {
    private EmbeddedCacheManager cacheManager;
    private HotRodServer hotrod;
    private RemoteCacheManager hotrodClient;
    private Server rest;
    private MemcachedServer memcached;
    private Cache<K, V> embeddedCache;
    private RemoteCache<K, V> hotrodCache;
    private HttpClient restClient;
    private MemcachedClient memcachedClient;
    private final String cacheName;
    private final Marshaller marshaller;
    private final CacheMode cacheMode;
    private int restPort;

    CompatibilityCacheFactory(CacheMode cacheMode) {
        this("", null, cacheMode);
    }

    CompatibilityCacheFactory(String cacheName, Marshaller marshaller, CacheMode cacheMode) {
        this.cacheName = cacheName;
        this.marshaller = marshaller;
        this.cacheMode = cacheMode;
    }

    CompatibilityCacheFactory<K, V> setup() throws Exception {
        this.createEmbeddedCache();
        this.createHotRodCache();
        this.createRestMemcachedCaches();
        return this;
    }

    CompatibilityCacheFactory<K, V> setup(int basePort, int portOffset) throws Exception {
        this.createEmbeddedCache();
        this.createHotRodCache(basePort + portOffset);
        this.createRestMemcachedCaches();
        return this;
    }

    private void createRestMemcachedCaches() throws Exception {
        this.restPort = this.hotrod.getPort() + 20;
        int memcachedPort = this.hotrod.getPort() + 40;
        this.createRestCache(this.restPort);
        this.createMemcachedCache(memcachedPort);
    }

    void createEmbeddedCache() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.clustering().cacheMode(this.cacheMode).compatibility().enable().marshaller(this.marshaller);
        this.cacheManager = this.cacheMode.isClustered() ? TestCacheManagerFactory.createClusteredCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder) : TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        this.embeddedCache = this.cacheName.isEmpty() ? this.cacheManager.getCache() : this.cacheManager.getCache(this.cacheName);
    }

    private void createHotRodCache() {
        this.createHotRodCache(TestHelper.startHotRodServer((EmbeddedCacheManager)this.cacheManager));
    }

    private void createHotRodCache(int port) {
        this.createHotRodCache(HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (int)port));
    }

    private void createHotRodCache(HotRodServer server) {
        this.hotrod = server;
        this.hotrodClient = new RemoteCacheManager(new ConfigurationBuilder().addServers("localhost:" + this.hotrod.getPort()).marshaller(this.marshaller).build());
        this.hotrodCache = this.cacheName.isEmpty() ? this.hotrodClient.getCache() : this.hotrodClient.getCache(this.cacheName);
    }

    void createRestCache(int port) throws Exception {
        this.rest = new Server(port);
        Context ctx = new Context((HandlerContainer)this.rest, "/", 1);
        ctx.setInitParams(Collections.singletonMap("resteasy.resources", "org.infinispan.rest.Server"));
        ctx.addEventListener((EventListener)new ResteasyBootstrap());
        ctx.addEventListener((EventListener)new ServerBootstrap());
        ctx.addServlet(HttpServletDispatcher.class, "/rest/*");
        ContextHandler.SContext servletContext = ctx.getServletContext();
        ServerBootstrap.setCacheManager((ServletContext)servletContext, (EmbeddedCacheManager)this.cacheManager);
        this.rest.start();
        this.restClient = new HttpClient();
    }

    private void createMemcachedCache(int port) {
        this.memcached = MemcachedTestingUtil.startMemcachedTextServer((EmbeddedCacheManager)this.cacheManager, (int)port);
        this.memcachedClient = MemcachedTestingUtil.createMemcachedClient((long)60000L, (int)this.memcached.getPort());
    }

    static void killCacheFactories(CompatibilityCacheFactory ... cacheFactories) {
        if (cacheFactories != null) {
            for (CompatibilityCacheFactory cacheFactory : cacheFactories) {
                if (cacheFactory == null) continue;
                cacheFactory.teardown();
            }
        }
    }

    void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheManager)this.hotrodClient);
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotrod});
        this.killRestServer(this.rest);
        MemcachedTestingUtil.killMemcachedClient((MemcachedClient)this.memcachedClient);
        MemcachedTestingUtil.killMemcachedServer((MemcachedServer)this.memcached);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    void killRestServer(Server rest) {
        if (rest != null) {
            try {
                rest.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    Cache<K, V> getEmbeddedCache() {
        return this.embeddedCache;
    }

    RemoteCache<K, V> getHotRodCache() {
        return this.hotrodCache;
    }

    int getHotRodPort() {
        return this.hotrod.getPort();
    }

    HttpClient getRestClient() {
        return this.restClient;
    }

    MemcachedClient getMemcachedClient() {
        return this.memcachedClient;
    }

    int getMemcachedPort() {
        return this.memcached.getPort();
    }

    String getRestUrl() {
        String restCacheName = this.cacheName.isEmpty() ? "___defaultcache" : this.cacheName;
        return String.format("http://localhost:%s/rest/%s", this.restPort, restCacheName);
    }
}

