/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import java.util.Collections;
import java.util.EventListener;
import javax.servlet.ServletContext;
import net.spy.memcached.MemcachedClient;
import org.apache.commons.httpclient.HttpClient;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.Marshaller;
import org.infinispan.rest.ServerBootstrap;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.Context;

public class CompatibilityCacheFactory<K, V> {
    private EmbeddedCacheManager cacheManager;
    private HotRodServer hotrod;
    private RemoteCacheManager hotrodClient;
    private Server rest;
    private MemcachedServer memcached;
    private Cache<K, V> embeddedCache;
    private RemoteCache<K, V> hotrodCache;
    private HttpClient restClient;
    private MemcachedClient memcachedClient;
    private final String cacheName;
    private final Marshaller marshaller;
    private int restPort;

    CompatibilityCacheFactory() {
        this("", null);
    }

    CompatibilityCacheFactory(String cacheName, Marshaller marshaller) {
        this.cacheName = cacheName;
        this.marshaller = marshaller;
    }

    void setup() throws Exception {
        this.createEmbeddedCache();
        this.createHotRodCache();
        this.restPort = this.hotrod.getPort() + 25;
        this.createRestCache(this.restPort);
        this.createMemcachedCache();
    }

    void createEmbeddedCache() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.compatibility().enable().marshaller(this.marshaller);
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        this.embeddedCache = this.cacheName.isEmpty() ? this.cacheManager.getCache() : this.cacheManager.getCache(this.cacheName);
    }

    void createHotRodCache() {
        this.hotrod = TestHelper.startHotRodServer((EmbeddedCacheManager)this.cacheManager);
        this.hotrodClient = new RemoteCacheManager(new ConfigurationBuilder().addServers("localhost:" + this.hotrod.getPort()).marshaller(this.marshaller).build());
        this.hotrodCache = this.cacheName.isEmpty() ? this.hotrodClient.getCache() : this.hotrodClient.getCache(this.cacheName);
    }

    void createRestCache(int port) throws Exception {
        this.rest = new Server(port);
        Context ctx = new Context((HandlerContainer)this.rest, "/", 1);
        ctx.setInitParams(Collections.singletonMap("resteasy.resources", "org.infinispan.rest.Server"));
        ctx.addEventListener((EventListener)new ResteasyBootstrap());
        ctx.addServlet(HttpServletDispatcher.class, "/rest/*");
        ContextHandler.SContext servletContext = ctx.getServletContext();
        ServerBootstrap.setCacheManager((ServletContext)servletContext, (EmbeddedCacheManager)this.cacheManager);
        this.rest.start();
        this.restClient = new HttpClient();
    }

    private void createMemcachedCache() {
        this.memcached = MemcachedTestingUtil.startMemcachedTextServer((EmbeddedCacheManager)this.cacheManager);
        this.memcachedClient = MemcachedTestingUtil.createMemcachedClient((long)60000L, (int)this.memcached.getPort());
    }

    void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheManager)this.hotrodClient);
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotrod});
        this.killRestServer(this.rest);
        MemcachedTestingUtil.killMemcachedClient((MemcachedClient)this.memcachedClient);
        MemcachedTestingUtil.killMemcachedServer((MemcachedServer)this.memcached);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    void killRestServer(Server rest) {
        if (rest != null) {
            try {
                rest.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    Cache<K, V> getEmbeddedCache() {
        return this.embeddedCache;
    }

    RemoteCache<K, V> getHotRodCache() {
        return this.hotrodCache;
    }

    HttpClient getRestClient() {
        return this.restClient;
    }

    MemcachedClient getMemcachedClient() {
        return this.memcachedClient;
    }

    String getRestUrl() {
        String restCacheName = this.cacheName.isEmpty() ? "___defaultcache" : this.cacheName;
        return String.format("http://localhost:%s/rest/%s", this.restPort, restCacheName);
    }
}

