/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.function.Supplier;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeValidator;
import org.infinispan.commons.util.Util;

public final class AttributeDefinition<T> {
    private final String name;
    private final String xmlName;
    private final T defaultValue;
    private final boolean immutable;
    private final boolean autoPersist;
    private final boolean global;
    private final AttributeCopier copier;
    private final AttributeInitializer<? extends T> initializer;
    private final AttributeValidator<? super T> validator;
    private final Class<T> type;

    AttributeDefinition(String name, String xmlName, T initialValue, Class<T> type, boolean immutable, boolean autoPersist, boolean global, AttributeCopier copier, AttributeValidator<? super T> validator, AttributeInitializer<? extends T> initializer) {
        this.name = name;
        this.xmlName = xmlName;
        this.defaultValue = initialValue;
        this.immutable = immutable;
        this.autoPersist = autoPersist;
        this.global = global;
        this.copier = copier;
        this.initializer = initializer;
        this.validator = validator;
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public String xmlName() {
        return this.xmlName;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.initializer != null ? this.initializer().initialize() : this.defaultValue;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isAutoPersist() {
        return this.autoPersist;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public AttributeCopier copier() {
        return this.copier;
    }

    public AttributeInitializer<? extends T> initializer() {
        return this.initializer;
    }

    AttributeValidator<? super T> validator() {
        return this.validator;
    }

    public Attribute<T> toAttribute() {
        return new Attribute(this);
    }

    public void validate(T value) {
        if (this.validator != null) {
            this.validator.validate(value);
        }
    }

    public static <T> Builder<T> builder(String name, T defaultValue) {
        if (defaultValue != null) {
            return new Builder(name, defaultValue, defaultValue.getClass());
        }
        throw new CacheConfigurationException("Must specify type when passing null for AttributeDefinition " + name);
    }

    public static <T> Builder<T> builder(String name, T defaultValue, Class<T> klass) {
        return new Builder(name, defaultValue, klass);
    }

    public static <T> Builder<Class<? extends T>> classBuilder(String name, Class<T> klass) {
        return new Builder<Class<? extends T>>(name, null, Class.class);
    }

    public static <T> Builder<Supplier<? extends T>> supplierBuilder(String name, Class<T> klass) {
        return new Builder<Supplier<? extends T>>(name, null, Supplier.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeDefinition that = (AttributeDefinition)o;
        if (this.immutable != that.immutable) {
            return false;
        }
        if (this.autoPersist != that.autoPersist) {
            return false;
        }
        if (this.global != that.global) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.xmlName != null ? !this.xmlName.equals(that.xmlName) : that.xmlName != null) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) {
            return false;
        }
        if (this.copier != null ? !this.copier.equals(that.copier) : that.copier != null) {
            return false;
        }
        if (this.initializer != null ? !this.initializer.equals(that.initializer) : that.initializer != null) {
            return false;
        }
        if (this.validator != null ? !this.validator.equals(that.validator) : that.validator != null) {
            return false;
        }
        return this.type != null ? this.type.equals(that.type) : that.type == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.xmlName != null ? this.xmlName.hashCode() : 0);
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        result = 31 * result + (this.immutable ? 1 : 0);
        result = 31 * result + (this.autoPersist ? 1 : 0);
        result = 31 * result + (this.global ? 1 : 0);
        result = 31 * result + (this.copier != null ? this.copier.hashCode() : 0);
        result = 31 * result + (this.initializer != null ? this.initializer.hashCode() : 0);
        result = 31 * result + (this.validator != null ? this.validator.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public static final class Builder<T> {
        private final String name;
        private final T defaultValue;
        private final Class<T> type;
        private boolean immutable = false;
        private boolean autoPersist = true;
        private boolean global = true;
        private String xmlName;
        private AttributeCopier copier = null;
        private AttributeInitializer<? extends T> initializer;
        private AttributeValidator<? super T> validator;

        private Builder(String name, T defaultValue, Class<T> type) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.type = type;
        }

        public Builder<T> immutable() {
            this.immutable = true;
            return this;
        }

        public Builder<T> copier(AttributeCopier copier) {
            this.copier = copier;
            return this;
        }

        public Builder<T> initializer(AttributeInitializer<? extends T> initializer) {
            this.initializer = initializer;
            return this;
        }

        public Builder<T> autoPersist(boolean autoPersist) {
            this.autoPersist = autoPersist;
            return this;
        }

        public Builder<T> global(boolean global) {
            this.global = global;
            return this;
        }

        public Builder<T> validator(AttributeValidator<? super T> validator) {
            this.validator = validator;
            return this;
        }

        public Builder<T> xmlName(String xmlName) {
            this.xmlName = xmlName;
            return this;
        }

        public AttributeDefinition<T> build() {
            return new AttributeDefinition<T>(this.name, this.xmlName == null ? Util.xmlify(this.name) : this.xmlName, this.defaultValue, this.type, this.immutable, this.autoPersist, this.global, this.copier, this.validator, this.initializer);
        }
    }
}

