/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;

public final class StandardConversions {
    private static final Log log = LogFactory.getLog(StandardConversions.class);
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    public static Object convertTextToText(Object source, MediaType sourceType, MediaType destinationType) {
        Charset destinationCharset;
        if (source == null) {
            return null;
        }
        if (sourceType == null || destinationType == null) {
            throw new NullPointerException("MediaType cannot be null!");
        }
        if (!sourceType.match(MediaType.TEXT_PLAIN)) {
            throw log.invalidMediaType("text/plain", sourceType.toString());
        }
        Charset sourceCharset = sourceType.getCharset();
        if (sourceCharset.equals(destinationCharset = destinationType.getCharset())) {
            return source;
        }
        byte[] byteContent = source instanceof byte[] ? (byte[])source : source.toString().getBytes(sourceCharset);
        return StandardConversions.convertCharset(byteContent, sourceCharset, destinationCharset);
    }

    public static byte[] convertTextToOctetStream(Object source, MediaType sourceType) {
        if (source == null) {
            return null;
        }
        if (sourceType == null) {
            throw new NullPointerException("MediaType cannot be null!");
        }
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        return source.toString().getBytes(sourceType.getCharset());
    }

    public static String convertTextToObject(Object source, MediaType sourceType) {
        if (source == null) {
            return null;
        }
        if (source instanceof String) {
            return source.toString();
        }
        if (source instanceof byte[]) {
            byte[] bytesSource = (byte[])source;
            return new String(bytesSource, sourceType.getCharset());
        }
        throw log.invalidTextContent(source);
    }

    public static String convertTextToUrlEncoded(Object source, MediaType sourceType) {
        return StandardConversions.urlEncode(source, sourceType);
    }

    public static byte[] convertOctetStreamToText(byte[] source, MediaType destination) {
        if (source == null) {
            return null;
        }
        return StandardConversions.convertCharset(source, StandardCharsets.UTF_8, destination.getCharset());
    }

    public static Object convertOctetStreamToJava(byte[] source, MediaType destination, Marshaller marshaller) {
        if (source == null) {
            return null;
        }
        if (!destination.match(MediaType.APPLICATION_OBJECT)) {
            throw log.invalidMediaType("application/x-java-object", destination.toString());
        }
        Optional<String> optType = destination.getParameter("type");
        if (!optType.isPresent()) {
            return source;
        }
        String targetType = optType.get();
        if (targetType.equals("ByteArray")) {
            return source;
        }
        if (targetType.equals(String.class.getName())) {
            return new String(source, StandardCharsets.UTF_8);
        }
        try {
            return marshaller.objectFromByteBuffer(source);
        }
        catch (IOException | ClassNotFoundException e) {
            throw log.conversionNotSupported(source, "application/octet-stream", destination.toString());
        }
    }

    public static byte[] convertJavaToOctetStream(Object source, MediaType sourceMediaType, Marshaller marshaller) throws IOException, InterruptedException {
        if (source == null) {
            return null;
        }
        if (!sourceMediaType.match(MediaType.APPLICATION_OBJECT)) {
            throw new EncodingException("destination MediaType not conforming to application/x-java-object!");
        }
        Object decoded = StandardConversions.decodeObjectContent(source, sourceMediaType);
        if (decoded instanceof byte[]) {
            return (byte[])decoded;
        }
        if (decoded instanceof String) {
            return ((String)decoded).getBytes(StandardCharsets.UTF_8);
        }
        return marshaller.objectToByteBuffer(source);
    }

    public static byte[] convertJavaToText(Object source, MediaType sourceMediaType, MediaType destinationMediaType) {
        if (source == null) {
            return null;
        }
        if (sourceMediaType == null || destinationMediaType == null) {
            throw new NullPointerException("sourceMediaType and destinationMediaType cannot be null!");
        }
        Object decoded = StandardConversions.decodeObjectContent(source, sourceMediaType);
        if (decoded instanceof byte[]) {
            return StandardConversions.convertCharset(source, StandardCharsets.UTF_8, destinationMediaType.getCharset());
        }
        String asString = decoded.toString();
        return asString.getBytes(destinationMediaType.getCharset());
    }

    public static Object decodeObjectContent(Object content, MediaType contentMediaType) {
        try {
            if (content == null) {
                return null;
            }
            if (contentMediaType == null) {
                throw new NullPointerException("contentMediaType cannot be null!");
            }
            Optional<String> type = contentMediaType.getParameter("type");
            if (!type.isPresent()) {
                return content;
            }
            String sourceType = type.get();
            if (sourceType.equals("ByteArray")) {
                if (content instanceof byte[]) {
                    return content;
                }
                if (content instanceof String) {
                    return StandardConversions.hexToBytes(content.toString());
                }
                throw new EncodingException("Cannot read ByteArray!");
            }
            String strContent = content instanceof byte[] ? new String((byte[])content, StandardCharsets.UTF_8) : content.toString();
            Class<?> destinationType = Class.forName(sourceType);
            if (destinationType == String.class) {
                return content;
            }
            if (destinationType == Boolean.class) {
                return Boolean.parseBoolean(strContent);
            }
            if (destinationType == Short.class) {
                return Short.parseShort(strContent);
            }
            if (destinationType == Byte.class) {
                return Byte.parseByte(strContent);
            }
            if (destinationType == Integer.class) {
                return Integer.parseInt(strContent);
            }
            if (destinationType == Long.class) {
                return Long.parseLong(strContent);
            }
            if (destinationType == Float.class) {
                return Float.valueOf(Float.parseFloat(strContent));
            }
            if (destinationType == Double.class) {
                return Double.parseDouble(strContent);
            }
            return content;
        }
        catch (ClassNotFoundException cne) {
            throw new EncodingException("Cannot decode object!", cne);
        }
    }

    public static byte[] convertCharset(Object content, Charset fromCharset, Charset toCharset) {
        if (content == null) {
            return null;
        }
        if (fromCharset == null || toCharset == null) {
            throw new NullPointerException("Charset cannot be null!");
        }
        byte[] bytes = content instanceof String ? content.toString().getBytes(fromCharset) : (content instanceof byte[] ? (byte[])content : content.toString().getBytes(fromCharset));
        if (fromCharset.equals(toCharset)) {
            return bytes;
        }
        CharBuffer inputContent = fromCharset.decode(ByteBuffer.wrap(bytes));
        ByteBuffer result = toCharset.encode(inputContent);
        return Arrays.copyOf(result.array(), result.limit());
    }

    public static byte[] decodeOctetStream(Object input, MediaType octetStream) {
        if (input == null) {
            throw new NullPointerException("input must not be null");
        }
        if (input instanceof byte[]) {
            return (byte[])input;
        }
        if (input instanceof String) {
            String encoding = octetStream.getParameter("encoding").orElse("hex");
            String src = input.toString();
            return encoding.equals("hex") ? StandardConversions.hexToBytes(src) : Base64.getUrlDecoder().decode(src);
        }
        throw new EncodingException("Cannot decode binary content " + input.getClass());
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        StringBuilder r = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            r.append(HEX_DIGITS[b >> 4 & 0xF]);
            r.append(HEX_DIGITS[b & 0xF]);
        }
        return "0x" + r.toString();
    }

    private static int forDigit(char digit) {
        if (digit >= '0' && digit <= '9') {
            return digit - 48;
        }
        if (digit == 'a') {
            return 10;
        }
        if (digit == 'b') {
            return 11;
        }
        if (digit == 'c') {
            return 12;
        }
        if (digit == 'd') {
            return 13;
        }
        if (digit == 'e') {
            return 14;
        }
        if (digit == 'f') {
            return 15;
        }
        throw new EncodingException("Invalid digit found in hex format!");
    }

    public static byte[] hexToBytes(String hex) {
        if (hex == null) {
            return null;
        }
        if (hex.isEmpty()) {
            return new byte[0];
        }
        if (!hex.startsWith("0x") || hex.length() % 2 != 0) {
            throw new EncodingException("Illegal hex literal!");
        }
        byte[] result = new byte[(hex.length() - 2) / 2];
        for (int i = 2; i < hex.length(); i += 2) {
            byte b;
            int msb = StandardConversions.forDigit(hex.charAt(i));
            int lsb = StandardConversions.forDigit(hex.charAt(i + 1));
            result[(i - 2) / 2] = b = (byte)(msb * 16 + lsb);
        }
        return result;
    }

    public static Object convertUrlEncodedToObject(Object content) {
        Object decoded = StandardConversions.urlDecode(content);
        return StandardConversions.convertTextToObject(decoded, MediaType.TEXT_PLAIN);
    }

    public static Object convertUrlEncodedToText(Object content, MediaType destinationType) {
        return StandardConversions.convertTextToText(StandardConversions.urlDecode(content), MediaType.TEXT_PLAIN, destinationType);
    }

    public static Object convertUrlEncodedToOctetStream(Object content) {
        return StandardConversions.convertTextToOctetStream(StandardConversions.urlDecode(content), MediaType.TEXT_PLAIN);
    }

    public static String urlEncode(Object content, MediaType mediaType) {
        if (content == null) {
            return null;
        }
        try {
            String asString = content instanceof byte[] ? new String((byte[])content, StandardCharsets.UTF_8) : content.toString();
            return URLEncoder.encode(asString, mediaType.getCharset().toString());
        }
        catch (UnsupportedEncodingException e) {
            throw log.errorEncoding(content, MediaType.APPLICATION_WWW_FORM_URLENCODED);
        }
    }

    public static Object urlDecode(Object content) {
        try {
            if (content == null) {
                return null;
            }
            if (content instanceof byte[]) {
                byte[] bytesSource = (byte[])content;
                return URLDecoder.decode(new String(bytesSource, StandardCharsets.UTF_8), StandardCharsets.UTF_8.toString());
            }
            return URLDecoder.decode(content.toString(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw log.cannotDecodeFormURLContent(content);
        }
    }

    public static Object convertOctetStreamToUrlEncoded(Object content, MediaType contentType) {
        byte[] decoded = StandardConversions.decodeOctetStream(content, contentType);
        return StandardConversions.urlEncode(decoded, MediaType.TEXT_PLAIN);
    }
}

