/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;

public class Closeables {
    private Closeables() {
    }

    public static <E> CloseableSpliterator<E> spliterator(CloseableIterator<? extends E> iterator, long size, int characteristics) {
        return new CloseableIteratorAsCloseableSpliterator<E>(iterator, size, characteristics);
    }

    public static <T> CloseableSpliterator<T> spliterator(Spliterator<T> spliterator) {
        return new SpliteratorAsCloseableSpliterator<T>(spliterator);
    }

    public static <R> CloseableSpliterator<R> spliterator(Stream<R> stream) {
        return new StreamToCloseableSpliterator<R>(stream);
    }

    public static <R> CloseableIterator<R> iterator(Stream<? extends R> stream) {
        return new StreamToCloseableIterator<R>(stream);
    }

    public static <E> CloseableIterator<E> iterator(Iterator<? extends E> iterator) {
        return new IteratorAsCloseableIterator<E>(iterator);
    }

    public static <E> Stream<E> stream(CloseableSpliterator<E> spliterator, boolean parallel) {
        Stream<E> stream = StreamSupport.stream(spliterator, parallel);
        stream.onClose(spliterator::close);
        return stream;
    }

    public static <E> Stream<E> stream(CloseableIterator<E> iterator, boolean parallel, long size, int characteristics) {
        Stream<E> stream = StreamSupport.stream(Spliterators.spliterator(iterator, size, characteristics), parallel);
        stream.onClose(iterator::close);
        return stream;
    }

    private static class StreamToCloseableSpliterator<T>
    extends SpliteratorAsCloseableSpliterator<T> {
        private final Stream<T> stream;

        public StreamToCloseableSpliterator(Stream<T> stream) {
            super(stream.spliterator());
            this.stream = stream;
        }

        @Override
        public void close() {
            this.stream.close();
        }
    }

    private static class StreamToCloseableIterator<E>
    extends IteratorAsCloseableIterator<E> {
        private final Stream<? extends E> stream;

        public StreamToCloseableIterator(Stream<? extends E> stream) {
            super(stream.iterator());
            this.stream = stream;
        }

        @Override
        public void close() {
            this.stream.close();
        }
    }

    private static class CloseableIteratorAsCloseableSpliterator<E>
    extends SpliteratorAsCloseableSpliterator<E> {
        private final CloseableIterator<? extends E> iterator;

        CloseableIteratorAsCloseableSpliterator(CloseableIterator<? extends E> iterator, long size, int characteristics) {
            super(Spliterators.spliterator(iterator, size, characteristics));
            this.iterator = iterator;
        }

        @Override
        public void close() {
            this.iterator.close();
        }
    }

    private static class SpliteratorAsCloseableSpliterator<T>
    implements CloseableSpliterator<T> {
        private final Spliterator<T> spliterator;

        public SpliteratorAsCloseableSpliterator(Spliterator<T> spliterator) {
            this.spliterator = spliterator;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return this.spliterator.tryAdvance(action);
        }

        @Override
        public Spliterator<T> trySplit() {
            return this.spliterator.trySplit();
        }

        @Override
        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.spliterator.characteristics();
        }
    }

    private static class IteratorAsCloseableIterator<E>
    implements CloseableIterator<E> {
        private final Iterator<? extends E> iterator;

        public IteratorAsCloseableIterator(Iterator<? extends E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

