/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.jdkspecific;

import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.jdkspecific.UnsafeHolder;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.spi.OffHeapMemory;
import sun.misc.Unsafe;

class UnsafeOffHeapMemory
implements OffHeapMemory {
    private static final Log log = LogFactory.getLog(UnsafeOffHeapMemory.class);
    private final ConcurrentHashMap<Long, Long> allocatedBlocks = log.isTraceEnabled() ? new ConcurrentHashMap() : null;
    private static final Unsafe UNSAFE = UnsafeHolder.UNSAFE;
    static final OffHeapMemory INSTANCE = new UnsafeOffHeapMemory();
    private static final int BYTE_ARRAY_BASE_OFFSET = Unsafe.ARRAY_BYTE_BASE_OFFSET;

    private UnsafeOffHeapMemory() {
    }

    @Override
    public byte getByte(long srcAddress, long offset) {
        this.checkAddress(srcAddress, offset + 1L);
        byte value = UNSAFE.getByte(srcAddress + offset);
        if (log.isTraceEnabled()) {
            log.tracef("Read byte value 0x%02x from address 0x%016x+%d", value, srcAddress, offset);
        }
        return value;
    }

    @Override
    public void putByte(long destAddress, long offset, byte value) {
        this.checkAddress(destAddress, offset + 1L);
        if (log.isTraceEnabled()) {
            log.tracef("Wrote byte value 0x%02x to address 0x%016x+%d", value, destAddress, offset);
        }
        UNSAFE.putByte(destAddress + offset, value);
    }

    @Override
    public int getInt(long srcAddress, long offset) {
        this.checkAddress(srcAddress, offset + 4L);
        int value = UNSAFE.getInt(srcAddress + offset);
        if (log.isTraceEnabled()) {
            log.tracef("Read int value 0x%08x from address 0x%016x+%d", value, srcAddress, offset);
        }
        return value;
    }

    @Override
    public void putInt(long destAddress, long offset, int value) {
        this.checkAddress(destAddress, offset + 4L);
        if (log.isTraceEnabled()) {
            log.tracef("Wrote int value 0x%08x to address 0x%016x+%d", value, destAddress, offset);
        }
        UNSAFE.putInt(destAddress + offset, value);
    }

    @Override
    public long getLong(long srcAddress, long offset) {
        return this.getLong(srcAddress, offset, true);
    }

    long getLong(long srcAddress, long offset, boolean alwaysTrace) {
        this.checkAddress(srcAddress, offset + 8L);
        long value = UNSAFE.getLong(srcAddress + offset);
        if (log.isTraceEnabled() && (alwaysTrace || value != 0L)) {
            log.tracef("Read long value 0x%016x from address 0x%016x+%d", value, srcAddress, offset);
        }
        return value;
    }

    @Override
    public long getAndSetLong(long destAddress, long offset, long value) {
        this.checkAddress(destAddress, offset + 8L);
        if (log.isTraceEnabled()) {
            log.tracef("Get and setting long value 0x%016x to address 0x%016x+%d", value, destAddress, offset);
        }
        return UNSAFE.getAndSetLong(null, destAddress + offset, value);
    }

    @Override
    public long getAndSetLongNoTraceIfAbsent(long destAddress, long offset, long value) {
        this.checkAddress(destAddress, offset + 8L);
        long previous = UNSAFE.getAndSetLong(null, destAddress + offset, value);
        if (previous != 0L && log.isTraceEnabled()) {
            log.tracef("Get and set long value 0x%016x to address 0x%016x+%d was 0x%016x", new Object[]{value, destAddress, offset, previous});
        }
        return previous;
    }

    @Override
    public long getLongNoTraceIfAbsent(long srcAddress, long offset) {
        return this.getLong(srcAddress, offset, false);
    }

    @Override
    public void putLong(long destAddress, long offset, long value) {
        this.checkAddress(destAddress, offset + 8L);
        if (log.isTraceEnabled()) {
            log.tracef("Wrote long value 0x%016x to address 0x%016x+%d", value, destAddress, offset);
        }
        UNSAFE.putLong(destAddress + offset, value);
    }

    @Override
    public void getBytes(long srcAddress, long srcOffset, byte[] destArray, long destOffset, long length) {
        this.checkAddress(srcAddress, srcOffset + length);
        if (log.isTraceEnabled()) {
            log.tracef("Read %d bytes from address 0x%016x+%d into array %s+%d", new Object[]{length, srcAddress, srcOffset, destArray, destOffset});
        }
        UNSAFE.copyMemory(null, srcAddress + srcOffset, destArray, (long)BYTE_ARRAY_BASE_OFFSET + destOffset, length);
    }

    @Override
    public void putBytes(byte[] srcArray, long srcOffset, long destAddress, long destOffset, long length) {
        this.checkAddress(destAddress, destOffset + length);
        if (log.isTraceEnabled()) {
            log.tracef("Wrote %d bytes from array %s+%d to address 0x%016x+%d", new Object[]{length, srcArray, srcOffset, destAddress, destOffset});
        }
        UNSAFE.copyMemory(srcArray, (long)BYTE_ARRAY_BASE_OFFSET + srcOffset, null, destAddress + destOffset, length);
    }

    @Override
    public void copy(long srcAddress, long srcOffset, long destAddress, long destOffset, long length) {
        this.checkAddress(srcAddress, srcOffset + length);
        this.checkAddress(destAddress, destOffset + length);
        if (log.isTraceEnabled()) {
            log.tracef("Copying %d bytes from address 0x%016x+%d to address 0x%016x+%d", new Object[]{length, srcAddress, srcOffset, destAddress, destOffset});
        }
        UNSAFE.copyMemory(srcAddress + srcOffset, destAddress + destOffset, length);
    }

    private void checkAddress(long address, long offset) {
        if (!log.isTraceEnabled()) {
            return;
        }
        Long blockSize = this.allocatedBlocks.get(address);
        if (blockSize == null || blockSize < offset) {
            throw new IllegalArgumentException(String.format("Trying to access address 0x%016x+%d, but blockSize was %d", address, offset, blockSize));
        }
    }

    @Override
    public long allocate(long size) {
        Long prev;
        long address = UNSAFE.allocateMemory(size);
        if (log.isTraceEnabled() && (prev = this.allocatedBlocks.put(address, size)) != null) {
            throw new IllegalArgumentException();
        }
        return address;
    }

    @Override
    public void free(long address) {
        Long prev;
        if (log.isTraceEnabled() && (prev = this.allocatedBlocks.remove(address)) == null) {
            throw new IllegalArgumentException();
        }
        UNSAFE.freeMemory(address);
    }

    @Override
    public void setMemory(long address, long bytes, byte value) {
        this.checkAddress(address, bytes);
        UNSAFE.setMemory(address, bytes, value);
    }
}

