/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.commons.maven.AbstractArtifact;
import org.infinispan.commons.maven.MavenSettings;

public final class MavenArtifact
extends AbstractArtifact {
    static final Pattern snapshotPattern = Pattern.compile("-\\d{8}\\.\\d{6}-\\d+$");
    private static final Pattern VALID_PATTERN = Pattern.compile("^([-_a-zA-Z0-9.]+):([-_a-zA-Z0-9.]+):([-_a-zA-Z0-9.]+)(?::([-_a-zA-Z0-9.]+))?$");
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private String toString;

    public MavenArtifact(String groupId, String artifactId, String version, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
    }

    public MavenArtifact(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, "");
    }

    public static MavenArtifact fromString(String string) {
        Matcher matcher = VALID_PATTERN.matcher(string);
        if (matcher.matches()) {
            if (matcher.group(4) != null) {
                return new MavenArtifact(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4));
            }
            return new MavenArtifact(matcher.group(1), matcher.group(2), matcher.group(3));
        }
        throw new IllegalArgumentException(string);
    }

    public static boolean isMavenArtifact(String string) {
        return VALID_PATTERN.matcher(string).matches();
    }

    @Override
    public Path resolveArtifact() throws IOException {
        return this.resolveArtifact("jar");
    }

    public Path resolveArtifact(String packaging) throws IOException {
        String artifactRelativePath = this.relativeArtifactPath(File.separatorChar);
        String artifactRelativeHttpPath = this.relativeArtifactPath('/');
        MavenSettings settings = MavenSettings.init();
        Path localRepository = settings.getLocalRepository();
        String pomPath = artifactRelativePath + ".pom";
        if ("pom".equals(packaging)) {
            Path pom = localRepository.resolve(pomPath);
            if (Files.exists(pom, new LinkOption[0])) {
                return pom;
            }
            List<String> remoteRepos = settings.getRemoteRepositories();
            if (remoteRepos.isEmpty()) {
                return null;
            }
            for (String remoteRepository : remoteRepos) {
                try {
                    String remotePomPath = remoteRepository + artifactRelativeHttpPath + ".pom";
                    MavenArtifact.downloadFile(new URL(remotePomPath), pom, this.verbose, this.force);
                    if (!Files.exists(pom, new LinkOption[0])) continue;
                    return pom;
                }
                catch (IOException e) {
                    System.out.printf("Could not download '%s' from '%s' repository (%s)%n", artifactRelativePath, remoteRepository, e.getMessage());
                }
            }
        } else {
            Object classifier = this.classifier.isEmpty() ? "" : "-" + this.classifier;
            String artifactPath = artifactRelativePath + (String)classifier + "." + packaging;
            Path fp = localRepository.resolve(artifactPath);
            if (Files.exists(fp, new LinkOption[0]) && !this.force) {
                return fp;
            }
            List<String> remoteRepos = settings.getRemoteRepositories();
            if (remoteRepos.isEmpty()) {
                return null;
            }
            Path artifact = localRepository.resolve(artifactPath);
            Path pom = localRepository.resolve(pomPath);
            for (String remoteRepository : remoteRepos) {
                try {
                    String remotePomPath = remoteRepository + artifactRelativeHttpPath + ".pom";
                    String remoteArtifactPath = remoteRepository + artifactRelativeHttpPath + (String)classifier + "." + packaging;
                    MavenArtifact.downloadFile(new URL(remotePomPath), pom, this.verbose, this.force);
                    if (!Files.exists(pom, new LinkOption[0])) continue;
                    MavenArtifact.downloadFile(new URL(remoteArtifactPath), artifact, this.verbose, this.force);
                    if (!Files.exists(artifact, new LinkOption[0])) continue;
                    return artifact;
                }
                catch (IOException e) {
                    System.out.printf("Could not download '%s' from '%s' repository%n", artifactRelativePath, remoteRepository);
                }
            }
        }
        if (this.verbose) {
            System.out.println("Could not find in any remote repository");
        }
        return null;
    }

    public String relativeArtifactPath(char separator) {
        StringBuilder builder = new StringBuilder(this.groupId.replace('.', separator));
        builder.append(separator).append(this.artifactId).append(separator);
        Matcher versionMatcher = snapshotPattern.matcher(this.version);
        Object pathVersion = versionMatcher.find() ? this.version.substring(0, versionMatcher.start()) + "-SNAPSHOT" : this.version;
        builder.append((String)pathVersion).append(separator).append(this.artifactId).append('-').append(this.version);
        return builder.toString();
    }

    public String toString() {
        String toString = this.toString;
        if (toString == null) {
            StringBuilder b = new StringBuilder(this.groupId.length() + this.artifactId.length() + this.version.length() + this.classifier.length() + 16);
            b.append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
            if (!this.classifier.isEmpty()) {
                b.append(':').append(this.classifier);
            }
            this.toString = toString = b.toString();
        }
        return toString;
    }
}

