/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.internal;

import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.StampedLock;
import java.util.logging.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.infinispan.commons.dataconversion.MediaTypeResolver;
import org.infinispan.commons.executors.NonBlockingResource;
import org.infinispan.commons.internal.BlockHoundUtil;
import org.infinispan.commons.util.ProgressTracker;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.commons.util.concurrent.NonBlockingRejectedExecutionHandler;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;

public class CommonsBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        builder.nonBlockingThreadPredicate(current -> current.or(thread -> thread.getThreadGroup() instanceof NonBlockingResource));
        builder.markAsBlocking(BlockHoundUtil.class, "pretendBlock", "()V");
        builder.disallowBlockingCallsInside(NonBlockingRejectedExecutionHandler.class.getName(), "rejectedExecution");
        builder.allowBlockingCallsInside(SslContextFactory.class.getName(), "loadKeyStore");
        builder.allowBlockingCallsInside(SslContextFactory.class.getName(), "getContext");
        builder.allowBlockingCallsInside(MediaTypeResolver.class.getName(), "populateFileMap");
        builder.allowBlockingCallsInside(ServiceFinder.class.getName(), "load");
        builder.allowBlockingCallsInside("com.github.benmanes.caffeine.cache.BoundedLocalCache", "performCleanUp");
        builder.allowBlockingCallsInside(ReferenceQueue.class.getName(), "poll");
        builder.allowBlockingCallsInside(ProgressTracker.class.getName(), "addTasks");
        builder.allowBlockingCallsInside(ProgressTracker.class.getName(), "removeTasks");
        builder.allowBlockingCallsInside(ProgressTracker.class.getName(), "finishedAllTasks");
        CommonsBlockHoundIntegration.handleJREClasses(builder);
        CommonsBlockHoundIntegration.log4j(builder);
    }

    public static void allowPublicMethodsToBlock(BlockHound.Builder builder, Class<?> clazz) {
        CommonsBlockHoundIntegration.allowMethodsToBlock(builder, clazz, true);
    }

    public static void allowMethodsToBlock(BlockHound.Builder builder, Class<?> clazz, boolean publicOnly) {
        Method[] methods;
        for (Method method : methods = publicOnly ? clazz.getMethods() : clazz.getDeclaredMethods()) {
            builder.allowBlockingCallsInside(clazz.getName(), method.getName());
        }
    }

    private static void handleJREClasses(BlockHound.Builder builder) {
        builder.allowBlockingCallsInside(ForkJoinPool.class.getName(), "runWorker");
        builder.disallowBlockingCallsInside(ForkJoinPool.class.getName(), "scan");
        builder.allowBlockingCallsInside(StampedLock.class.getName(), "tryDecReaderOverflow");
        builder.allowBlockingCallsInside(SecureRandom.class.getName(), "nextBytes");
        CommonsBlockHoundIntegration.allowMethodsToBlock(builder, ThreadPoolExecutor.class, true);
        CommonsBlockHoundIntegration.allowMethodsToBlock(builder, ScheduledThreadPoolExecutor.class, true);
        builder.allowBlockingCallsInside(ThreadPoolExecutor.class.getName(), "getTask");
        builder.allowBlockingCallsInside(ThreadPoolExecutor.class.getName(), "processWorkerExit");
        builder.allowBlockingCallsInside(Logger.class.getName(), "log");
        builder.allowBlockingCallsInside(ArrayBlockingQueue.class.getName(), "offer");
    }

    private static void log4j(BlockHound.Builder builder) {
        try {
            Class.forName("org.apache.logging.log4j.spi.AbstractLogger");
            builder.allowBlockingCallsInside(AbstractLogger.class.getName(), "logMessage");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        builder.allowBlockingCallsInside("org.apache.logging.log4j.core.Logger", "logMessage");
        builder.allowBlockingCallsInside(org.jboss.logging.Logger.class.getName(), "getMessageLogger");
    }
}

