/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.infinispan.commons.util.ImmutableListCopy;
import org.infinispan.commons.util.TypedProperties;

public class Immutables {
    public static <T> List<T> immutableListConvert(Collection<? extends T> source) {
        return new ImmutableListCopy<T>(source);
    }

    public static TypedProperties immutableTypedProperties(TypedProperties properties) {
        if (properties == null) {
            return null;
        }
        return new ImmutableTypedProperties(properties);
    }

    public static <T> List<T> immutableListWrap(T ... array) {
        return new ImmutableListCopy<T>(array);
    }

    public static <T> ImmutableListCopy<T> immutableListAdd(List<T> list, int position, T element) {
        int i;
        Object[] copy = new Object[list.size() + 1];
        for (i = 0; i < position; ++i) {
            copy[i] = list.get(i);
        }
        copy[position] = element;
        for (i = position; i < list.size(); ++i) {
            copy[i + 1] = list.get(i);
        }
        return new ImmutableListCopy<Object>(copy);
    }

    public static <T> ImmutableListCopy<T> immutableListReplace(List<T> list, int position, T element) {
        int i;
        Object[] copy = new Object[list.size()];
        for (i = 0; i < position; ++i) {
            copy[i] = list.get(i);
        }
        copy[position] = element;
        for (i = position + 1; i < list.size(); ++i) {
            copy[i] = list.get(i);
        }
        return new ImmutableListCopy<Object>(copy);
    }

    public static <T> List<T> immutableListRemove(List<T> list, int position) {
        int i;
        Object[] copy = new Object[list.size() - 1];
        for (i = 0; i < position; ++i) {
            copy[i] = list.get(i);
        }
        for (i = position + 1; i < list.size(); ++i) {
            copy[i - 1] = list.get(i);
        }
        return new ImmutableListCopy<Object>(copy);
    }

    public static <T> Set<T> immutableSetWrap(Set<? extends T> set) {
        return new ImmutableSetWrapper<T>(set);
    }

    public static <K, V> Map<K, V> immutableMapWrap(Map<? extends K, ? extends V> map) {
        return new ImmutableMapWrapper<K, V>(map);
    }

    private static class ImmutableTypedProperties
    extends TypedProperties {
        ImmutableTypedProperties(TypedProperties properties) {
            if (properties != null && !properties.isEmpty()) {
                for (Map.Entry<Object, Object> e : properties.entrySet()) {
                    super.put(e.getKey(), e.getValue());
                }
            }
        }

        @Override
        public synchronized void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return new ImmutableEntrySetWrapper<Object, Object>(super.entrySet());
        }

        @Override
        public Set<Object> keySet() {
            return new ImmutableSetWrapper<Object>(super.keySet());
        }

        @Override
        public synchronized void load(InputStream inStream) {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void load(Reader reader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void loadFromXML(InputStream in) {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void putAll(Map<?, ?> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized TypedProperties setProperty(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> stringPropertyNames() {
            return new ImmutableSetWrapper<String>(super.stringPropertyNames());
        }

        @Override
        public Collection<Object> values() {
            return new ImmutableCollectionWrapper<Object>(super.values());
        }
    }

    private static class ImmutableSetWrapper<E>
    extends ImmutableCollectionWrapper<E>
    implements Set<E>,
    Serializable,
    Immutable {
        private static final long serialVersionUID = 7991492805176142615L;

        public ImmutableSetWrapper(Set<? extends E> set) {
            super(set);
        }
    }

    public static class ImmutableMapWrapper<K, V>
    implements Map<K, V>,
    Serializable,
    Immutable {
        private static final long serialVersionUID = 708144227046742221L;
        private final Map<? extends K, ? extends V> map;

        public ImmutableMapWrapper(Map<? extends K, ? extends V> map) {
            this.map = map;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new ImmutableEntrySetWrapper<K, V>(this.map.entrySet());
        }

        @Override
        public boolean equals(Object o) {
            return this.map.equals(o);
        }

        @Override
        public V get(Object key) {
            return this.map.get(key);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return new ImmutableSetWrapper<K>(this.map.keySet());
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Collection<V> values() {
            return new ImmutableCollectionWrapper<V>(this.map.values());
        }

        public String toString() {
            return this.map.toString();
        }
    }

    private static class ImmutableEntrySetWrapper<K, V>
    extends ImmutableSetWrapper<Map.Entry<K, V>> {
        private static final long serialVersionUID = 6378667653889667692L;

        public ImmutableEntrySetWrapper(Set<? extends Map.Entry<? extends K, ? extends V>> set) {
            super(set);
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.collection.size()];
            int i = 0;
            for (Map.Entry<K, V> entry : this) {
                array[i++] = entry;
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int size = this.collection.size();
            if (array.length < size) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            }
            int i = 0;
            T[] result = array;
            for (Map.Entry<K, V> entry : this) {
                result[i++] = entry;
            }
            return array;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ImmutableIteratorWrapper<Map.Entry<K, V>>(this.collection.iterator()){

                @Override
                public Map.Entry<K, V> next() {
                    return new ImmutableEntry((Map.Entry)super.next());
                }
            };
        }
    }

    private static class ImmutableEntry<K, V>
    implements Map.Entry<K, V>,
    Immutable {
        private final K key;
        private final V value;
        private final int hash;

        ImmutableEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
            this.hash = entry.hashCode();
        }

        ImmutableEntry(K key, V value) {
            this.key = key;
            this.value = value;
            this.hash = Objects.hashCode(key) ^ Objects.hashCode(value);
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        private static boolean eq(Object o1, Object o2) {
            return Objects.equals(o1, o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return ImmutableEntry.eq(entry.getKey(), this.key) && ImmutableEntry.eq(entry.getValue(), this.value);
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }
    }

    private static class ImmutableCollectionWrapper<E>
    implements Collection<E>,
    Serializable,
    Immutable {
        private static final long serialVersionUID = 6777564328198393535L;
        Collection<? extends E> collection;

        public ImmutableCollectionWrapper(Collection<? extends E> collection) {
            this.collection = collection;
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.collection.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.collection.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            return this.collection.equals(o);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new ImmutableIteratorWrapper<E>(this.collection.iterator());
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public Object[] toArray() {
            return this.collection.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.collection.toArray(a);
        }

        public String toString() {
            return this.collection.toString();
        }
    }

    public static class ImmutableIteratorWrapper<E>
    implements Iterator<E> {
        private final Iterator<? extends E> iterator;

        public ImmutableIteratorWrapper(Iterator<? extends E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            this.iterator.forEachRemaining(action);
        }
    }

    public static interface Immutable {
    }
}

