/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test.skip;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.infinispan.commons.test.skip.OS;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipJunit
implements TestRule {
    private final OS[] oses;
    private final int jdkMajorVersion;

    public SkipJunit(OS ... oses) {
        this.oses = Objects.requireNonNull(oses);
        this.jdkMajorVersion = -1;
    }

    public SkipJunit(int jdkMajorVersion) {
        this.jdkMajorVersion = jdkMajorVersion;
        this.oses = null;
    }

    public Statement apply(Statement base, final Description description) {
        if (this.oses != null) {
            final OS os = OS.getCurrentOs();
            if (!Arrays.asList(this.oses).contains((Object)os)) {
                return base;
            }
            return new Statement(this){
                final /* synthetic */ SkipJunit this$0;
                {
                    this.this$0 = this$0;
                }

                public void evaluate() {
                    throw new AssumptionViolatedException("Ignoring test " + description.getDisplayName() + " on OS " + String.valueOf((Object)os));
                }
            };
        }
        final int version = SkipJunit.getJDKVersion();
        if (version >= this.jdkMajorVersion) {
            return new Statement(this){
                final /* synthetic */ SkipJunit this$0;
                {
                    this.this$0 = this$0;
                }

                public void evaluate() {
                    throw new AssumptionViolatedException("Ignoring test " + description.getDisplayName() + " on JDK " + version);
                }
            };
        }
        return base;
    }

    public static void skipOnOS(OS ... oses) {
        OS os = OS.getCurrentOs();
        if (Arrays.asList(oses).contains((Object)os)) {
            throw new AssumptionViolatedException("Skipping test on " + String.valueOf((Object)os));
        }
    }

    public static void onlyOnOS(OS ... oses) {
        OS os = OS.getCurrentOs();
        if (!Arrays.asList(oses).contains((Object)os)) {
            throw new AssumptionViolatedException("Skipping test on " + String.valueOf((Object)os));
        }
    }

    public static void skipSinceJDK(int major) {
        int version = SkipJunit.getJDKVersion();
        if (version >= major) {
            throw new AssumptionViolatedException("Skipping test on JDK " + version);
        }
    }

    private static int getJDKVersion() {
        String[] parts = System.getProperty("java.version").replaceAll("[^0-9\\.]", "").split("\\.");
        int version = Integer.parseInt(parts[0]);
        if (version == 1) {
            version = Integer.parseInt(parts[1]);
        }
        return version;
    }

    public static void skipCondition(Supplier<Boolean> condition) {
        if (condition.get().booleanValue()) {
            throw new AssumptionViolatedException("Skipping test");
        }
    }
}

