/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.infinispan.commons.test.BlockHoundHelper;
import org.infinispan.commons.test.TestSuiteProgress;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.jboss.logging.Logger;
import org.testng.IAnnotationTransformer;
import org.testng.IConfigurationListener2;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.Test;
import org.testng.xml.XmlClass;

public class TestNGTestListener
implements ITestListener,
IConfigurationListener2,
ISuiteListener,
IAnnotationTransformer {
    static final long MAX_TEST_SECONDS = Long.parseUnsignedLong(System.getProperty("infinispan.test.maxTestSeconds", "300"));
    private static final Logger log = Logger.getLogger(TestNGTestListener.class);
    private final TestSuiteProgress progressLogger = new TestSuiteProgress();

    public void onTestStart(ITestResult result) {
        this.progressLogger.testStarted(this.testName(result));
    }

    public void onTestSuccess(ITestResult result) {
        this.progressLogger.testSucceeded(this.testName(result));
    }

    public void onTestFailure(ITestResult result) {
        this.progressLogger.testFailed(this.testName(result), result.getThrowable());
    }

    public void onTestSkipped(ITestResult result) {
        this.progressLogger.testIgnored(this.testName(result));
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.progressLogger.testFailed(this.testName(result), result.getThrowable());
    }

    public void onStart(ITestContext context) {
        Thread.currentThread().setName("TestNG-" + context.getName());
        ThreadLeakChecker.testStarted(((XmlClass)context.getCurrentXmlTest().getXmlClasses().get(0)).getName());
    }

    public void onFinish(ITestContext context) {
        String testName = ((XmlClass)context.getCurrentXmlTest().getXmlClasses().get(0)).getName();
        ThreadLeakChecker.testFinished(testName);
    }

    private String testName(ITestResult res) {
        StringBuilder result = new StringBuilder();
        if (res.getInstanceName().contains(res.getMethod().getMethodName())) {
            result.append(res.getTestClass().getName());
        } else {
            result.append(res.getInstanceName());
        }
        result.append(".").append(res.getMethod().getMethodName());
        if (res.getMethod().getConstructorOrMethod().getMethod().isAnnotationPresent(Test.class)) {
            String dataProviderName = res.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class).dataProvider();
            if (res.getParameters().length != 0 && !dataProviderName.isEmpty()) {
                result.append("(").append(Arrays.deepToString(res.getParameters())).append(")");
            }
        }
        return result.toString();
    }

    public void onStart(ISuite suite) {
        try {
            Class.forName("reactor.blockhound.BlockHound");
            log.info((Object)"BlockHound on classpath, installing non blocking checks!");
            BlockHoundHelper.installBlockHound();
        }
        catch (ClassNotFoundException e) {
            log.info((Object)"BlockHound not on classpath, not enabling");
        }
        ThreadLeakChecker.saveInitialThreads();
    }

    public void onFinish(ISuite suite) {
        ThreadLeakChecker.checkForLeaks("");
    }

    public void beforeConfiguration(ITestResult testResult) {
        this.progressLogger.configurationStarted(this.testName(testResult));
    }

    public void onConfigurationSuccess(ITestResult testResult) {
        this.progressLogger.configurationFinished(this.testName(testResult));
    }

    public void onConfigurationFailure(ITestResult testResult) {
        if (testResult.getThrowable() != null) {
            this.progressLogger.configurationFailed(this.testName(testResult), testResult.getThrowable());
        }
    }

    public void onConfigurationSkip(ITestResult testResult) {
        if (testResult.getThrowable() != null) {
            this.progressLogger.testIgnored(this.testName(testResult));
        }
    }

    public void transform(ITestAnnotation annotation, Class testClass, Constructor testConstructor, Method testMethod) {
        Class<?> clazz;
        Class<Object> clazz2 = testClass != null ? testClass : (testMethod != null ? testMethod.getDeclaringClass() : (clazz = testConstructor != null ? testConstructor.getDeclaringClass() : null));
        if ((clazz.getName().startsWith("org.infinispan.spring.embedded.provider") || clazz.getName().startsWith("org.infinispan.spring.embedded.support")) && annotation.getExpectedExceptions() != null) {
            return;
        }
        if (annotation.getTimeOut() == 0L) {
            log.tracef("Setting timeout for test %s to %d seconds", (Object)testMethod, (Object)MAX_TEST_SECONDS);
            annotation.setTimeOut(MAX_TEST_SECONDS * 1000L);
        }
    }
}

