/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.logging.log4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;

public class CompressedFileManager
extends FileManager {
    private static final CompressedFileManagerFactory FACTORY = new CompressedFileManagerFactory();

    protected CompressedFileManager(String fileName, OutputStream os, boolean append, boolean locking, String advertiseURI, Layout<? extends Serializable> layout, int bufferSize, boolean writerHeader) {
        super(fileName, os, append, locking, advertiseURI, layout, bufferSize, writerHeader);
    }

    public static CompressedFileManager getFileManager(String fileName, boolean append, boolean locking, boolean bufferedIo, String advertiseUri, Layout<? extends Serializable> layout, int bufferSize, int compressionLevel) {
        if (locking && bufferedIo) {
            locking = false;
        }
        return (CompressedFileManager)CompressedFileManager.getManager((String)fileName, (Object)new FactoryData(append, locking, bufferedIo, bufferSize, advertiseUri, layout, compressionLevel), (ManagerFactory)FACTORY);
    }

    private static class FactoryData {
        private final boolean append;
        private final boolean locking;
        private final boolean bufferedIO;
        private final int bufferSize;
        private final String advertiseURI;
        private final Layout<? extends Serializable> layout;
        public final int compressionLevel;

        public FactoryData(boolean append, boolean locking, boolean bufferedIO, int bufferSize, String advertiseURI, Layout<? extends Serializable> layout, int compressionLevel) {
            this.append = append;
            this.locking = locking;
            this.bufferedIO = bufferedIO;
            this.bufferSize = bufferSize;
            this.advertiseURI = advertiseURI;
            this.layout = layout;
            this.compressionLevel = compressionLevel;
        }
    }

    private static class CompressedFileManagerFactory
    implements ManagerFactory<CompressedFileManager, FactoryData> {
        private CompressedFileManagerFactory() {
        }

        public CompressedFileManager createManager(String name, final FactoryData data) {
            File file = new File(name);
            File parent = file.getParentFile();
            if (null != parent && !parent.exists()) {
                parent.mkdirs();
            }
            try {
                OutputStream os = new FileOutputStream(name, data.append);
                int bufferSize = data.bufferSize;
                os = new GZIPOutputStream(this, os, bufferSize, false){
                    final /* synthetic */ CompressedFileManagerFactory this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0, arg1, arg2);
                        this.def.setLevel(data.compressionLevel);
                    }
                };
                boolean writeHeader = !data.append || !file.exists();
                return new CompressedFileManager(name, os, data.append, data.locking, data.advertiseURI, data.layout, bufferSize, writeHeader);
            }
            catch (IOException ex) {
                LOGGER.error("FileManager (" + name + ") " + String.valueOf(ex));
                return null;
            }
        }
    }
}

