/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk;

import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.XSiteStateTransferMode;
import org.infinispan.client.rest.impl.jdk.RestRawClientJDK;
import org.infinispan.client.rest.impl.jdk.Util;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;

public class RestCacheClientJDK
implements RestCacheClient {
    private final RestRawClientJDK client;
    private final String name;
    private final String path;
    private final String rollingUpgradeUrl;

    RestCacheClientJDK(RestRawClientJDK client, String name) {
        this.client = client;
        this.name = name;
        this.path = client.getConfiguration().contextPath() + "/v2/caches/" + Util.sanitize(name);
        this.rollingUpgradeUrl = this.path + "/rolling-upgrade";
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public CompletionStage<RestResponse> health() {
        return this.client.get(this.path + "?action=health");
    }

    @Override
    public CompletionStage<RestResponse> clear() {
        return this.client.post(this.path + "?action=clear");
    }

    @Override
    public CompletionStage<RestResponse> exists() {
        return this.client.head(this.path);
    }

    @Override
    public CompletionStage<RestResponse> synchronizeData(Integer readBatch, Integer threads) {
        StringBuilder sb = new StringBuilder(this.path + "?action=sync-data");
        if (readBatch != null) {
            sb.append("&read-batch=").append(readBatch);
        }
        if (threads != null) {
            sb.append("&threads=").append(threads);
        }
        return this.client.post(sb.toString());
    }

    @Override
    public CompletionStage<RestResponse> synchronizeData() {
        return this.synchronizeData(null, null);
    }

    @Override
    public CompletionStage<RestResponse> disconnectSource() {
        return this.client.delete(this.rollingUpgradeUrl + "/source-connection");
    }

    @Override
    public CompletionStage<RestResponse> connectSource(RestEntity value) {
        return this.client.post(this.rollingUpgradeUrl + "/source-connection", value);
    }

    @Override
    public CompletionStage<RestResponse> sourceConnected() {
        return this.client.head(this.rollingUpgradeUrl + "/source-connection");
    }

    @Override
    public CompletionStage<RestResponse> sourceConnection() {
        return this.client.get(this.rollingUpgradeUrl + "/source-connection");
    }

    @Override
    public CompletionStage<RestResponse> size() {
        return this.client.get(this.path + "?action=size");
    }

    @Override
    public CompletionStage<RestResponse> post(String key, String value) {
        return this.client.post(this.path + "/" + Util.sanitize(key), RestEntity.create(MediaType.TEXT_PLAIN, value));
    }

    @Override
    public CompletionStage<RestResponse> post(String key, RestEntity value) {
        return this.client.post(this.path + "/" + Util.sanitize(key), value);
    }

    @Override
    public CompletionStage<RestResponse> post(String key, String value, long ttl, long maxIdle) {
        return this.client.post(this.path + "/" + Util.sanitize(key), this.expiration(ttl, maxIdle), RestEntity.create(MediaType.TEXT_PLAIN, value));
    }

    @Override
    public CompletionStage<RestResponse> post(String key, RestEntity value, long ttl, long maxIdle) {
        return this.client.post(this.path + "/" + Util.sanitize(key), this.expiration(ttl, maxIdle), value);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, String value) {
        return this.client.put(this.path + "/" + Util.sanitize(key), RestEntity.create(MediaType.TEXT_PLAIN, value));
    }

    @Override
    public CompletionStage<RestResponse> put(String key, String keyContentType, RestEntity value) {
        return this.client.put(this.path + "/" + Util.sanitize(key), keyContentType != null ? Map.of("Key-Content-Type", keyContentType) : Collections.emptyMap(), value);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, String keyContentType, RestEntity value, Map<String, String> headers) {
        if (keyContentType != null) {
            headers.put("Key-Content-Type", keyContentType);
        }
        return this.client.put(this.path + "/" + Util.sanitize(key), headers, value);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, String keyContentType, RestEntity value, long ttl, long maxIdle) {
        Map<String, String> headers = this.expiration(ttl, maxIdle);
        if (keyContentType != null) {
            headers.put("Key-Content-Type", keyContentType);
        }
        return this.client.put(this.path + "/" + Util.sanitize(key), headers, value);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, RestEntity value, String ... flags) {
        return this.client.put(this.path + "/" + Util.sanitize(key), flags.length > 0 ? Map.of("flags", String.join((CharSequence)",", flags)) : Collections.emptyMap(), value);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, RestEntity value) {
        return this.client.put(this.path + "/" + Util.sanitize(key), value);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, String value, long ttl, long maxIdle) {
        return this.client.post(this.path + "/" + Util.sanitize(key), this.expiration(ttl, maxIdle), RestEntity.create(MediaType.TEXT_PLAIN, value));
    }

    @Override
    public CompletionStage<RestResponse> put(String key, RestEntity value, long ttl, long maxIdle) {
        return this.client.put(this.path + "/" + Util.sanitize(key), this.expiration(ttl, maxIdle), value);
    }

    @Override
    public CompletionStage<RestResponse> get(String key) {
        return this.client.get(this.path + "/" + Util.sanitize(key));
    }

    @Override
    public CompletionStage<RestResponse> get(String key, Map<String, String> headers) {
        return this.client.get(this.path + "/" + Util.sanitize(key), headers);
    }

    @Override
    public CompletionStage<RestResponse> get(String key, String mediaType) {
        return this.get(key, mediaType, false);
    }

    @Override
    public CompletionStage<RestResponse> get(String key, String mediaType, boolean extended) {
        String url = this.path + "/" + Util.sanitize(key);
        if (extended) {
            url = url + "?extended=true";
        }
        return this.client.get(url, mediaType != null ? Map.of("Accept", mediaType) : Collections.emptyMap());
    }

    @Override
    public CompletionStage<RestResponse> head(String key) {
        return this.head(key, Collections.emptyMap());
    }

    @Override
    public CompletionStage<RestResponse> head(String key, Map<String, String> headers) {
        return this.client.head(this.path + "/" + Util.sanitize(key) + "?extended", headers);
    }

    @Override
    public CompletionStage<RestResponse> remove(String key) {
        return this.remove(key, Collections.emptyMap());
    }

    @Override
    public CompletionStage<RestResponse> remove(String key, Map<String, String> headers) {
        return this.client.delete(this.path + "/" + Util.sanitize(key) + "?extended", headers);
    }

    @Override
    public CompletionStage<RestResponse> createWithTemplate(String template, CacheContainerAdmin.AdminFlag ... flags) {
        return this.client.post(this.path + "?template=" + template, this.enums("flags", (Enum<?>[])flags));
    }

    @Override
    public CompletionStage<RestResponse> createWithConfiguration(RestEntity configuration, CacheContainerAdmin.AdminFlag ... flags) {
        return this.client.post(this.path, this.enums("flags", (Enum<?>[])flags), configuration);
    }

    @Override
    public CompletionStage<RestResponse> delete() {
        return this.client.delete(this.path);
    }

    @Override
    public CompletionStage<RestResponse> keys() {
        return this.client.get(this.path + "?action=keys", Collections.emptyMap(), HttpResponse.BodyHandlers::ofInputStream);
    }

    @Override
    public CompletionStage<RestResponse> keys(int limit) {
        return this.client.get(this.path + "?action=keys&limit=" + limit, Collections.emptyMap(), HttpResponse.BodyHandlers::ofInputStream);
    }

    @Override
    public CompletionStage<RestResponse> entries() {
        return this.client.get(this.path + "?action=entries", Collections.emptyMap(), HttpResponse.BodyHandlers::ofInputStream);
    }

    @Override
    public CompletionStage<RestResponse> entries(boolean contentNegotiation) {
        return this.client.get(this.path + "?action=entries&content-negotiation=" + contentNegotiation, Collections.emptyMap(), HttpResponse.BodyHandlers::ofInputStream);
    }

    @Override
    public CompletionStage<RestResponse> entries(int limit) {
        return this.client.get(this.path + "?action=entries&limit=" + limit, Collections.emptyMap(), HttpResponse.BodyHandlers::ofInputStream);
    }

    @Override
    public CompletionStage<RestResponse> entries(int limit, boolean metadata) {
        return this.client.get(this.path + "?action=entries&metadata=" + metadata + "&limit=" + limit, Collections.emptyMap(), HttpResponse.BodyHandlers::ofInputStream);
    }

    @Override
    public CompletionStage<RestResponse> keys(String mediaType) {
        return this.client.get(this.path + "?action=keys", Map.of("Accept", mediaType), HttpResponse.BodyHandlers::ofInputStream);
    }

    @Override
    public CompletionStage<RestResponse> configuration(String mediaType) {
        return this.client.get(this.path + "?action=config", mediaType != null ? Map.of("Accept", mediaType) : Collections.emptyMap());
    }

    @Override
    public CompletionStage<RestResponse> stats() {
        return this.client.get(this.path + "?action=stats");
    }

    @Override
    public CompletionStage<RestResponse> statsReset() {
        return this.client.post(this.path + "?action=stats-reset");
    }

    @Override
    public CompletionStage<RestResponse> distribution() {
        return this.client.get(this.path + "?action=distribution");
    }

    @Override
    public CompletionStage<RestResponse> distribution(String key) {
        return this.client.get(this.path + "/" + Util.sanitize(key) + "?action=distribution");
    }

    @Override
    public CompletionStage<RestResponse> query(String query, boolean local) {
        return this.client.get(this.path + "?action=search&query=" + Util.sanitize(query) + "&local=" + local);
    }

    @Override
    public CompletionStage<RestResponse> deleteByQuery(String query, boolean local) {
        return this.client.delete(this.path + "?action=deleteByQuery&query=" + Util.sanitize(query) + "&local=" + local);
    }

    @Override
    public CompletionStage<RestResponse> query(String query, int maxResults, int offset) {
        return this.query(query, maxResults, offset, -1);
    }

    @Override
    public CompletionStage<RestResponse> query(String query, int maxResults, int offset, int hitCountAccuracy) {
        StringBuilder sb = new StringBuilder(this.path).append("?action=search&query=").append(Util.sanitize(query));
        if (maxResults > 0) {
            sb.append("&max_results=").append(maxResults);
        }
        if (offset >= 0) {
            sb.append("&offset=").append(offset);
        }
        if (hitCountAccuracy >= 0) {
            sb.append("&hit_count_accuracy=").append(hitCountAccuracy);
        }
        return this.client.get(sb.toString());
    }

    @Override
    public CompletionStage<RestResponse> xsiteBackups() {
        return this.client.get(String.format("%s/x-site/backups/", this.path));
    }

    @Override
    public CompletionStage<RestResponse> backupStatus(String site) {
        return this.client.get(String.format("%s/x-site/backups/%s", this.path, site));
    }

    @Override
    public CompletionStage<RestResponse> takeSiteOffline(String site) {
        return this.executeXSiteOperation(site, "take-offline");
    }

    @Override
    public CompletionStage<RestResponse> bringSiteOnline(String site) {
        return this.executeXSiteOperation(site, "bring-online");
    }

    @Override
    public CompletionStage<RestResponse> pushSiteState(String site) {
        return this.executeXSiteOperation(site, "start-push-state");
    }

    @Override
    public CompletionStage<RestResponse> cancelPushState(String site) {
        return this.executeXSiteOperation(site, "cancel-push-state");
    }

    @Override
    public CompletionStage<RestResponse> cancelReceiveState(String site) {
        return this.client.post(String.format("%s/x-site/backups/%s?action=%s", this.path, site, "cancel-receive-state"));
    }

    @Override
    public CompletionStage<RestResponse> pushStateStatus() {
        return this.client.get(String.format("%s/x-site/backups?action=push-state-status", this.path));
    }

    @Override
    public CompletionStage<RestResponse> clearPushStateStatus() {
        return this.client.post(String.format("%s/x-site/local?action=clear-push-state-status", this.path));
    }

    @Override
    public CompletionStage<RestResponse> getXSiteTakeOfflineConfig(String site) {
        return this.client.get(String.format("%s/x-site/backups/%s/take-offline-config", this.path, site));
    }

    @Override
    public CompletionStage<RestResponse> updateXSiteTakeOfflineConfig(String site, int afterFailures, long minTimeToWait) {
        String url = String.format("%s/x-site/backups/%s/take-offline-config", this.path, site);
        String body = String.format("{\"after_failures\":%d,\"min_wait\":%d}", afterFailures, minTimeToWait);
        return this.client.put(url, RestEntity.create(MediaType.APPLICATION_JSON, body));
    }

    @Override
    public CompletionStage<RestResponse> xSiteStateTransferMode(String site) {
        return this.client.get(String.format("%s/x-site/backups/%s/state-transfer-mode", this.path, site));
    }

    @Override
    public CompletionStage<RestResponse> xSiteStateTransferMode(String site, XSiteStateTransferMode mode) {
        return this.client.post(String.format("%s/x-site/backups/%s/state-transfer-mode?action=set&mode=%s", this.path, site, mode.toString()));
    }

    private CompletionStage<RestResponse> executeXSiteOperation(String site, String action) {
        return this.client.post(String.format("%s/x-site/backups/%s?action=%s", this.path, site, action));
    }

    @Override
    public CompletionStage<RestResponse> reindex() {
        return this.executeIndexOperation("reindex", false);
    }

    @Override
    public CompletionStage<RestResponse> reindexLocal() {
        return this.executeIndexOperation("reindex", true);
    }

    @Override
    public CompletionStage<RestResponse> clearIndex() {
        return this.executeIndexOperation("clear", false);
    }

    @Override
    public CompletionStage<RestResponse> updateIndexSchema() {
        return this.executeIndexOperation("updateSchema", false);
    }

    @Override
    public CompletionStage<RestResponse> queryStats() {
        return this.executeSearchStatOperation("query", null);
    }

    @Override
    public CompletionStage<RestResponse> indexStats() {
        return this.executeSearchStatOperation("indexes", null);
    }

    @Override
    public CompletionStage<RestResponse> clearQueryStats() {
        return this.executeSearchStatOperation("query", "clear");
    }

    private CompletionStage<RestResponse> executeIndexOperation(String action, boolean local) {
        return this.client.post(String.format("%s/search/indexes?action=%s&local=%s", this.path, action, local));
    }

    private CompletionStage<RestResponse> executeSearchStatOperation(String type, String action) {
        Object url = String.format("%s/search/%s/stats", this.path, type);
        if (action != null) {
            url = (String)url + "?action=" + action;
            return this.client.post((String)url);
        }
        return this.client.get((String)url);
    }

    @Override
    public CompletionStage<RestResponse> details() {
        return this.client.get(this.path);
    }

    @Override
    public CompletionStage<RestResponse> indexMetamodel() {
        return this.client.get(this.path + "/search/indexes/metamodel");
    }

    @Override
    public CompletionStage<RestResponse> searchStats() {
        return this.client.get(this.path + "/search/stats");
    }

    @Override
    public CompletionStage<RestResponse> clearSearchStats() {
        return this.client.post(this.path + "/search/stats?action=clear");
    }

    @Override
    public CompletionStage<RestResponse> enableRebalancing() {
        return this.setRebalancing(true);
    }

    @Override
    public CompletionStage<RestResponse> disableRebalancing() {
        return this.setRebalancing(false);
    }

    private CompletionStage<RestResponse> setRebalancing(boolean enable) {
        String action = enable ? "enable-rebalancing" : "disable-rebalancing";
        return this.client.post(this.path + "?action=" + action);
    }

    @Override
    public CompletionStage<RestResponse> updateWithConfiguration(RestEntity configuration, CacheContainerAdmin.AdminFlag ... flags) {
        return this.client.put(this.path, this.enums("flags", (Enum<?>[])flags), configuration);
    }

    @Override
    public CompletionStage<RestResponse> updateConfigurationAttribute(String attribute, String ... value) {
        StringBuilder sb = new StringBuilder(this.path);
        sb.append("?action=set-mutable-attribute&attribute-name=");
        sb.append(Util.sanitize(attribute));
        for (String v : value) {
            sb.append("&attribute-value=");
            sb.append(Util.sanitize(v));
        }
        return this.client.post(sb.toString());
    }

    @Override
    public CompletionStage<RestResponse> configurationAttributes() {
        return this.configurationAttributes(false);
    }

    @Override
    public CompletionStage<RestResponse> configurationAttributes(boolean full) {
        return this.client.get(this.path + "?action=get-mutable-attributes" + (full ? "&full=true" : ""));
    }

    @Override
    public CompletionStage<RestResponse> assignAlias(String alias) {
        return this.client.post(this.path + "?action=assign-alias&alias=" + Util.sanitize(alias));
    }

    @Override
    public CompletionStage<RestResponse> getAvailability() {
        return this.client.get(this.path + "?action=get-availability");
    }

    @Override
    public CompletionStage<RestResponse> setAvailability(String availability) {
        return this.client.post(this.path + "?action=set-availability&availability=" + availability);
    }

    @Override
    public CompletionStage<RestResponse> markTopologyStable(boolean force) {
        return this.client.post(this.path + "?action=initialize&force=" + force);
    }

    private Map<String, String> enums(String name, Enum<?> ... values) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (values != null && values.length > 0) {
            StringJoiner joined = new StringJoiner(" ");
            for (Enum<?> value : values) {
                joined.add(value.name());
            }
            headers.put(name, joined.toString());
        }
        return headers;
    }

    private Map<String, String> expiration(long ttl, long maxIdle) {
        return this.expiration(new HashMap<String, String>(), ttl, maxIdle);
    }

    private Map<String, String> expiration(Map<String, String> headers, long ttl, long maxIdle) {
        if (ttl != 0L) {
            headers.put("timeToLiveSeconds", Long.toString(ttl));
        }
        if (maxIdle != 0L) {
            headers.put("maxIdleTimeSeconds", Long.toString(maxIdle));
        }
        return headers;
    }
}

