/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.infinispan.client.rest.MultiPartRestEntity;
import org.infinispan.client.rest.impl.jdk.form.MultiPartRestEntityJDK;
import org.infinispan.commons.dataconversion.MediaType;

public interface RestEntity {
    public static final RestEntity EMPTY = new RestEntity(){

        @Override
        public HttpRequest.BodyPublisher bodyPublisher() {
            return HttpRequest.BodyPublishers.noBody();
        }

        @Override
        public MediaType contentType() {
            return null;
        }
    };

    public HttpRequest.BodyPublisher bodyPublisher();

    public MediaType contentType();

    public static RestEntity empty() {
        return EMPTY;
    }

    public static RestEntity create(final MediaType contentType, final String body) {
        return new RestEntity(){

            @Override
            public HttpRequest.BodyPublisher bodyPublisher() {
                return HttpRequest.BodyPublishers.ofString(body);
            }

            @Override
            public MediaType contentType() {
                return contentType;
            }
        };
    }

    public static RestEntity create(final MediaType contentType, final byte[] body) {
        return new RestEntity(){

            @Override
            public HttpRequest.BodyPublisher bodyPublisher() {
                return HttpRequest.BodyPublishers.ofByteArray(body);
            }

            @Override
            public MediaType contentType() {
                return contentType;
            }
        };
    }

    public static RestEntity create(final MediaType contentType, final File file) {
        return new RestEntity(){

            @Override
            public HttpRequest.BodyPublisher bodyPublisher() {
                try {
                    return HttpRequest.BodyPublishers.ofFile(file.toPath());
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public MediaType contentType() {
                return contentType;
            }
        };
    }

    public static RestEntity create(final MediaType contentType, final InputStream inputStream) {
        return new RestEntity(){

            @Override
            public HttpRequest.BodyPublisher bodyPublisher() {
                return HttpRequest.BodyPublishers.ofInputStream(() -> inputStream);
            }

            @Override
            public MediaType contentType() {
                return contentType;
            }
        };
    }

    public static RestEntity form(Map<String, List<String>> formData) {
        StringBuilder fb = new StringBuilder();
        for (Map.Entry<String, List<String>> singleEntry : formData.entrySet()) {
            for (String v : singleEntry.getValue()) {
                if (!fb.isEmpty()) {
                    fb.append("&");
                }
                fb.append(URLEncoder.encode(singleEntry.getKey(), StandardCharsets.UTF_8));
                fb.append("=");
                fb.append(URLEncoder.encode(v, StandardCharsets.UTF_8));
            }
        }
        return RestEntity.create(MediaType.APPLICATION_WWW_FORM_URLENCODED, fb.toString());
    }

    public static MultiPartRestEntity multiPart() {
        return new MultiPartRestEntityJDK();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RestEntity create(File file) {
        if (file.getName().endsWith(".yaml")) return RestEntity.create(MediaType.APPLICATION_YAML, file);
        if (file.getName().endsWith(".yml")) {
            return RestEntity.create(MediaType.APPLICATION_YAML, file);
        }
        try (FileInputStream is = new FileInputStream(file);){
            int b;
            do {
                if ((b = ((InputStream)is).read()) <= -1) return RestEntity.create(MediaType.APPLICATION_OCTET_STREAM, file);
                if (b != 123) continue;
                RestEntity restEntity = RestEntity.create(MediaType.APPLICATION_JSON, file);
                return restEntity;
            } while (b != 60);
            RestEntity restEntity = RestEntity.create(MediaType.APPLICATION_XML, file);
            return restEntity;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static RestEntity create(String s) {
        return switch (s.trim().charAt(0)) {
            case '{' -> RestEntity.create(MediaType.APPLICATION_JSON, s);
            case '<' -> RestEntity.create(MediaType.APPLICATION_XML, s);
            default -> RestEntity.create(MediaType.TEXT_PLAIN, s);
        };
    }
}

