/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk;

import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import org.infinispan.client.rest.RestResponseInfo;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.dataconversion.MediaType;

public class RestResponseInfoJDK
implements RestResponseInfo {
    private final HttpResponse.ResponseInfo responseInfo;

    public RestResponseInfoJDK(HttpResponse.ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @Override
    public int status() {
        return this.responseInfo.statusCode();
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.responseInfo.headers().map();
    }

    @Override
    public String header(String header) {
        return this.responseInfo.headers().firstValue(header).orElse(null);
    }

    @Override
    public Protocol protocol() {
        switch (this.responseInfo.version()) {
            case HTTP_1_1: {
                return Protocol.HTTP_11;
            }
            case HTTP_2: {
                return Protocol.HTTP_20;
            }
        }
        throw new IllegalArgumentException(this.responseInfo.version().name());
    }

    @Override
    public MediaType contentType() {
        return this.responseInfo.headers().firstValue("Content-Type").map(MediaType::fromString).orElse(null);
    }
}

