/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp.auth;

import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.infinispan.client.rest.configuration.AuthenticationConfiguration;
import org.infinispan.client.rest.impl.okhttp.auth.AbstractAuthenticator;
import org.infinispan.client.rest.impl.okhttp.auth.CachingAuthenticator;

public class BearerAuthenticator
extends AbstractAuthenticator
implements CachingAuthenticator {
    private final AuthenticationConfiguration configuration;

    public BearerAuthenticator(AuthenticationConfiguration configuration) {
        this.configuration = configuration;
    }

    public Request authenticate(Route route, Response response) {
        Request request = response.request();
        return this.authenticateInternal(request);
    }

    @Override
    public Request authenticateWithState(Route route, Request request) {
        return this.authenticateInternal(request);
    }

    private Request authenticateInternal(Request request) {
        String authorization = request.header("Authorization");
        if (authorization != null && authorization.startsWith("Bearer")) {
            return null;
        }
        return request.newBuilder().header("Authorization", "Bearer " + this.configuration.username()).tag(Authenticator.class, (Object)this).build();
    }
}

