/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp.auth;

import java.io.IOException;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.infinispan.client.rest.impl.okhttp.auth.CachingAuthenticator;

public class CachingAuthenticatorWrapper
implements Authenticator {
    private final Authenticator innerAuthenticator;
    private final Map<String, CachingAuthenticator> authCache;

    public CachingAuthenticatorWrapper(Authenticator innerAuthenticator, Map<String, CachingAuthenticator> authCache) {
        this.innerAuthenticator = innerAuthenticator;
        this.authCache = authCache;
    }

    public Request authenticate(Route route, Response response) throws IOException {
        String authorizationValue;
        Request authenticated = this.innerAuthenticator.authenticate(route, response);
        if (authenticated != null && (authorizationValue = authenticated.header("Authorization")) != null && this.innerAuthenticator instanceof CachingAuthenticator) {
            String key = CachingAuthenticator.getCachingKey(authenticated);
            this.authCache.put(key, (CachingAuthenticator)authenticated.tag(Authenticator.class));
        }
        return authenticated;
    }
}

