/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import okhttp3.Request;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestTaskClient;
import org.infinispan.client.rest.impl.okhttp.RestClientOkHttp;
import org.infinispan.client.rest.impl.okhttp.RestEntityAdaptorOkHttp;

public class RestTaskClientOkHttp
implements RestTaskClient {
    private final RestClientOkHttp client;
    private final String baseURL;

    RestTaskClientOkHttp(RestClientOkHttp client) {
        this.client = client;
        this.baseURL = String.format("%s%s/v2/tasks", client.getBaseURL(), client.getConfiguration().contextPath()).replaceAll("//", "/");
    }

    @Override
    public CompletionStage<RestResponse> list(RestTaskClient.ResultType resultType) {
        return this.client.execute(this.baseURL + "?type=" + resultType.toString(), new String[0]);
    }

    @Override
    public CompletionStage<RestResponse> exec(String taskName, Map<String, ?> parameters) {
        Objects.requireNonNull(taskName);
        Objects.requireNonNull(parameters);
        Request.Builder builder = new Request.Builder();
        StringBuilder sb = new StringBuilder(this.baseURL).append('/').append(taskName);
        sb.append("?action=exec");
        for (Map.Entry<String, ?> parameter : parameters.entrySet()) {
            sb.append("&param.");
            sb.append(parameter.getKey());
            sb.append('=');
            sb.append(RestClientOkHttp.sanitize(parameter.getValue().toString()));
        }
        builder.url(sb.toString());
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> uploadScript(String taskName, RestEntity script) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.baseURL + "/" + RestClientOkHttp.sanitize(taskName)).post(((RestEntityAdaptorOkHttp)((Object)script)).toRequestBody());
        return this.client.execute(builder);
    }
}

