/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.util.concurrent.CompletionStage;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestQueryMode;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.impl.okhttp.RestClientOkHttp;
import org.infinispan.client.rest.impl.okhttp.RestEntityAdaptorOkHttp;
import org.infinispan.commons.api.CacheContainerAdmin;

public class RestCacheClientOkHttp
implements RestCacheClient {
    private final RestClientOkHttp client;
    private final String name;
    private final String cacheUrl;

    RestCacheClientOkHttp(RestClientOkHttp restClient, String name) {
        this.client = restClient;
        this.name = name;
        this.cacheUrl = String.format("%s%s/v2/caches/%s", restClient.getBaseURL(), restClient.getConfiguration().contextPath(), RestClientOkHttp.sanitize(name));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public CompletionStage<RestResponse> clear() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=clear").get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> exists() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl).head();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> synchronizeData() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=sync-data").get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> disconnectSource() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=disconnect-source").get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> size() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=size").get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> post(String key, String value) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).post(RequestBody.create((MediaType)RestClientOkHttp.TEXT_PLAIN, (String)value));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> post(String key, RestEntity value) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).post(((RestEntityAdaptorOkHttp)((Object)value)).toRequestBody());
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> post(String key, String value, long ttl, long maxIdle) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).post(RequestBody.create((MediaType)RestClientOkHttp.TEXT_PLAIN, (String)value));
        this.addExpirationHeaders(builder, ttl, maxIdle);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> post(String key, RestEntity value, long ttl, long maxIdle) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).post(((RestEntityAdaptorOkHttp)((Object)value)).toRequestBody());
        this.addExpirationHeaders(builder, ttl, maxIdle);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, String value) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).put(RequestBody.create((MediaType)RestClientOkHttp.TEXT_PLAIN, (String)value));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, RestEntity value) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).put(((RestEntityAdaptorOkHttp)((Object)value)).toRequestBody());
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, String value, long ttl, long maxIdle) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).put(RequestBody.create((MediaType)RestClientOkHttp.TEXT_PLAIN, (String)value));
        this.addExpirationHeaders(builder, ttl, maxIdle);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, RestEntity value, long ttl, long maxIdle) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).put(((RestEntityAdaptorOkHttp)((Object)value)).toRequestBody());
        this.addExpirationHeaders(builder, ttl, maxIdle);
        return this.client.execute(builder);
    }

    private void addExpirationHeaders(Request.Builder builder, long ttl, long maxIdle) {
        if (ttl != 0L) {
            builder.addHeader("timeToLiveSeconds", Long.toString(ttl));
        }
        if (maxIdle != 0L) {
            builder.addHeader("maxIdleTimeSeconds", Long.toString(maxIdle));
        }
    }

    @Override
    public CompletionStage<RestResponse> get(String key) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> head(String key) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key) + "?extended").head();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> remove(String key) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).delete();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> createWithTemplate(String template, CacheContainerAdmin.AdminFlag ... flags) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?template=" + template).post(RestClientOkHttp.EMPTY_BODY);
        RestClientOkHttp.addEnumHeader("flags", builder, (Enum[])flags);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> createWithConfiguration(RestEntity configuration, CacheContainerAdmin.AdminFlag ... flags) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl).post(((RestEntityAdaptorOkHttp)((Object)configuration)).toRequestBody());
        RestClientOkHttp.addEnumHeader("flags", builder, (Enum[])flags);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> delete() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl).delete();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> keys() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=keys").get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> configuration() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=config");
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> stats() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=stats").get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> query(String query) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=search&query=" + RestClientOkHttp.sanitize(query)).get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> query(String query, int maxResults, int offset, RestQueryMode queryMode) {
        Request.Builder builder = new Request.Builder();
        builder.url(String.format("%s?action=search&query=%s&max_results=%d&offset=%d&query_mode=%s", this.cacheUrl, RestClientOkHttp.sanitize(query), maxResults, offset, queryMode.name())).get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> xsiteBackups() {
        Request.Builder builder = new Request.Builder();
        builder.url(String.format("%s/x-site/backups/", this.cacheUrl));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> backupStatus(String site) {
        Request.Builder builder = new Request.Builder();
        builder.url(String.format("%s/x-site/backups/%s", this.cacheUrl, site));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> takeSiteOffline(String site) {
        return this.executeXSiteOperation(site, "take-offline");
    }

    @Override
    public CompletionStage<RestResponse> bringSiteOnline(String site) {
        return this.executeXSiteOperation(site, "bring-online");
    }

    @Override
    public CompletionStage<RestResponse> pushSiteState(String site) {
        return this.executeXSiteOperation(site, "start-push-state");
    }

    @Override
    public CompletionStage<RestResponse> cancelPushState(String site) {
        return this.executeXSiteOperation(site, "cancel-push-state");
    }

    @Override
    public CompletionStage<RestResponse> cancelReceiveState(String site) {
        Request.Builder builder = new Request.Builder();
        builder.url(String.format("%s/x-site/backups/%s?action=%s", this.cacheUrl, site, "cancel-receive-state"));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> pushStateStatus() {
        Request.Builder builder = new Request.Builder();
        builder.url(String.format("%s/x-site/backups?action=push-state-status", this.cacheUrl));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> clearPushStateStatus() {
        Request.Builder builder = new Request.Builder();
        builder.url(String.format("%s/x-site/local?action=clear-push-state-status", this.cacheUrl));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> getXSiteTakeOfflineConfig(String site) {
        Request.Builder builder = new Request.Builder();
        builder.url(String.format("%s/x-site/backups/%s/take-offline-config", this.cacheUrl, site));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> updateXSiteTakeOfflineConfig(String site, int afterFailures, long minTimeToWait) {
        Request.Builder builder = new Request.Builder();
        String url = String.format("%s/x-site/backups/%s/take-offline-config", this.cacheUrl, site);
        String body = String.format("{\"after_failures\":%d,\"min_wait\":%d}", afterFailures, minTimeToWait);
        builder.url(url);
        builder.method("PUT", RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body));
        return this.client.execute(builder);
    }

    private CompletionStage<RestResponse> executeXSiteOperation(String site, String action) {
        Request.Builder builder = new Request.Builder();
        builder.url(String.format("%s/x-site/backups/%s?action=%s", this.cacheUrl, site, action));
        return this.client.execute(builder);
    }
}

