/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.Callable;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.command.shell.Shell;
import org.aesh.io.Resource;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.completers.OnErrorCompleter;
import org.infinispan.cli.converters.OnErrorConverter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.ExitCodeResultHandler;
import org.infinispan.cli.logging.Messages;
import org.infinispan.commons.util.StringPropertyReplacer;

@CommandDefinition(name="run", description="Reads and executes commands from one or more files", resultHandler=ExitCodeResultHandler.class)
public class Run
extends CliCommand {
    @Arguments(required=true, completer=FileOptionCompleter.class)
    List<Resource> arguments;
    @Option(name="on-error", description="Action to take when a command fails", completer=OnErrorCompleter.class, defaultValue={"FAIL_FAST"}, converter=OnErrorConverter.class)
    OnErrorCompleter.OnError onError;
    @Option(description="Whether to echo commands to the output", hasValue=false)
    boolean echo;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
        boolean failed = false;
        if (this.arguments != null && !this.arguments.isEmpty()) {
            for (Resource resource : this.arguments) {
                CommandResult result;
                boolean stdin = "-".equals(resource.getName());
                if (stdin) {
                    Shell shell = invocation.getShell();
                    result = this.processInput("<STDIN>", () -> ((Shell)shell).readLine(), invocation);
                } else {
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(resource.read()));){
                        result = this.processInput(resource.getAbsolutePath(), br::readLine, invocation);
                    }
                    catch (IOException e) {
                        invocation.errorln(Messages.MSG.batchError(resource.getAbsolutePath(), 0, "", e));
                        result = CommandResult.FAILURE;
                    }
                }
                if (result != CommandResult.FAILURE) continue;
                switch (this.onError) {
                    case FAIL_FAST: {
                        return CommandResult.FAILURE;
                    }
                    case FAIL_AT_END: {
                        failed = true;
                    }
                }
            }
        }
        return failed ? CommandResult.FAILURE : CommandResult.SUCCESS;
    }

    private CommandResult processInput(String source, Callable<String> lineSupplier, ContextAwareCommandInvocation invocation) {
        int lineCount = 0;
        String line = "";
        boolean failed = false;
        try {
            line = lineSupplier.call();
            while (line != null) {
                ++lineCount;
                if (!line.startsWith("#")) {
                    if (this.echo) {
                        invocation.println(line);
                    }
                    try {
                        invocation.executeCommand("batch " + StringPropertyReplacer.replaceProperties((String)line));
                    }
                    catch (Exception e) {
                        invocation.errorln(Messages.MSG.batchError(source, lineCount, line, e));
                        failed = true;
                    }
                    if (ExitCodeResultHandler.exitCode() > 0) {
                        invocation.errorln(Messages.MSG.batchError(source, lineCount, line));
                        switch (this.onError) {
                            case FAIL_FAST: {
                                return CommandResult.FAILURE;
                            }
                            case FAIL_AT_END: {
                                failed = true;
                            }
                            case IGNORE: {
                                ExitCodeResultHandler.reset();
                            }
                        }
                    }
                }
                line = lineSupplier.call();
            }
        }
        catch (Exception e) {
            invocation.errorln(Messages.MSG.batchError(source, lineCount, line, e));
            failed = true;
        }
        return failed ? CommandResult.FAILURE : CommandResult.SUCCESS;
    }
}

