/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.patching;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;

public class PatchOperation
implements JsonSerialization {
    public static final String ACTION = "action";
    public static final String PATH = "path";
    public static final String DIGEST = "digest";
    public static final String PERMISSIONS = "permissions";
    public static final String NEW_PATH = "new-path";
    public static final String NEW_DIGEST = "new-digest";
    public static final String NEW_PERMISSIONS = "new-permissions";
    private final Action action;
    private final Path path;
    private final String digest;
    private final String permissions;
    private final Path newPath;
    private final String newDigest;
    private final String newPermissions;

    public static PatchOperation add(Path path, String digest, String permissions) {
        return new PatchOperation(Action.ADD, null, null, null, path, digest, permissions);
    }

    public static PatchOperation remove(Path path, String digest, String permissions) {
        return new PatchOperation(Action.REMOVE, path, digest, permissions, null, null, null);
    }

    public static PatchOperation upgrade(Path path, String digest, String permissions, Path newPath, String newDigest, String newPermissions) {
        return new PatchOperation(Action.UPGRADE, path, digest, permissions, newPath, newDigest, newPermissions);
    }

    public static PatchOperation replace(boolean soft, Path path, String digest, String permissions, String newDigest, String newPermissions) {
        return new PatchOperation(soft ? Action.SOFT_REPLACE : Action.HARD_REPLACE, path, digest, permissions, path, newDigest, newPermissions);
    }

    private PatchOperation(Action action, Path path, String digest, String permissions, Path newPath, String newDigest, String newPermissions) {
        this.action = action;
        this.path = path;
        this.digest = digest;
        this.permissions = permissions;
        this.newPath = newPath;
        this.newDigest = newDigest;
        this.newPermissions = newPermissions;
    }

    public Action getAction() {
        return this.action;
    }

    public Path getPath() {
        return this.path;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public Path getNewPath() {
        return this.newPath;
    }

    public String getNewDigest() {
        return this.newDigest;
    }

    public String getNewPermissions() {
        return this.newPermissions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.action.name());
        if (this.path != null) {
            sb.append(" ").append(this.path).append(" [").append(this.digest).append("] ").append(this.permissions);
        }
        if (this.newPath != null) {
            sb.append(" -> ").append(this.newPath).append(" [").append(this.newDigest).append("] ").append(this.newPermissions);
        }
        return sb.toString();
    }

    public static PatchOperation fromJson(Json json) {
        Action action = Action.valueOf(json.at(ACTION).asString());
        switch (action.ordinal()) {
            case 0: {
                return PatchOperation.add(Paths.get(json.at(NEW_PATH).asString(), new String[0]), json.at(NEW_DIGEST).asString(), json.at(NEW_PERMISSIONS).asString());
            }
            case 1: {
                return PatchOperation.remove(Paths.get(json.at(PATH).asString(), new String[0]), json.at(DIGEST).asString(), json.at(PERMISSIONS).asString());
            }
            case 3: {
                return PatchOperation.replace(false, Paths.get(json.at(PATH).asString(), new String[0]), json.at(DIGEST).asString(), json.at(PERMISSIONS).asString(), json.at(NEW_DIGEST).asString(), json.at(NEW_PERMISSIONS).asString());
            }
            case 4: {
                return PatchOperation.replace(true, Paths.get(json.at(PATH).asString(), new String[0]), json.at(DIGEST).asString(), json.at(PERMISSIONS).asString(), json.at(NEW_DIGEST).asString(), json.at(NEW_PERMISSIONS).asString());
            }
            case 2: {
                return PatchOperation.upgrade(Paths.get(json.at(PATH).asString(), new String[0]), json.at(DIGEST).asString(), json.at(PERMISSIONS).asString(), Paths.get(json.at(NEW_PATH).asString(), new String[0]), json.at(NEW_DIGEST).asString(), json.at(NEW_PERMISSIONS).asString());
            }
        }
        throw new IllegalArgumentException(action.name());
    }

    public Json toJson() {
        Json result = Json.object().set(ACTION, (Object)this.action.name());
        if (this.path != null) {
            result.set(PATH, (Object)this.path.toString());
            result.set(DIGEST, (Object)this.digest);
            result.set(PERMISSIONS, (Object)this.permissions);
        }
        if (this.newPath != null) {
            result.set(NEW_PATH, (Object)this.newPath.toString());
        }
        if (this.newDigest != null) {
            result.set(NEW_DIGEST, (Object)this.newDigest);
        }
        if (this.newPermissions != null) {
            result.set(NEW_PERMISSIONS, (Object)this.newPermissions);
        }
        return result;
    }

    static enum Action {
        ADD,
        REMOVE,
        UPGRADE,
        HARD_REPLACE,
        SOFT_REPLACE;

    }
}

