/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.completers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.infinispan.cli.Context;
import org.infinispan.cli.completers.ContextAwareCompleterInvocation;
import org.infinispan.cli.resources.Resource;
import org.infinispan.cli.resources.RootResource;

public class CdContextCompleter
implements OptionCompleter {
    public void complete(CompleterInvocation invocation) {
        Context context = ((ContextAwareCompleterInvocation)invocation).context;
        Resource resource = context.getConnection().getActiveResource();
        String v = invocation.getGivenCompleteValue();
        if (v == null || v.length() == 0) {
            invocation.addAllCompleterValues(this.getChildrenNames(resource));
            invocation.setAppendSpace(resource.isLeaf());
        } else {
            String[] parts = v.split("/");
            if (parts.length == 0) {
                resource = resource.findAncestor(RootResource.class);
                invocation.addAllCompleterValues(this.getChildrenNames(resource));
                invocation.setAppendSpace(resource.isLeaf());
            } else {
                String prefix;
                String last;
                int offset;
                if (v.endsWith("/")) {
                    offset = 0;
                    last = "";
                    prefix = v;
                } else {
                    offset = 1;
                    last = parts[parts.length - 1];
                    int lastSlash = v.lastIndexOf(47);
                    prefix = lastSlash < 0 ? "" : v.substring(0, lastSlash + 1);
                }
                for (int i = 0; i < parts.length - offset; ++i) {
                    if (parts[i].isEmpty()) {
                        resource = resource.findAncestor(RootResource.class);
                        continue;
                    }
                    try {
                        resource = resource.getChild(parts[i]);
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Collection<String> all = this.getChildrenNames(resource);
                for (String item : all) {
                    if (!item.startsWith(last)) continue;
                    invocation.addCompleterValue(prefix + item);
                }
                invocation.setAppendSpace(resource.isLeaf());
            }
        }
    }

    private Collection<String> getChildrenNames(Resource resource) {
        try {
            ArrayList<String> children = new ArrayList<String>();
            resource.getChildrenNames().forEach(c -> children.add((String)c));
            return children;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }
}

