/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.completers.CounterCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.resources.Resource;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;

@GroupCommandDefinition(name="drop", description="Drops a cache or a counter", activator=ConnectionActivator.class, groupCommands={Cache.class, Counter.class})
public class Drop
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="counter", description="Drop a counter", activator=ConnectionActivator.class)
    public static class Counter
    extends RestCliCommand {
        @Argument(required=true, completer=CounterCompleter.class, description="The counter name")
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.counter(this.name).delete();
        }
    }

    @CommandDefinition(name="cache", description="Drop a cache", activator=ConnectionActivator.class)
    public static class Cache
    extends RestCliCommand {
        @Argument(required=true, completer=CacheCompleter.class, description="The cache name")
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.name).delete();
        }
    }
}

