/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.completers;

import java.io.IOException;
import java.util.Collection;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.infinispan.cli.Context;
import org.infinispan.cli.completers.ContextAwareCompleterInvocation;

public abstract class ListCompleter
implements OptionCompleter<ContextAwareCompleterInvocation> {
    abstract Collection<String> getAvailableItems(Context var1) throws IOException;

    protected Collection<String> getAvailableItems(ContextAwareCompleterInvocation invocation) throws IOException {
        return this.getAvailableItems(invocation.context);
    }

    public void complete(ContextAwareCompleterInvocation invocation) {
        try {
            Collection<String> all = this.getAvailableItems(invocation);
            this.completeFromList(invocation, all);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void completeFromList(CompleterInvocation invocation, Collection<String> all) {
        String v = invocation.getGivenCompleteValue();
        if (v == null || v.length() == 0) {
            invocation.addAllCompleterValues(all);
        } else {
            for (String item : all) {
                if (!item.startsWith(v)) continue;
                invocation.addCompleterValue(item);
            }
        }
    }
}

