/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.remote;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.Producer;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.cdi.common.util.AnyLiteral;
import org.infinispan.cdi.common.util.BeanBuilder;
import org.infinispan.cdi.common.util.ContextualLifecycle;
import org.infinispan.cdi.common.util.DefaultLiteral;
import org.infinispan.cdi.common.util.Reflections;
import org.infinispan.cdi.remote.Remote;
import org.infinispan.cdi.remote.RemoteCacheProducer;
import org.infinispan.cdi.remote.logging.RemoteLog;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;

public class InfinispanExtensionRemote
implements Extension {
    private static final RemoteLog LOGGER = RemoteLog.getLog(InfinispanExtensionRemote.class);
    private final Map<Type, Set<Annotation>> remoteCacheInjectionPoints;
    private Producer<RemoteCache<?, ?>> remoteCacheProducer;

    public InfinispanExtensionRemote() {
        new ConfigurationBuilder();
        this.remoteCacheInjectionPoints = new HashMap<Type, Set<Annotation>>();
    }

    void processProducers(@Observes ProcessProducer<?, ?> event) {
        AnnotatedMember member = event.getAnnotatedMember();
        if (RemoteCacheProducer.class == member.getDeclaringType().getBaseType()) {
            this.remoteCacheProducer = event.getProducer();
        }
    }

    <T> void saveRemoteInjectionPoints(@Observes ProcessInjectionTarget<T> event, BeanManager beanManager) {
        InjectionTarget injectionTarget = event.getInjectionTarget();
        for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
            Annotated annotated = injectionPoint.getAnnotated();
            Type type = annotated.getBaseType();
            Class rawType = Reflections.getRawType((Type)annotated.getBaseType());
            Set qualifiers = Reflections.getQualifiers((BeanManager)beanManager, (Iterable)annotated.getAnnotations());
            if (rawType == RemoteCache.class && qualifiers.isEmpty()) {
                qualifiers.add(new AnnotationLiteral<Default>(){});
                this.addRemoteCacheInjectionPoint(type, qualifiers);
                continue;
            }
            if (annotated.isAnnotationPresent(Remote.class) || Reflections.getMetaAnnotation((Annotated)annotated, Remote.class) == null || !rawType.isAssignableFrom(RemoteCache.class)) continue;
            this.addRemoteCacheInjectionPoint(type, qualifiers);
        }
    }

    private void addRemoteCacheInjectionPoint(Type type, Set<Annotation> qualifiers) {
        Set<Annotation> currentQualifiers = this.remoteCacheInjectionPoints.get(type);
        if (currentQualifiers == null) {
            this.remoteCacheInjectionPoints.put(type, qualifiers);
        } else {
            currentQualifiers.addAll(qualifiers);
        }
    }

    <T, X> void registerBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        if (beanManager.getBeans(RemoteCacheManager.class, new Annotation[0]).isEmpty()) {
            LOGGER.addDefaultRemoteCacheManager();
            event.addBean(this.createDefaultRemoteCacheManagerBean(beanManager));
        }
        for (Map.Entry<Type, Set<Annotation>> entry : this.remoteCacheInjectionPoints.entrySet()) {
            event.addBean(new BeanBuilder(beanManager).readFromType(beanManager.createAnnotatedType(Reflections.getRawType((Type)entry.getKey()))).addType(entry.getKey()).addQualifiers((Collection)entry.getValue()).passivationCapable(true).id(InfinispanExtensionRemote.class.getSimpleName() + "#" + RemoteCache.class.getSimpleName()).beanLifecycle(new ContextualLifecycle<RemoteCache<?, ?>>(){

                public RemoteCache<?, ?> create(Bean<RemoteCache<?, ?>> bean, CreationalContext<RemoteCache<?, ?>> ctx) {
                    return (RemoteCache)InfinispanExtensionRemote.this.remoteCacheProducer.produce(ctx);
                }

                public void destroy(Bean<RemoteCache<?, ?>> bean, RemoteCache<?, ?> instance, CreationalContext<RemoteCache<?, ?>> ctx) {
                    InfinispanExtensionRemote.this.remoteCacheProducer.dispose(instance);
                }
            }).create());
        }
    }

    private Bean<RemoteCacheManager> createDefaultRemoteCacheManagerBean(BeanManager beanManager) {
        return new BeanBuilder(beanManager).beanClass(InfinispanExtensionRemote.class).addTypes(new Type[]{Object.class, RemoteCacheManager.class}).scope(ApplicationScoped.class).qualifiers(new Annotation[]{DefaultLiteral.INSTANCE, AnyLiteral.INSTANCE}).passivationCapable(true).id(InfinispanExtensionRemote.class.getSimpleName() + "#" + RemoteCacheManager.class.getSimpleName()).beanLifecycle((ContextualLifecycle)new ContextualLifecycle<RemoteCacheManager>(){

            public RemoteCacheManager create(Bean<RemoteCacheManager> bean, CreationalContext<RemoteCacheManager> creationalContext) {
                return new RemoteCacheManager();
            }

            public void destroy(Bean<RemoteCacheManager> bean, RemoteCacheManager instance, CreationalContext<RemoteCacheManager> creationalContext) {
                instance.stop();
            }
        }).create();
    }
}

