/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.common.util.annotatedtypebuilder;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.cdi.common.util.Reflections;
import org.infinispan.cdi.common.util.annotatedtypebuilder.AnnotationStore;
import org.infinispan.cdi.common.util.logging.Log;

public class AnnotationBuilder {
    private static final Log log = Log.getLog(AnnotationBuilder.class);
    private final Map<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
    private final Set<Annotation> annotationSet = new HashSet<Annotation>();

    AnnotationBuilder() {
    }

    public AnnotationBuilder add(Annotation annotation) {
        if (annotation == null) {
            throw log.parameterMustNotBeNull("annotation");
        }
        this.annotationSet.add(annotation);
        this.annotationMap.put(annotation.annotationType(), annotation);
        return this;
    }

    public AnnotationBuilder remove(Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw log.parameterMustNotBeNull("annotationType");
        }
        Iterator<Annotation> it = this.annotationSet.iterator();
        while (it.hasNext()) {
            Annotation an = it.next();
            if (!annotationType.isAssignableFrom(an.annotationType())) continue;
            it.remove();
        }
        this.annotationMap.remove(annotationType);
        return this;
    }

    AnnotationStore create() {
        return new AnnotationStore(this.annotationMap, this.annotationSet);
    }

    public AnnotationBuilder addAll(AnnotationStore annotations) {
        for (Annotation annotation : annotations.getAnnotations()) {
            this.add(annotation);
        }
        return this;
    }

    public <T extends Annotation> T getAnnotation(Class<T> anType) {
        return (T)((Annotation)Reflections.cast(this.annotationMap.get(anType)));
    }

    public boolean isAnnotationPresent(Class<?> annotationType) {
        return this.annotationMap.containsKey(annotationType);
    }

    public String toString() {
        return this.annotationSet.toString();
    }
}

