/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.persistence.jdbc.common.TableOperations;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.impl.BaseJdbcStore;
import org.infinispan.persistence.jdbc.common.sql.BaseTableOperations;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.sql.configuration.AbstractSchemaJdbcConfiguration;
import org.infinispan.persistence.sql.configuration.SchemaJdbcConfiguration;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.Type;

public abstract class AbstractSchemaJdbcStore<K, V, C extends AbstractSchemaJdbcConfiguration>
extends BaseJdbcStore<K, V, C> {
    protected TableOperations<K, V> createTableOperations(InitializationContext ctx, C config) throws SQLException {
        AdvancedCache advancedCache = ctx.getCache().getAdvancedCache();
        MediaType jsonStringType = MediaType.fromString((String)"application/json;type=String");
        DataConversion keyDataConversion = advancedCache.getKeyDataConversion().withRequestMediaType(jsonStringType);
        DataConversion valueDataConversion = advancedCache.getValueDataConversion().withRequestMediaType(jsonStringType);
        ComponentRegistry componentRegistry = advancedCache.getComponentRegistry();
        componentRegistry.wireDependencies((Object)keyDataConversion, true);
        componentRegistry.wireDependencies((Object)valueDataConversion, true);
        Parameter[] parameters = this.generateParameterInformation(config, this.connectionFactory);
        assert (parameters.length != 0);
        Parameter[] primaryParameters = this.determinePrimaryParameters(config, parameters);
        assert (primaryParameters.length != 0);
        assert (Arrays.stream(primaryParameters).allMatch(Parameter::isPrimaryIdentifier));
        ImmutableSerializationContext serializationContext = ((SerializationContextRegistry)componentRegistry.getComponent(SerializationContextRegistry.class)).getUserCtx();
        ProtoSchemaOptions<K, V, C> options = this.verifySchemaAndCreateOptions(serializationContext, ((AbstractSchemaJdbcConfiguration)((Object)config)).getSchemaJdbcConfiguration(), parameters, primaryParameters, keyDataConversion, valueDataConversion, ctx.getMarshallableEntryFactory());
        return this.actualCreateTableOperations(options);
    }

    protected Parameter[] determinePrimaryParameters(C config, Parameter[] allParameters) {
        return (Parameter[])Arrays.stream(allParameters).filter(Parameter::isPrimaryIdentifier).toArray(Parameter[]::new);
    }

    protected abstract TableOperations<K, V> actualCreateTableOperations(ProtoSchemaOptions<K, V, C> var1);

    abstract Parameter[] generateParameterInformation(C var1, ConnectionFactory var2) throws SQLException;

    int typeWeUse(int sqlType, String typeName) {
        if (sqlType == 12) {
            if (typeName.contains("BIT") || typeName.contains("BINARY")) {
                return -3;
            }
        } else if (typeName.toUpperCase().startsWith("BOOL")) {
            return 16;
        }
        return sqlType;
    }

    ProtoSchemaOptions<K, V, C> verifySchemaAndCreateOptions(ImmutableSerializationContext ctx, SchemaJdbcConfiguration schemaJdbcConfiguration, Parameter[] parameters, Parameter[] primaryParameters, DataConversion keyConversion, DataConversion valueConversion, MarshallableEntryFactory<K, V> marshallableEntryFactory) {
        HashMap<String, Parameter> parameterMap = new HashMap<String, Parameter>();
        int uniquePrimaryParameters = 0;
        for (Parameter parameter2 : parameters) {
            if (parameterMap.put(parameter2.name.toUpperCase(), parameter2) != null || !parameter2.primaryIdentifier) continue;
            ++uniquePrimaryParameters;
        }
        String packageName = schemaJdbcConfiguration.packageName();
        String keyMessageName = schemaJdbcConfiguration.keyMessageName();
        String fullKeyMessageName = null;
        if (uniquePrimaryParameters != 1 || keyMessageName != null) {
            if (keyMessageName == null || packageName == null) {
                throw log.primaryKeyMultipleColumnWithoutSchema();
            }
            String fullMessageName = packageName + "." + keyMessageName;
            this.verifyParametersPresentForMessage(ctx, fullMessageName, parameterMap, true);
            fullKeyMessageName = fullMessageName;
        } else {
            this.updatePrimitiveJsonConsumer(primaryParameters[0], true);
        }
        String valueMessageName = schemaJdbcConfiguration.messageName();
        String fullValueMessageName = null;
        boolean hasEmbeddedKey = ((AbstractSchemaJdbcConfiguration)this.config).getSchemaJdbcConfiguration().embeddedKey();
        if (parameterMap.size() - (hasEmbeddedKey ? 0 : uniquePrimaryParameters) > 1 || valueMessageName != null) {
            if (valueMessageName == null || packageName == null) {
                throw log.valueMultipleColumnWithoutSchema();
            }
            String fullMessageName = packageName + "." + valueMessageName;
            this.verifyParametersPresentForMessage(ctx, fullMessageName, parameterMap, false);
            fullValueMessageName = fullMessageName;
        } else {
            boolean updatedPrimitive = false;
            for (Parameter parameter3 : parameters) {
                if (parameter3.primaryIdentifier) continue;
                assert (!updatedPrimitive);
                this.updatePrimitiveJsonConsumer(parameter3, false);
                updatedPrimitive = true;
            }
        }
        ArrayList<Parameter> unusedValueParams = null;
        for (Parameter parameter3 : parameters) {
            if (parameter3.jsonConsumerValue != null || parameter3.jsonConsumerKey != null) continue;
            if (parameter3.primaryIdentifier) {
                throw log.keyNotInSchema(parameter3.name, fullKeyMessageName);
            }
            if (unusedValueParams == null) {
                unusedValueParams = new ArrayList<Parameter>();
            }
            unusedValueParams.add(parameter3);
        }
        if (unusedValueParams != null) {
            parameters = this.handleUnusedValueParams(parameters, unusedValueParams);
        }
        if (hasEmbeddedKey) {
            assert (Arrays.stream(parameters).noneMatch(parameter -> ((Parameter)parameter).unwrapJsonValue == null));
        } else {
            assert (Arrays.stream(parameters).noneMatch(parameter -> ((Parameter)parameter).primaryIdentifier && ((Parameter)parameter).unwrapJsonValue != null));
            assert (Arrays.stream(parameters).noneMatch(parameter -> !((Parameter)parameter).primaryIdentifier && ((Parameter)parameter).unwrapJsonValue == null));
        }
        assert (Arrays.stream(parameters).filter(Parameter::isPrimaryIdentifier).noneMatch(parameter -> ((Parameter)parameter).unwrapJsonKey == null));
        return new ProtoSchemaOptions<K, V, AbstractSchemaJdbcConfiguration>((AbstractSchemaJdbcConfiguration)this.config, primaryParameters, fullKeyMessageName, parameters, fullValueMessageName, keyConversion, valueConversion, marshallableEntryFactory);
    }

    Parameter[] handleUnusedValueParams(Parameter[] parameters, List<Parameter> unusedValueParams) {
        throw this.unusedValueParamsException(unusedValueParams);
    }

    CacheConfigurationException unusedValueParamsException(List<Parameter> unusedParamNames) {
        return log.valueNotInSchema(unusedParamNames.stream().map(Parameter::getName).collect(Collectors.toList()), ((AbstractSchemaJdbcConfiguration)this.config).getSchemaJdbcConfiguration().messageName());
    }

    private void updatePrimitiveJsonConsumer(Parameter parameter, boolean key) {
        this.updateUnwrap(parameter, key, json -> json.at("_value"));
        this.updateJsonConsumer(parameter, key, (json, value) -> {
            json.set("_type", (Object)parameter.getType().protostreamType);
            json.set("_value", value);
        });
    }

    void verifyParametersPresentForMessage(ImmutableSerializationContext ctx, String fullTypeName, Map<String, Parameter> parameterMap, boolean key) {
        GenericDescriptor genericDescriptor;
        try {
            genericDescriptor = ctx.getDescriptorByName(fullTypeName);
        }
        catch (IllegalArgumentException t) {
            throw log.schemaNotFound(fullTypeName);
        }
        HashSet<String> seenNames = new HashSet<String>();
        if (genericDescriptor instanceof Descriptor) {
            this.recursiveUpdateParameters((Descriptor)genericDescriptor, parameterMap, null, seenNames, key);
        } else if (genericDescriptor instanceof EnumDescriptor) {
            if (!key && ((AbstractSchemaJdbcConfiguration)this.config).getSchemaJdbcConfiguration().embeddedKey()) {
                throw log.keyCannotEmbedWithEnum(fullTypeName);
            }
            String name = genericDescriptor.getName();
            Parameter enumParam = parameterMap.get(name.toUpperCase());
            if (enumParam != null) {
                assert (enumParam.getType() == ProtostreamFieldType.STRING);
                this.updateUnwrap(enumParam, key, json -> json.at("_value"));
                this.updateJsonConsumer(enumParam, key, (json, o) -> {
                    json.set("_type", (Object)fullTypeName);
                    json.set("_value", o);
                });
            }
        } else {
            throw new UnsupportedOperationException("Unsupported descriptor found " + genericDescriptor);
        }
    }

    void recursiveUpdateParameters(Descriptor descriptor, Map<String, Parameter> parameterMap, String[] nestedMessageNames, Set<String> seenNames, boolean key) {
        for (FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            BiConsumer<Json, Object> valueConsumer;
            Function<Json, Json> retrievalFunction;
            String name = fieldDescriptor.getName();
            if (fieldDescriptor.isRepeated()) {
                throw log.repeatedFieldsNotSupported(name, fieldDescriptor.getTypeName());
            }
            Descriptor fieldMessageDescriptor = fieldDescriptor.getMessageType();
            if (fieldMessageDescriptor != null) {
                String[] newNestedMessageNames;
                if (nestedMessageNames == null) {
                    newNestedMessageNames = new String[]{name};
                } else {
                    newNestedMessageNames = Arrays.copyOf(nestedMessageNames, nestedMessageNames.length + 1);
                    newNestedMessageNames[nestedMessageNames.length] = name;
                }
                this.recursiveUpdateParameters(fieldMessageDescriptor, parameterMap, newNestedMessageNames, seenNames, key);
                continue;
            }
            if (!seenNames.add(name)) {
                throw log.duplicateFieldInSchema(name, fieldDescriptor.getTypeName());
            }
            Parameter parameter = parameterMap.get(name.toUpperCase());
            if (parameter == null) {
                if (!fieldDescriptor.isRequired()) continue;
                throw log.requiredSchemaFieldNotPresent(name, fieldDescriptor.getTypeName());
            }
            if (parameter.primaryIdentifier && !key && !((AbstractSchemaJdbcConfiguration)this.config).getSchemaJdbcConfiguration().embeddedKey()) {
                throw log.primaryKeyPresentButNotEmbedded(parameter.name, fieldDescriptor.getTypeName());
            }
            if (parameter.type == ProtostreamFieldType.INT_32 && fieldDescriptor.getType() == Type.BOOL) {
                retrievalFunction = json -> Json.factory().number((Number)(json.at(name).asBoolean() ? 1 : 0));
                valueConsumer = (json, o) -> json.set(name, (Object)((Integer)o == 1 ? 1 : 0));
            } else {
                retrievalFunction = json -> json.at(name);
                valueConsumer = (json, o) -> json.set(name, o);
            }
            if (nestedMessageNames == null) {
                this.updateUnwrap(parameter, key, retrievalFunction);
                this.updateJsonConsumer(parameter, key, valueConsumer);
                continue;
            }
            this.updateUnwrap(parameter, key, json -> {
                for (String nestedName : nestedMessageNames) {
                    if ((json = json.at(nestedName)) != null) continue;
                    return null;
                }
                return (Json)retrievalFunction.apply((Json)json);
            });
            this.updateJsonConsumer(parameter, key, (json, o) -> {
                Json nestedJSon = json;
                for (String nestedName : nestedMessageNames) {
                    nestedJSon = json.at(nestedName);
                    if (nestedJSon == null) {
                        nestedJSon = Json.object();
                        json.set(nestedName, nestedJSon);
                    }
                    json = nestedJSon;
                }
                valueConsumer.accept(nestedJSon, o);
            });
        }
    }

    private void updateUnwrap(Parameter parameter, boolean key, Function<Json, Json> function) {
        if (key) {
            parameter.unwrapJsonKey = function;
        } else {
            parameter.unwrapJsonValue = function;
        }
    }

    private void updateJsonConsumer(Parameter parameter, boolean key, BiConsumer<Json, Object> jsonBiConsumer) {
        if (key) {
            parameter.jsonConsumerKey = jsonBiConsumer;
        } else {
            parameter.jsonConsumerValue = jsonBiConsumer;
        }
    }

    protected static abstract class SchemaTableOperations<K, V, C extends AbstractSchemaJdbcConfiguration>
    extends BaseTableOperations<K, V> {
        private final ProtoSchemaOptions<K, V, C> schemaOptions;
        private final Parameter[] upsertParameters;

        public SchemaTableOperations(ProtoSchemaOptions<K, V, C> schemaOptions, Parameter[] upsertParameters) {
            super(schemaOptions.config.maxBatchSize(), schemaOptions.config.writeQueryTimeout().intValue(), schemaOptions.config.readQueryTimeout().intValue());
            this.schemaOptions = schemaOptions;
            this.upsertParameters = upsertParameters;
        }

        protected void setParameter(PreparedStatement ps, ProtostreamFieldType type, int position, Json json) throws SQLException {
            switch (type) {
                case INT_32: {
                    ps.setInt(position, json.asInteger());
                    break;
                }
                case INT_64: {
                    ps.setLong(position, json.asLong());
                    break;
                }
                case FLOAT: {
                    ps.setFloat(position, json.asFloat());
                    break;
                }
                case DOUBLE: {
                    ps.setDouble(position, json.asDouble());
                    break;
                }
                case BOOL: {
                    ps.setBoolean(position, json.asBoolean());
                    break;
                }
                case STRING: {
                    ps.setString(position, json.asString());
                    break;
                }
                case BYTES: {
                    String base64Bytes = json.asString();
                    byte[] bytes = Base64.getDecoder().decode(base64Bytes);
                    ps.setBytes(position, bytes);
                    break;
                }
                case DATE: {
                    long dateTime = json.asLong();
                    ps.setTimestamp(position, new Timestamp(dateTime));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type " + (Object)((Object)type) + " not supported!");
                }
            }
        }

        protected void updateJsonWithParameter(ResultSet rs, Parameter parameter, int offset, Json json, boolean key) throws SQLException {
            Object value;
            switch (parameter.getType()) {
                case INT_32: {
                    value = rs.getInt(offset);
                    break;
                }
                case INT_64: {
                    value = rs.getLong(offset);
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(rs.getFloat(offset));
                    break;
                }
                case DOUBLE: {
                    value = rs.getDouble(offset);
                    break;
                }
                case BOOL: {
                    value = rs.getBoolean(offset);
                    break;
                }
                case STRING: {
                    value = rs.getString(offset);
                    break;
                }
                case BYTES: {
                    byte[] bytes = rs.getBytes(offset);
                    value = bytes != null ? Base64.getEncoder().encodeToString(bytes) : null;
                    break;
                }
                case DATE: {
                    Timestamp timestamp = rs.getTimestamp(offset);
                    value = timestamp != null ? Long.valueOf(timestamp.getTime()) : null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type " + (Object)((Object)parameter.getType()) + " not supported!");
                }
            }
            if (value != null) {
                if (key) {
                    parameter.jsonConsumerKey.accept(json, value);
                } else {
                    parameter.jsonConsumerValue.accept(json, value);
                }
            }
        }

        protected MarshallableEntry<K, V> entryFromResultSet(ResultSet rs, Object keyIfProvided, boolean fetchValue, Predicate<? super K> keyPredicate) throws SQLException {
            Json keyJson;
            Object object = keyJson = keyIfProvided == null ? Json.object() : null;
            if (keyJson != null && this.schemaOptions.keyMessageName != null) {
                keyJson.set("_type", (Object)this.schemaOptions.keyMessageName);
            }
            Json valueJson = Json.object();
            if (this.schemaOptions.valueMessageName != null) {
                valueJson.set("_type", (Object)this.schemaOptions.valueMessageName);
            }
            Parameter[] valueParameters = this.schemaOptions.valueParameters;
            for (int i = 0; i < valueParameters.length; ++i) {
                Parameter parameter = valueParameters[i];
                if (parameter.isPrimaryIdentifier()) {
                    if (keyJson != null) {
                        this.updateJsonWithParameter(rs, parameter, i + 1, keyJson, true);
                    }
                    if (!((AbstractSchemaJdbcConfiguration)((Object)this.schemaOptions.config)).getSchemaJdbcConfiguration().embeddedKey()) continue;
                }
                this.updateJsonWithParameter(rs, parameter, i + 1, valueJson, false);
            }
            if (keyJson != null) {
                keyIfProvided = this.schemaOptions.keyConversion.toStorage((Object)keyJson.toString());
            }
            if (keyPredicate != null && !keyPredicate.test(keyIfProvided)) {
                return null;
            }
            Object value = this.schemaOptions.valueConversion.toStorage((Object)valueJson.toString());
            return this.schemaOptions.marshallableEntryFactory.create(keyIfProvided, value);
        }

        protected void prepareKeyStatement(PreparedStatement ps, Object key) throws SQLException {
            Object jsonString = this.schemaOptions.keyConversion.fromStorage(key);
            Json json = Json.read((String)((String)jsonString));
            for (int i = 0; i < this.schemaOptions.keyParameters.length; ++i) {
                Parameter parameter = this.schemaOptions.keyParameters[i];
                if (!parameter.primaryIdentifier) continue;
                Json innerJson = (Json)parameter.unwrapJsonKey.apply(json);
                if (innerJson != null) {
                    this.setParameter(ps, parameter.getType(), i + 1, innerJson);
                    continue;
                }
                ps.setNull(i + 1, parameter.getSqlType());
            }
        }

        protected void prepareValueStatement(PreparedStatement ps, int segment, MarshallableEntry<? extends K, ? extends V> entry) throws SQLException {
            boolean embeddedKey = ((AbstractSchemaJdbcConfiguration)((Object)this.schemaOptions.config)).getSchemaJdbcConfiguration().embeddedKey();
            Json valueJson = Json.read((String)((String)this.schemaOptions.valueConversion.fromStorage(entry.getValue())));
            Json keyJson = embeddedKey ? valueJson : Json.read((String)((String)this.schemaOptions.keyConversion.fromStorage(entry.getKey())));
            for (int i = 0; i < this.upsertParameters.length; ++i) {
                Parameter parameter = this.upsertParameters[i];
                Json json = parameter.primaryIdentifier ? (embeddedKey ? (Json)parameter.unwrapJsonValue.apply(keyJson) : (Json)parameter.unwrapJsonKey.apply(keyJson)) : (Json)parameter.unwrapJsonValue.apply(valueJson);
                if (json != null) {
                    this.setParameter(ps, parameter.getType(), i + 1, json);
                    continue;
                }
                ps.setNull(i + 1, parameter.getSqlType());
            }
        }
    }

    protected static class ProtoSchemaOptions<K, V, C extends AbstractSchemaJdbcConfiguration> {
        protected final C config;
        protected final Parameter[] keyParameters;
        protected final String keyMessageName;
        protected final Parameter[] valueParameters;
        protected final String valueMessageName;
        protected final DataConversion keyConversion;
        protected final DataConversion valueConversion;
        protected final MarshallableEntryFactory<K, V> marshallableEntryFactory;

        public ProtoSchemaOptions(C config, Parameter[] keyParameters, String keyMessageName, Parameter[] valueParameters, String valueMessageName, DataConversion keyConversion, DataConversion valueConversion, MarshallableEntryFactory<K, V> marshallableEntryFactory) {
            this.config = config;
            this.keyParameters = keyParameters;
            this.keyMessageName = keyMessageName;
            this.valueParameters = valueParameters;
            this.valueMessageName = valueMessageName;
            this.keyConversion = keyConversion;
            this.valueConversion = valueConversion;
            this.marshallableEntryFactory = marshallableEntryFactory;
        }
    }

    protected static class Parameter {
        private final String name;
        private final ProtostreamFieldType type;
        private final boolean primaryIdentifier;
        private final int sqlType;
        private BiConsumer<Json, Object> jsonConsumerValue;
        private BiConsumer<Json, Object> jsonConsumerKey;
        private Function<Json, Json> unwrapJsonValue;
        private Function<Json, Json> unwrapJsonKey;

        Parameter(String name, ProtostreamFieldType type, boolean primaryIdentifier, int sqlType) {
            this.name = name;
            this.type = type;
            this.primaryIdentifier = primaryIdentifier;
            this.sqlType = sqlType;
        }

        public String getName() {
            return this.name;
        }

        public ProtostreamFieldType getType() {
            return this.type;
        }

        public int getSqlType() {
            return this.sqlType;
        }

        public boolean isPrimaryIdentifier() {
            return this.primaryIdentifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return Objects.equals(this.name, parameter.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return "Parameter{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", primaryIdentifier=" + this.primaryIdentifier + '}';
        }
    }

    protected static enum ProtostreamFieldType {
        INT_32("int32"),
        INT_64("int64"),
        FLOAT("float"),
        DOUBLE("double"),
        BOOL("bool"),
        STRING("string"),
        BYTES("bytes"),
        DATE("fixed64");

        private final String protostreamType;

        private ProtostreamFieldType(String protostreamType) {
            this.protostreamType = protostreamType;
        }

        protected static ProtostreamFieldType from(int sqlType) {
            switch (sqlType) {
                case 2: 
                case 4: {
                    return INT_32;
                }
                case -5: {
                    return INT_64;
                }
                case 6: {
                    return FLOAT;
                }
                case 8: {
                    return DOUBLE;
                }
                case -7: 
                case 16: {
                    return BOOL;
                }
                case -16: 
                case -9: 
                case -1: 
                case 12: {
                    return STRING;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    return BYTES;
                }
                case 91: 
                case 93: 
                case 2014: {
                    return DATE;
                }
            }
            throw new IllegalArgumentException("SqlType not supported: " + sqlType);
        }
    }
}

