/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser;

import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser.JavacParser;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser.ParserFactory;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser.Tokens;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.tree.JCTree;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.List;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.ListBuffer;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Log;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Name;

public class ReferenceParser {
    private final ParserFactory fac;

    public ReferenceParser(ParserFactory fac) {
        this.fac = fac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference parse(String sig) throws ParseException {
        List<JCTree> paramTypes;
        Name member;
        JCTree qualExpr;
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.fac.log);
        try {
            int hash = sig.indexOf("#");
            int lparen = sig.indexOf("(", hash + 1);
            if (hash == -1) {
                if (lparen == -1) {
                    qualExpr = this.parseType(sig);
                    member = null;
                } else {
                    qualExpr = null;
                    member = this.parseMember(sig.substring(0, lparen));
                }
            } else {
                qualExpr = hash == 0 ? null : this.parseType(sig.substring(0, hash));
                member = lparen == -1 ? this.parseMember(sig.substring(hash + 1)) : this.parseMember(sig.substring(hash + 1, lparen));
            }
            if (lparen < 0) {
                paramTypes = null;
            } else {
                int rparen = sig.indexOf(")", lparen);
                if (rparen != sig.length() - 1) {
                    throw new ParseException("dc.ref.bad.parens");
                }
                paramTypes = this.parseParams(sig.substring(lparen + 1, rparen));
            }
            if (!deferredDiagnosticHandler.getDiagnostics().isEmpty()) {
                throw new ParseException("dc.ref.syntax.error");
            }
        }
        finally {
            this.fac.log.popDiagnosticHandler(deferredDiagnosticHandler);
        }
        return new Reference(qualExpr, member, paramTypes);
    }

    private JCTree parseType(String s) throws ParseException {
        JavacParser p = this.fac.newParser(s, false, false, false);
        JCTree.JCExpression tree = p.parseType();
        if (p.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return tree;
    }

    private Name parseMember(String s) throws ParseException {
        JavacParser p = this.fac.newParser(s, false, false, false);
        Name name = p.ident();
        if (p.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return name;
    }

    private List<JCTree> parseParams(String s) throws ParseException {
        if (s.trim().isEmpty()) {
            return List.nil();
        }
        JavacParser p = this.fac.newParser(s.replace("...", "[]"), false, false, false);
        ListBuffer<JCTree.JCExpression> paramTypes = new ListBuffer<JCTree.JCExpression>();
        paramTypes.add(p.parseType());
        if (p.token().kind == Tokens.TokenKind.IDENTIFIER) {
            p.nextToken();
        }
        while (p.token().kind == Tokens.TokenKind.COMMA) {
            p.nextToken();
            paramTypes.add(p.parseType());
            if (p.token().kind != Tokens.TokenKind.IDENTIFIER) continue;
            p.nextToken();
        }
        if (p.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return paramTypes.toList();
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ParseException(String message) {
            super(message);
        }
    }

    public static class Reference {
        public final JCTree qualExpr;
        public final Name member;
        public final List<JCTree> paramTypes;

        Reference(JCTree qualExpr, Name member, List<JCTree> paramTypes) {
            this.qualExpr = qualExpr;
            this.member = member;
            this.paramTypes = paramTypes;
        }
    }
}

