/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.filer;

import java.io.IOException;
import java.io.Writer;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaFileObject;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.io.CharSink;
import org.inferred.freebuilder.shaded.com.google.common.io.CharSource;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.Formatter;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.FormatterException;

final class FormattingJavaFileObject
extends ForwardingJavaFileObject<JavaFileObject> {
    private static final int DEFAULT_FILE_SIZE = 40000;
    private final Formatter formatter;

    FormattingJavaFileObject(JavaFileObject delegate, Formatter formatter) {
        super(Preconditions.checkNotNull(delegate));
        this.formatter = Preconditions.checkNotNull(formatter);
    }

    @Override
    public Writer openWriter() throws IOException {
        final StringBuilder stringBuilder = new StringBuilder(40000);
        return new Writer(){

            @Override
            public void write(char[] chars, int start, int end) throws IOException {
                stringBuilder.append(chars, start, end - start);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                try {
                    FormattingJavaFileObject.this.formatter.formatSource(CharSource.wrap(stringBuilder), new CharSink(){

                        @Override
                        public Writer openStream() throws IOException {
                            return ((JavaFileObject)FormattingJavaFileObject.this.fileObject).openWriter();
                        }
                    });
                }
                catch (FormatterException e) {
                    throw new IOException("Error formatting " + FormattingJavaFileObject.this.getName(), e);
                }
            }
        };
    }
}

