/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.com.google.googlejavaformat.java;

import java.util.concurrent.Callable;
import org.inferred.freebuilder.shaded.com.google.common.collect.Range;
import org.inferred.freebuilder.shaded.com.google.common.collect.RangeSet;
import org.inferred.freebuilder.shaded.com.google.common.collect.TreeRangeSet;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.CommandLineOptions;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.Formatter;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.FormatterException;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.ImportOrderer;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.JavaFormatterOptions;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.RemoveUnusedImports;

public class FormatFileCallable
implements Callable<String> {
    private final String input;
    private final CommandLineOptions parameters;
    private final JavaFormatterOptions options;

    public FormatFileCallable(CommandLineOptions parameters, String input, JavaFormatterOptions options) {
        this.input = input;
        this.parameters = parameters;
        this.options = options;
    }

    @Override
    public String call() throws FormatterException {
        if (this.parameters.fixImportsOnly()) {
            return this.fixImports(this.input);
        }
        String formatted = new Formatter(this.options).formatSource(this.input, this.characterRanges(this.input).asRanges());
        formatted = this.fixImports(formatted);
        return formatted;
    }

    private String fixImports(String input) throws FormatterException {
        if (this.parameters.removeUnusedImports()) {
            input = RemoveUnusedImports.removeUnusedImports(input, this.parameters.removeJavadocOnlyImports() ? RemoveUnusedImports.JavadocOnlyImports.REMOVE : RemoveUnusedImports.JavadocOnlyImports.KEEP);
        }
        if (this.parameters.sortImports()) {
            input = ImportOrderer.reorderImports(input);
        }
        return input;
    }

    private RangeSet<Integer> characterRanges(String input) {
        TreeRangeSet<Integer> characterRanges = TreeRangeSet.create();
        if (this.parameters.lines().isEmpty() && this.parameters.offsets().isEmpty()) {
            characterRanges.add(Range.closedOpen(0, input.length()));
            return characterRanges;
        }
        characterRanges.addAll(Formatter.lineRangesToCharRanges(input, this.parameters.lines()));
        for (int i = 0; i < this.parameters.offsets().size(); ++i) {
            Integer length = (Integer)this.parameters.lengths().get(i);
            if (length == 0) {
                length = 1;
            }
            characterRanges.add(Range.closedOpen((Comparable)this.parameters.offsets().get(i), (Integer)this.parameters.offsets().get(i) + length));
        }
        return characterRanges;
    }
}

