/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.ordinal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.immutables.ordinal.OrdinalDomain;
import org.immutables.ordinal.OrdinalValue;

@ThreadSafe
public abstract class InterningOrdinalDomain<S, E extends OrdinalValue<E>>
extends OrdinalDomain<E> {
    private final List<E> values = new CopyOnWriteArrayList();
    @GuardedBy(value="internedInstances")
    private final Map<S, E> internedInstances = new HashMap<S, E>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final E internOrdinal(S valueSample) {
        Map<S, E> map = this.internedInstances;
        synchronized (map) {
            OrdinalValue value = (OrdinalValue)this.internedInstances.get(valueSample);
            if (value == null) {
                value = this.extractValue(valueSample, this.internedInstances.size());
                this.internedInstances.put(valueSample, value);
                this.values.add(value);
            }
            return (E)value;
        }
    }

    protected abstract E extractValue(S var1, int var2);

    @Override
    public Iterator<E> iterator() {
        return this.values.iterator();
    }

    @Override
    public final E get(int ordinal) {
        return (E)((OrdinalValue)this.values.get(ordinal));
    }

    @Override
    public final int length() {
        return this.values.size();
    }
}

