/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.ordinal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.immutables.ordinal.OrdinalDomain;
import org.immutables.ordinal.OrdinalValue;

public abstract class ImmutableOrdinalSet<E extends OrdinalValue<E>>
extends ForwardingSet<E> {
    private static final ImmutableOrdinalSet<?> EMPTY_SET = new EmptyImmutableOrdinalSet();

    ImmutableOrdinalSet() {
    }

    public static <E extends OrdinalValue<E>> ImmutableOrdinalSet<E> of() {
        return EMPTY_SET;
    }

    @SafeVarargs
    public static <E extends OrdinalValue<E>> ImmutableOrdinalSet<E> of(E first, E ... rest) {
        OrdinalDomain<E> domain = first.domain();
        if (rest.length == 0) {
            return new SingletonImmutableOrdinalSet<E>(first);
        }
        OrdinalValue[] array = new OrdinalValue[1 + rest.length];
        array[0] = first;
        System.arraycopy(rest, 0, array, 1, rest.length);
        return new RegularImmutableOrdinalSet<E>(domain, array);
    }

    public static <E extends OrdinalValue<E>> ImmutableOrdinalSet<E> copyOf(Iterable<? extends E> elements) {
        if (elements instanceof ImmutableOrdinalSet) {
            return (ImmutableOrdinalSet)((Object)elements);
        }
        return ImmutableOrdinalSet.constructFromArray((OrdinalValue[])Iterables.toArray(elements, OrdinalValue.class));
    }

    public static <E extends OrdinalValue<E>> ImmutableOrdinalSet<E> copyOf(E[] elements) {
        return ImmutableOrdinalSet.constructFromArray(elements);
    }

    private static <E extends OrdinalValue<E>> ImmutableOrdinalSet<E> constructFromArray(OrdinalValue<?>[] array) {
        switch (array.length) {
            case 0: {
                return ImmutableOrdinalSet.of();
            }
            case 1: {
                return new SingletonImmutableOrdinalSet(array[0]);
            }
        }
        return new RegularImmutableOrdinalSet(array[0].domain(), array);
    }

    @Deprecated
    public final boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final boolean addAll(Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final boolean removeAll(Collection<?> oldElements) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final boolean retainAll(Collection<?> elementsToKeep) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public abstract void incrementCounters(int[] var1);

    public boolean containsAny(Collection<?> collection) {
        for (Object object : collection) {
            if (!this.contains(object)) continue;
            return true;
        }
        return false;
    }

    public static <E extends OrdinalValue<E>> Builder<E> builder() {
        return new Builder();
    }

    public static final class Builder<E extends OrdinalValue<E>> {
        private final List<E> builder = Lists.newArrayListWithExpectedSize((int)4);

        Builder() {
        }

        public Builder<E> addAll(Iterable<E> elements) {
            Iterables.addAll(this.builder, (Iterable)((Iterable)Preconditions.checkNotNull(elements)));
            return this;
        }

        public Builder<E> add(E element) {
            this.builder.add(Preconditions.checkNotNull(element));
            return this;
        }

        public ImmutableOrdinalSet<E> build() {
            return ImmutableOrdinalSet.copyOf(this.builder);
        }
    }

    private static class RegularImmutableOrdinalSet<E extends OrdinalValue<E>>
    extends ImmutableOrdinalSet<E> {
        private static final int BITS_PER_WORD = 64;
        private static final int POWER_OF_TWO_WORD_BITS = 6;
        private final OrdinalDomain<E> domain;
        private final long[] vector;
        private final int size;

        RegularImmutableOrdinalSet(OrdinalDomain<E> domain, OrdinalValue<?>[] elements) {
            int maxOrdinal = 0;
            int count = 0;
            for (OrdinalValue<?> e : elements) {
                Preconditions.checkArgument((boolean)e.domain().equals(domain), (String)"Element has different domain %s", (Object[])new Object[]{e});
                maxOrdinal = Math.max(maxOrdinal, e.ordinal());
                ++count;
            }
            this.domain = domain;
            this.size = count;
            this.vector = new long[(maxOrdinal >>> 6) + 1];
            this.fillVector(elements);
        }

        private void fillVector(OrdinalValue<?>[] elements) {
            for (OrdinalValue<?> e : elements) {
                int bitIndex;
                int ordinal = e.ordinal();
                int wordIndex = ordinal >>> 6;
                long word = this.vector[wordIndex];
                if ((word >>> (bitIndex = ordinal - (wordIndex << 6)) & 1L) != 0L) {
                    Preconditions.checkArgument((boolean)false, (String)"Duplicate element %s", (Object[])new Object[]{e});
                }
                this.vector[wordIndex] = word | 1L << bitIndex;
            }
        }

        protected Set<E> delegate() {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < this.vector.length; ++i) {
                long word = this.vector[i];
                int wordOrdinal = i * 64;
                for (int bitIndex = 0; bitIndex < 64; ++bitIndex) {
                    if ((word >>> bitIndex & 1L) == 0L) continue;
                    builder.add(this.domain.get(wordOrdinal + bitIndex));
                }
            }
            return builder.build();
        }

        public boolean contains(Object object) {
            OrdinalValue value;
            if (object instanceof OrdinalValue && (value = (OrdinalValue)object).domain().equals(this.domain)) {
                return this.containsOrdinal(value.ordinal());
            }
            return false;
        }

        private boolean containsOrdinal(int ordinal) {
            int wordIndex = ordinal >>> 6;
            int bitIndex = ordinal - (wordIndex << 6);
            return wordIndex < this.vector.length && (this.vector[wordIndex] >>> bitIndex & 1L) != 0L;
        }

        private boolean containsAllOrdinals(RegularImmutableOrdinalSet<?> ordinalSet) {
            long[] vector = this.vector;
            long[] otherVector = ordinalSet.vector;
            if (vector.length < otherVector.length) {
                return false;
            }
            for (int i = 0; i < otherVector.length; ++i) {
                long v = vector[i];
                long ov = otherVector[i];
                if ((v & ov) == ov) continue;
                return false;
            }
            return true;
        }

        private boolean containsAnyOrdinal(RegularImmutableOrdinalSet<?> ordinalSet) {
            long[] otherVector = ordinalSet.vector;
            long[] vector = this.vector;
            for (int i = 0; i < otherVector.length && i < vector.length; ++i) {
                long v = vector[i];
                long ov = otherVector[i];
                if ((v & ov) <= 0L) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAny(Collection<?> collection) {
            int size = collection.size();
            if (size == 0) {
                return false;
            }
            if (size == 1) {
                return this.contains(Iterables.get(collection, (int)0));
            }
            if (collection instanceof RegularImmutableOrdinalSet) {
                RegularImmutableOrdinalSet otherSet = (RegularImmutableOrdinalSet)((Object)collection);
                return otherSet.domain.equals(this.domain) && this.containsAnyOrdinal(otherSet);
            }
            return super.containsAny(collection);
        }

        public boolean containsAll(Collection<?> collection) {
            int size = collection.size();
            if (size == 0) {
                return true;
            }
            if (size == 1) {
                return this.contains(Iterables.get(collection, (int)0));
            }
            if (collection instanceof RegularImmutableOrdinalSet) {
                RegularImmutableOrdinalSet otherSet = (RegularImmutableOrdinalSet)((Object)collection);
                return otherSet.domain.equals(this.domain) && this.containsAllOrdinals(otherSet);
            }
            return super.containsAll(collection);
        }

        public boolean isEmpty() {
            return false;
        }

        public int size() {
            return this.size;
        }

        @Override
        public void incrementCounters(int[] counters) {
            long[] vector = this.vector;
            for (int i = 0; i < vector.length; ++i) {
                int zeroes;
                long v = vector[i];
                int ordinal = i << 6;
                while (v != 0L && (zeroes = Long.numberOfTrailingZeros(v)) != 64) {
                    v = zeroes == 63 ? 0L : (v >>>= zeroes + 1);
                    ordinal += zeroes;
                    int n = ordinal++;
                    counters[n] = counters[n] + 1;
                }
            }
        }
    }

    private static class SingletonImmutableOrdinalSet<E extends OrdinalValue<E>>
    extends ImmutableOrdinalSet<E> {
        private final E element;

        SingletonImmutableOrdinalSet(E element) {
            this.element = (OrdinalValue)Preconditions.checkNotNull(element);
        }

        public boolean contains(Object object) {
            return this.element.equals(object);
        }

        public boolean containsAll(Collection<?> collection) {
            if (collection instanceof SingletonImmutableOrdinalSet) {
                return this.element.equals(((SingletonImmutableOrdinalSet)((Object)collection)).element);
            }
            return super.containsAll(collection);
        }

        @Override
        public boolean containsAny(Collection<?> collection) {
            return collection.contains(this.element);
        }

        protected Set<E> delegate() {
            return ImmutableSet.of(this.element);
        }

        public int size() {
            return 1;
        }

        public boolean isEmpty() {
            return false;
        }

        @Override
        public void incrementCounters(int[] counters) {
            int n = this.element.ordinal();
            counters[n] = counters[n] + 1;
        }
    }

    private static class EmptyImmutableOrdinalSet<E extends OrdinalValue<E>>
    extends ImmutableOrdinalSet<E> {
        private EmptyImmutableOrdinalSet() {
        }

        protected Set<E> delegate() {
            return ImmutableSet.of();
        }

        public boolean isEmpty() {
            return true;
        }

        public int size() {
            return 0;
        }

        public boolean containsAll(Collection<?> collection) {
            return collection.isEmpty();
        }

        @Override
        public boolean containsAny(Collection<?> collection) {
            return false;
        }

        @Override
        public void incrementCounters(int[] countersByOrdinal) {
        }
    }
}

