/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mirror.processor;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.immutables.generator.AbstractTemplate;
import org.immutables.generator.Generator;
import org.immutables.mirror.Mirror;

@Generator.Template
@Generator.Import(value={MirrorModel.class, MirrorModel.AttributeModel.class})
class Mirrors
extends AbstractTemplate {
    Mirrors() {
    }

    ImmutableList<MirrorModel> allMirrors() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Element element : this.round().getElementsAnnotatedWith(Mirror.Annotation.class)) {
            TypeElement typeElement = this.validated(element);
            if (typeElement == null) continue;
            builder.add((Object)new MirrorModel(typeElement));
        }
        return builder.build();
    }

    private static TypeElement toElement(TypeMirror type) {
        return (TypeElement)((DeclaredType)type).asElement();
    }

    @Nullable
    private TypeElement validated(Element element) {
        Element enclosingElement = element.getEnclosingElement();
        if (element.getKind() == ElementKind.ANNOTATION_TYPE && element.getModifiers().contains((Object)Modifier.PUBLIC) && enclosingElement != null && (enclosingElement.getKind() != ElementKind.PACKAGE || !((PackageElement)enclosingElement).isUnnamed())) {
            return (TypeElement)element;
        }
        this.processing().getMessager().printMessage(Diagnostic.Kind.ERROR, "Element annotated with @Mirror.Annotation annotation should public annotation type in a package", element);
        return null;
    }

    static enum AttributeTypeKind {
        PRIMITIVE,
        STRING,
        ENUM,
        ANNOTATION,
        TYPE;


        boolean isPrimitive() {
            return this == PRIMITIVE;
        }

        boolean isString() {
            return this == STRING;
        }

        boolean isEnum() {
            return this == ENUM;
        }

        boolean isAnnotation() {
            return this == ANNOTATION;
        }

        boolean isType() {
            return this == TYPE;
        }

        static AttributeTypeKind from(TypeMirror type) {
            if (type.getKind() == TypeKind.DECLARED) {
                TypeElement typeElement = Mirrors.toElement(type);
                if (typeElement.getKind() == ElementKind.ENUM) {
                    return ENUM;
                }
                if (typeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
                    return ANNOTATION;
                }
                Name qualifiedName = typeElement.getQualifiedName();
                if (qualifiedName.contentEquals(Class.class.getName())) {
                    return TYPE;
                }
                if (qualifiedName.contentEquals(String.class.getName())) {
                    return STRING;
                }
            } else if (type.getKind().isPrimitive()) {
                return PRIMITIVE;
            }
            throw new AssertionError();
        }
    }

    class MirrorModel {
        final TypeElement element;
        final ImmutableList<AttributeModel> attributes;
        final String name;
        final String $$package;
        final String qualifiedName;

        MirrorModel(TypeElement element) {
            this.element = element;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ExecutableElement attribute : ElementFilter.methodsIn(element.getEnclosedElements())) {
                builder.add((Object)new AttributeModel(attribute));
            }
            this.attributes = builder.build();
            this.name = element.getSimpleName().toString();
            Element e = element;
            while (true) {
                if (e.getKind() == ElementKind.PACKAGE) break;
                e = e.getEnclosingElement();
            }
            PackageElement packageElement = (PackageElement)e;
            this.$$package = packageElement.getQualifiedName().toString();
            this.qualifiedName = element.getAnnotation(Mirror.Annotation.class).value();
        }

        String simpleName() {
            return (String)Iterables.getLast((Iterable)Splitter.on((char)'.').splitToList((CharSequence)this.qualifiedName));
        }

        class AttributeModel {
            final ExecutableElement element;
            final String name;
            final boolean isArray;
            final TypeMirror type;
            final AttributeTypeKind kind;
            final String suffix;
            @Nullable
            final MirrorModel mirrorModel;

            AttributeModel(ExecutableElement element) {
                this.element = element;
                this.name = element.getSimpleName().toString();
                TypeMirror type = element.getReturnType();
                this.isArray = type.getKind() == TypeKind.ARRAY;
                this.type = this.isArray ? ((ArrayType)type).getComponentType() : type;
                this.kind = AttributeTypeKind.from(this.type);
                this.suffix = this.isArray ? "[]" : "";
                this.mirrorModel = this.getMirrorModelIfAnnotation();
            }

            @Nullable
            private MirrorModel getMirrorModelIfAnnotation() {
                TypeElement element;
                if (this.kind == AttributeTypeKind.ANNOTATION && (element = Mirrors.toElement(this.type)).getAnnotation(Mirror.Annotation.class) != null) {
                    return new MirrorModel(element);
                }
                return null;
            }

            boolean isBoolean() {
                return this.type.getKind() == TypeKind.BOOLEAN;
            }

            boolean isFloat() {
                return this.type.getKind() == TypeKind.FLOAT;
            }

            boolean isDouble() {
                return this.type.getKind() == TypeKind.DOUBLE;
            }
        }
    }
}

