/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import java.util.List;
import org.immutables.generator.StringLiterals;
import org.immutables.trees.Trees;
import org.immutables.value.Value;

@Value.Enclosing
@Trees.Transform
@Trees.Ast
public class Trees {
    private Trees() {
    }

    @Value.Immutable
    public static abstract class TextLine
    implements TemplatePart,
    Synthetic {
        public abstract TextFragment fragment();

        public boolean isBlank() {
            return this.fragment().isWhitespace();
        }

        public boolean isEmpty() {
            return this.fragment().value().isEmpty();
        }

        @Value.Default
        public boolean newline() {
            return false;
        }

        public String toString() {
            return StringLiterals.toLiteral((String)(this.fragment().value() + (this.newline() ? "\n" : "")));
        }
    }

    @Value.Immutable
    public static interface TextBlock
    extends TemplatePart {
        public List<TextPart> parts();
    }

    @Value.Immutable(builder=false)
    public static abstract class TextFragment
    implements TextPart {
        @Value.Parameter
        public abstract String value();

        public String toString() {
            return StringLiterals.toLiteral((String)this.value());
        }

        public boolean isWhitespace() {
            return CharMatcher.whitespace().matchesAllOf((CharSequence)this.value());
        }
    }

    @Value.Immutable(singleton=true, builder=false)
    public static abstract class Newline
    implements TextPart {
        public String toString() {
            return StringLiterals.toLiteral((String)"\n");
        }
    }

    @Value.Immutable(builder=false)
    public static abstract class StringLiteral
    implements Expression {
        @Value.Parameter
        public abstract String value();

        public String toString() {
            return StringLiterals.toLiteral((String)this.value());
        }
    }

    public static interface TextPart {
    }

    @Value.Immutable(singleton=true, builder=false)
    public static interface TemplateEnd
    extends DirectiveEnd,
    Synthetic {
    }

    @Value.Immutable(singleton=true, builder=false)
    public static interface Else
    extends Otherwise {
    }

    public static interface Conditional {
        public Expression condition();
    }

    @Value.Immutable
    public static interface ElseIf
    extends Otherwise,
    Conditional {
    }

    public static interface Otherwise
    extends DirectiveStart {
    }

    @Value.Immutable
    public static interface If
    extends Conditional,
    DirectiveStart {
    }

    @Value.Immutable
    public static interface For
    extends DirectiveStart {
        public List<GeneratorDeclaration> declaration();
    }

    @Value.Immutable
    public static interface TransformGenerator
    extends GeneratorValueDeclaration {
        public Expression transform();

        public ValueDeclaration varDeclaration();

        public Optional<Expression> condition();
    }

    @Value.Immutable
    public static interface IterationGenerator
    extends GeneratorValueDeclaration {
        public Optional<Expression> condition();
    }

    @Value.Immutable
    public static interface AssignGenerator
    extends GeneratorValueDeclaration {
    }

    public static interface GeneratorValueDeclaration
    extends GeneratorDeclaration {
        public ValueDeclaration declaration();

        public Expression from();
    }

    public static interface GeneratorDeclaration {
    }

    @Value.Immutable
    public static interface ApplyExpression
    extends Expression {
        public List<Expression> params();
    }

    @Value.Immutable
    public static interface SimpleAccessExpression
    extends AccessExpression {
    }

    public static interface AccessExpression
    extends Expression {
        public List<Identifier> path();
    }

    public static interface Expression {
    }

    @Value.Immutable
    public static abstract class Template
    implements Directive,
    Block,
    UnitPart,
    InvokableStatement {
        @Value.Default
        public boolean isPublic() {
            return false;
        }
    }

    public static interface Synthetic {
    }

    public static interface TemplatePart {
    }

    @Value.Immutable
    public static interface Unit {
        public List<UnitPart> parts();
    }

    public static interface UnitPart {
    }

    @Value.Immutable
    public static interface Let
    extends DirectiveStart,
    InvokableStatement {
    }

    public static interface Directive
    extends TemplatePart {
    }

    @Value.Immutable
    public static interface Invoke
    extends InvokeDeclaration,
    DirectiveStart {
    }

    public static interface InvokeDeclaration {
        public AccessExpression access();

        public Optional<ApplyExpression> invoke();
    }

    @Value.Immutable(builder=false)
    public static interface InvokeString
    extends DirectiveStart {
        @Value.Parameter
        public StringLiteral literal();
    }

    @Value.Immutable(builder=false)
    public static interface InvokeEnd
    extends DirectiveEnd {
        @Value.Parameter
        public AccessExpression access();
    }

    @Value.Immutable(singleton=true, builder=false)
    public static interface IfEnd
    extends DirectiveEnd {
    }

    @Value.Immutable(singleton=true, builder=false)
    public static interface ForEnd
    extends DirectiveEnd {
    }

    @Value.Immutable(singleton=true, builder=false)
    public static interface LetEnd
    extends DirectiveEnd {
    }

    public static interface DirectiveEnd
    extends Directive {
    }

    public static interface DirectiveStart
    extends Directive {
    }

    @Value.Immutable
    public static interface InvokeStatement
    extends Block,
    Synthetic {
        public Expression access();

        public List<Expression> params();
    }

    @Value.Immutable
    public static interface LetStatement
    extends Block,
    InvokableStatement,
    Synthetic {
    }

    @Value.Immutable(builder=false)
    public static interface ForIterationAccessExpression
    extends AccessExpression {
        @Value.Parameter
        public AccessExpression access();
    }

    @Value.Immutable
    public static abstract class ForStatement
    implements Block,
    Synthetic {
        @Value.Default
        public boolean useForAccess() {
            return true;
        }

        @Value.Default
        public boolean useDelimit() {
            return true;
        }

        public abstract List<GeneratorDeclaration> declaration();
    }

    @Value.Immutable
    public static interface IfStatement
    extends TemplatePart,
    Synthetic {
        public ConditionalBlock then();

        public List<ConditionalBlock> otherwiseIf();

        public Optional<Block> otherwise();
    }

    @Value.Immutable
    public static interface ConditionalBlock
    extends Conditional,
    Block,
    Synthetic {
    }

    @Value.Immutable(singleton=true, builder=false)
    public static interface Comment
    extends UnitPart,
    TemplatePart {
    }

    @Value.Immutable
    public static interface SimpleBlock
    extends Block {
    }

    public static interface Block
    extends TemplatePart {
        public List<TemplatePart> parts();
    }

    public static interface InvokableStatement {
        public InvokableDeclaration declaration();
    }

    public static interface Named {
        public Identifier name();
    }

    @Value.Immutable
    public static interface Parameter
    extends Named,
    Typed {
    }

    public static interface Typed {
        public TypeReference type();
    }

    @Value.Immutable
    public static interface ValueDeclaration
    extends Named {
        public Optional<TypeReference> type();

        public Optional<TypeReference> containedType();

        public ValueDeclaration withType(TypeReference var1);

        public ValueDeclaration withContainedType(TypeReference var1);
    }

    @Value.Immutable
    public static interface InvokableDeclaration
    extends Named {
        public List<Parameter> parameters();
    }

    @Value.Immutable
    public static abstract class BoundAccessExpression
    implements AccessExpression,
    Synthetic {
        public abstract List<Object> accessor();

        public String toString() {
            return this.accessor().toString();
        }
    }

    @Value.Immutable
    public static abstract class ResolvedType
    implements TypeReference,
    Synthetic {
        @Value.Parameter
        public abstract Object type();

        public String toString() {
            return this.type().toString();
        }
    }

    @Value.Immutable
    public static abstract class TypeDeclaration
    implements TypeReference {
        public abstract TypeIdentifier type();

        @Value.Default
        public Kind kind() {
            return Kind.SCALAR;
        }

        public static enum Kind {
            SCALAR,
            ITERABLE;

        }
    }

    public static interface TypeReference {
    }

    @Value.Immutable(builder=false)
    public static abstract class TypeIdentifier {
        @Value.Parameter
        public abstract String value();

        public String toString() {
            return "`" + this.value() + "`";
        }
    }

    @Value.Immutable(builder=false)
    public static abstract class Identifier {
        @Value.Parameter
        public abstract String value();

        public String toString() {
            return "`" + this.value() + "`";
        }
    }
}

