/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.immutables.generator.Intrinsics;
import org.immutables.generator.StringLiterals;
import org.immutables.generator.Templates;
import org.immutables.generator.processor.Accessors;
import org.immutables.generator.processor.ImmutableTrees;
import org.immutables.generator.processor.SwissArmyKnife;
import org.immutables.generator.processor.Trees;
import org.immutables.generator.processor.TreesTransformer;
import org.immutables.generator.processor.TypeResolver;

public final class TemplateWriter
extends TreesTransformer {
    private final TypeElement sourceElement;
    private final String simpleName;
    private final SwissArmyKnife knife;
    private final Context context = new Context();

    public TemplateWriter(SwissArmyKnife knife, TypeElement sourceElement, String simpleName) {
        this.knife = knife;
        this.sourceElement = sourceElement;
        this.simpleName = simpleName;
    }

    public CharSequence toCharSequence(ImmutableTrees.Unit unit) {
        this.toUnit(unit);
        return this.context.builder;
    }

    @Override
    public ImmutableTrees.Unit toUnit(ImmutableTrees.Unit value) {
        this.context.out("package ", this.knife.elements.getPackageOf(this.sourceElement).getQualifiedName(), ";").ln().ln().out("import static ", Intrinsics.class, ".*;").ln().ln();
        this.context.out("@", SuppressWarnings.class, "(", StringLiterals.toLiteral((String)"all"), ")").ln().out("public class ", this.simpleName, " extends ", this.sourceElement.getQualifiedName()).out((Object)" ").openBrace();
        int braces = this.context.getAndSetPendingBraces(0);
        ImmutableTrees.Unit unit = super.toUnit(value);
        this.writeTemplateDispatch(this.context);
        this.context.getAndSetPendingBraces(braces);
        this.context.ln().closeBraces().ln();
        return unit;
    }

    private void writeTemplateDispatch(Context context) {
        int initialBraces = context.getAndSetPendingBraces(0);
        context.out("private class FragmentDispatch extends ", Templates.Fragment.class, "").openBrace().ln().out((Object)"private final int index;").ln().out((Object)"FragmentDispatch(int arity, int index)").openBrace().ln().out((Object)"super(arity);").ln().out((Object)"this.index = index;").ln().closeBrace().ln().out("@Override public void run(", Templates.Invokation.class, " invokation)").openBrace().indent().ln().out((Object)"switch (index)").openBrace().ln();
        for (int i = 0; i < context.templateIndex.size(); ++i) {
            String templateName = context.templateIndex.get(i);
            context.out("case ", i, ": _t", i, "__", templateName, "(invokation); break;").ln();
        }
        context.out((Object)"default: break;");
        context.outdent().ln().closeBraces().ln().getAndSetPendingBraces(initialBraces);
    }

    @Override
    public ImmutableTrees.Template toTemplate(final ImmutableTrees.Template template) {
        String name = template.declaration().name().value();
        this.context.ln().out((Object)(template.isPublic() ? "public " : "")).out((Object)Templates.Invokable.class).out((Object)" ").out((Object)name).out((Object)"() { return ").out((Object)name).out((Object)"; }").ln();
        this.context.out((Object)"private ");
        new DispatchedTemplateLike(){
            {
                this.declaration = template.declaration();
                this.variable = true;
            }

            @Override
            void body() {
                TemplateWriter.this.asTemplateDeclaration(template, template.declaration());
                TemplateWriter.this.asTemplatePartsElements(template, (List<Trees.TemplatePart>)template.parts());
            }
        }.generate(this.context);
        this.context.out((Object)";").ln();
        return template;
    }

    @Override
    public ImmutableTrees.LetStatement toLetStatement(final ImmutableTrees.LetStatement statement) {
        new TemplateLike(){
            {
                this.declaration = statement.declaration();
                this.variable = true;
            }

            @Override
            void body() {
                TemplateWriter.this.context.out((Object)"final ").out((Object)Templates.Invokable.class).out((Object)" ").out((Object)statement.declaration().name().value()).out((Object)" = this;").ln();
                TemplateWriter.this.asLetStatementDeclaration(statement, statement.declaration());
                TemplateWriter.this.asLetStatementPartsElements(statement, (List<Trees.TemplatePart>)statement.parts());
            }
        }.generate(this.context);
        this.context.out((Object)";").delimit();
        return statement;
    }

    @Override
    public ImmutableTrees.ForStatement toForStatement(ImmutableTrees.ForStatement statement) {
        this.context.openBrace();
        if (statement.useForAccess()) {
            this.context.infor().out((Object)"final ").out((Object)Templates.Iteration.class).out((Object)" ").out((Object)this.context.accessMapper("for")).out((Object)" = new ").out((Object)Templates.Iteration.class).out((Object)"();").ln();
        }
        this.asForStatementDeclarationElements(statement, (List<Trees.GeneratorDeclaration>)statement.declaration());
        int braces = this.context.getAndSetPendingBraces(0);
        this.context.indent();
        if (statement.useDelimit()) {
            this.context.delimit();
        }
        this.asForStatementPartsElements(statement, (List<Trees.TemplatePart>)statement.parts());
        if (statement.useDelimit()) {
            this.context.delimit();
        }
        if (statement.useForAccess()) {
            this.context.out((Object)this.context.accessMapper("for")).out((Object)".index++;").ln();
            this.context.out((Object)this.context.accessMapper("for")).out((Object)".first = false;");
            this.context.outfor();
        }
        this.context.getAndSetPendingBraces(braces);
        this.context.outdent().ln().closeBraces().ln();
        if (statement.useDelimit()) {
            this.context.delimit();
        }
        return statement;
    }

    @Override
    public ImmutableTrees.InvokeString toInvokeString(ImmutableTrees.InvokeString value) {
        this.context.out("$(__, ", value.literal(), ");").ln();
        return value;
    }

    @Override
    public ImmutableTrees.InvokeStatement toInvokeStatement(final ImmutableTrees.InvokeStatement statement) {
        this.context.out((Object)"$(__, ");
        this.asInvokeStatementAccess(statement, statement.access());
        this.asInvokeStatementParamsElements(statement, (List<Trees.Expression>)statement.params());
        if (!statement.parts().isEmpty()) {
            this.context.out((Object)", ");
            new TemplateLike(){
                {
                    this.declaration = ImmutableTrees.InvokableDeclaration.builder().name(ImmutableTrees.Identifier.of("")).build();
                }

                @Override
                void body() {
                    TemplateWriter.this.asInvokeStatementPartsElements(statement, (List<Trees.TemplatePart>)statement.parts());
                }
            }.generate(this.context);
        }
        this.context.out((Object)");").ln();
        return statement;
    }

    @Override
    protected Iterable<Trees.Expression> asInvokeStatementParamsElements(ImmutableTrees.InvokeStatement value, List<Trees.Expression> collection) {
        for (Trees.Expression element : collection) {
            this.context.out((Object)", ");
            this.asInvokeStatementParams(value, element);
        }
        return collection;
    }

    @Override
    public ImmutableTrees.AssignGenerator toAssignGenerator(ImmutableTrees.AssignGenerator generator) {
        this.asAssignGeneratorDeclaration(generator, generator.declaration());
        this.context.out((Object)" = $cast(");
        this.asAssignGeneratorFrom(generator, generator.from());
        this.context.out((Object)");").ln();
        return generator;
    }

    @Override
    public ImmutableTrees.TransformGenerator toTransformGenerator(ImmutableTrees.TransformGenerator generator) {
        this.context.out((Object)Collection.class).out((Object)"<").out(generator.declaration().containedType().get()).out((Object)"> ").out((Object)generator.declaration().name().value()).out((Object)" = ").out((Object)Intrinsics.class).out((Object)".$collect();").ln();
        int braces = this.context.getAndSetPendingBraces(0);
        this.context.out((Object)"for (");
        this.asTransformGeneratorVarDeclaration(generator, generator.varDeclaration());
        this.context.out((Object)" : $in(");
        this.asTransformGeneratorFrom(generator, generator.from());
        this.context.out((Object)")) ").openBrace().indent().ln();
        if (generator.condition().isPresent()) {
            this.context.out((Object)"if ($if(");
            this.asTransformGeneratorConditionOptional(generator, generator.condition());
            this.context.out((Object)")) ").openBrace().ln();
        }
        this.context.out((Object)generator.declaration().name().value()).out((Object)".add(");
        this.asTransformGeneratorTransform(generator, generator.transform());
        this.context.out((Object)");");
        this.context.outdent().ln().closeBraces();
        this.context.getAndSetPendingBraces(braces);
        return generator;
    }

    @Override
    public ImmutableTrees.IterationGenerator toIterationGenerator(ImmutableTrees.IterationGenerator generator) {
        this.context.out((Object)"for (");
        this.asIterationGeneratorDeclaration(generator, generator.declaration());
        this.context.out((Object)" : $in(");
        this.asIterationGeneratorFrom(generator, generator.from());
        this.context.out((Object)")) ").openBrace().ln();
        if (generator.condition().isPresent()) {
            this.context.out((Object)"if ($if(");
            this.asIterationGeneratorConditionOptional(generator, generator.condition());
            this.context.out((Object)")) ").openBrace().ln();
        }
        return generator;
    }

    @Override
    public ImmutableTrees.ValueDeclaration toValueDeclaration(ImmutableTrees.ValueDeclaration value) {
        this.context.out((Object)"final ").out(this.requiredResolvedTypeOfDeclaration(value)).out((Object)" ").out((Object)value.name().value());
        return value;
    }

    private Object requiredResolvedTypeOfDeclaration(Trees.ValueDeclaration value) {
        return ((ImmutableTrees.ResolvedType)value.type().get()).type();
    }

    @Override
    public ImmutableTrees.TextLine toTextLine(ImmutableTrees.TextLine line) {
        if (line.fragment().value().isEmpty()) {
            if (line.newline()) {
                this.context.out((Object)"__.ln();").ln();
            }
        } else {
            this.context.out((Object)"__.out(").out((Object)line.fragment()).out((Object)(line.newline() ? ").ln();" : ");")).ln();
        }
        return line;
    }

    @Override
    public ImmutableTrees.StringLiteral toStringLiteral(ImmutableTrees.StringLiteral value) {
        this.context.out((Object)value);
        return value;
    }

    @Override
    public ImmutableTrees.BoundAccessExpression toBoundAccessExpression(ImmutableTrees.BoundAccessExpression value) {
        ImmutableList<Accessors.BoundAccess> accessList = TypeResolver.asBoundAccess(value.accessor());
        StringBuilder expressionBuilder = new StringBuilder();
        for (int i = 0; i < accessList.size(); ++i) {
            boolean first = i == 0;
            boolean last = i != accessList.size() - 1;
            Accessors.BoundAccess access = (Accessors.BoundAccess)accessList.get(i);
            if (!first) {
                expressionBuilder.append(".");
            }
            String name = access.name;
            if (first) {
                name = this.context.accessMapper(name);
            }
            expressionBuilder.append(name).append(access.callable ? "()" : "");
            if (!access.boxed || !last) continue;
            expressionBuilder.insert(0, "$(");
            expressionBuilder.append(")");
        }
        this.context.out((Object)expressionBuilder);
        return value;
    }

    @Override
    public ImmutableTrees.ApplyExpression toApplyExpression(ImmutableTrees.ApplyExpression value) {
        this.context.out((Object)"$(");
        ImmutableTrees.ApplyExpression expression = super.toApplyExpression(value);
        this.context.out((Object)")");
        return expression;
    }

    @Override
    protected Iterable<Trees.Expression> asApplyExpressionParamsElements(ImmutableTrees.ApplyExpression value, List<Trees.Expression> collection) {
        boolean first = true;
        for (Trees.Expression element : collection) {
            if (!first) {
                this.context.out((Object)", ");
            }
            first = false;
            this.asApplyExpressionParams(value, element);
        }
        return collection;
    }

    private void writeConditionPart(ImmutableTrees.ConditionalBlock block) {
        this.context.out((Object)"if ($if(");
        this.asConditionalBlockCondition(block, block.condition());
        this.context.out((Object)")) {").indent().ln();
        this.context.delimit();
        this.asConditionalBlockPartsElements(block, (List<Trees.TemplatePart>)block.parts());
    }

    @Override
    public ImmutableTrees.IfStatement toIfStatement(ImmutableTrees.IfStatement statement) {
        this.context.delimit().ln();
        this.writeConditionPart((ImmutableTrees.ConditionalBlock)statement.then());
        for (Trees.ConditionalBlock block : statement.otherwiseIf()) {
            this.context.outdent().out((Object)"} else ");
            this.writeConditionPart((ImmutableTrees.ConditionalBlock)block);
        }
        if (statement.otherwise().isPresent()) {
            this.context.outdent().ln().out((Object)"} else {").indent().ln().delimit();
            this.toSimpleBlock((ImmutableTrees.SimpleBlock)statement.otherwise().get());
        }
        this.context.outdent().ln().out((Object)"}").ln().delimit();
        return statement;
    }

    @Override
    public ImmutableTrees.Comment toComment(ImmutableTrees.Comment value) {
        this.context.delimit();
        return value;
    }

    @Override
    public ImmutableTrees.InvokableDeclaration toInvokableDeclaration(ImmutableTrees.InvokableDeclaration value) {
        int count = 0;
        for (Trees.Parameter parameter : value.parameters()) {
            int paramIndex = count++;
            String typeName = parameter.type().toString();
            this.context.out("final ", typeName, " ", parameter.name().value()).out((Object)" = ");
            if (typeName.equals(String.class.getName())) {
                this.context.out("__.param(", paramIndex, ").toString();").ln();
                continue;
            }
            if (typeName.equals(Boolean.class.getName())) {
                this.context.out("$if(__.param(", paramIndex, "));").ln();
                continue;
            }
            if (typeName.equals(Object.class.getName())) {
                this.context.out("__.param(", paramIndex, ");").ln();
                continue;
            }
            this.context.out("$cast(__.param(", paramIndex, "));").ln();
        }
        return super.toInvokableDeclaration(value);
    }

    static class Context {
        final List<String> templateIndex = Lists.newArrayListWithExpectedSize((int)100);
        final StringBuilder builder = new StringBuilder();
        private int indentLevel;
        private int bracesToClose;
        private int forLevels;

        Context() {
        }

        Context infor() {
            ++this.forLevels;
            return this;
        }

        Context delimit() {
            if (this.indentLevel > 0) {
                this.out((Object)"__.dl();");
            }
            return this;
        }

        Context outfor() {
            --this.forLevels;
            return this;
        }

        Context indent() {
            ++this.indentLevel;
            return this;
        }

        Context outdent() {
            --this.indentLevel;
            return this;
        }

        Context out(Object ... objects) {
            for (Object object : objects) {
                this.out(object);
            }
            return this;
        }

        int indexTemplate(String template) {
            int index = this.templateIndex.size();
            this.templateIndex.add(template);
            return index;
        }

        public String accessMapper(String identifer) {
            if ("for".equals(identifer)) {
                return "_it" + this.forLevels;
            }
            return identifer;
        }

        int getAndSetPendingBraces(int bracesToClose) {
            int value = this.bracesToClose;
            this.bracesToClose = bracesToClose;
            return value;
        }

        Context closeBraces() {
            for (int i = 0; i < this.bracesToClose; ++i) {
                this.builder.append('}');
            }
            this.bracesToClose = 0;
            return this;
        }

        Context openBrace() {
            this.builder.append('{');
            ++this.bracesToClose;
            return this;
        }

        Context closeBrace() {
            this.builder.append('}');
            --this.bracesToClose;
            return this;
        }

        Context out(Object object) {
            if (object instanceof Optional) {
                object = ((Optional)object).orNull();
            }
            if (object instanceof Class) {
                object = ((Class)object).getCanonicalName();
            }
            if (object instanceof CharSequence) {
                this.builder.append((CharSequence)object);
                return this;
            }
            this.builder.append(String.valueOf(object));
            return this;
        }

        Context ln() {
            this.builder.append('\n');
            for (int i = 0; i < this.indentLevel; ++i) {
                this.builder.append("  ");
            }
            return this;
        }
    }

    abstract class TemplateLike {
        boolean variable;
        Trees.InvokableDeclaration declaration;

        TemplateLike() {
        }

        final void generate(Context context) {
            if (this.variable) {
                context.out((Object)"final ").out((Object)Templates.Invokable.class).out((Object)" ").out((Object)this.declaration.name().value()).out((Object)" = ");
            }
            context.out((Object)"new ").out((Object)Templates.Fragment.class).out("(", this.declaration.parameters().size(), ") ").openBrace().ln().out((Object)"@Override public void run(").out((Object)Templates.Invokation.class).out((Object)" __) ").openBrace().indent().ln();
            int braces = context.getAndSetPendingBraces(0);
            context.delimit();
            this.body();
            context.delimit();
            context.getAndSetPendingBraces(braces);
            context.outdent().ln().closeBraces();
        }

        abstract void body();
    }

    abstract class DispatchedTemplateLike {
        boolean variable;
        Trees.InvokableDeclaration declaration;

        DispatchedTemplateLike() {
        }

        final void generate(Context context) {
            if (this.variable) {
                context.out((Object)"final ").out((Object)Templates.Invokable.class).out((Object)" ").out((Object)this.declaration.name().value()).out((Object)" = ");
            }
            String templateName = this.declaration.name().value();
            int templateIndex = context.indexTemplate(templateName);
            context.out("new FragmentDispatch(", this.declaration.parameters().size(), ", ", templateIndex, ");").ln();
            context.out("void _t", templateIndex, "__", templateName, "(").out((Object)Templates.Invokation.class).out((Object)" __) ").openBrace().indent().ln();
            int braces = context.getAndSetPendingBraces(0);
            context.delimit();
            this.body();
            context.delimit();
            context.getAndSetPendingBraces(braces);
            context.outdent().ln().closeBraces();
        }

        abstract void body();
    }
}

