/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.immutables.generator.processor.ImmutableTrees;
import org.immutables.generator.processor.Trees;
import org.immutables.generator.processor.TreesTransformer;

final class Spacing
extends TreesTransformer {
    private Spacing() {
    }

    static ImmutableTrees.Unit normalize(ImmutableTrees.Unit unit) {
        return new Spacing().toUnit(unit);
    }

    @Override
    public ImmutableTrees.Template toTemplate(final ImmutableTrees.Template template) {
        final ArrayList results = Lists.newArrayList();
        class Normalizer {
            @Nullable
            private ImmutableTrees.TextFragment fragment;

            Normalizer() {
            }

            void collect() {
                for (Trees.TemplatePart part : template.parts()) {
                    if (part instanceof ImmutableTrees.TextBlock) {
                        this.collectTextParts((Iterable<Trees.TextPart>)((ImmutableTrees.TextBlock)part).parts());
                        continue;
                    }
                    this.flushFragment();
                    results.add(part);
                }
                this.flushFragment();
            }

            void collectTextParts(Iterable<Trees.TextPart> parts) {
                for (Trees.TextPart text : parts) {
                    if (text instanceof ImmutableTrees.TextFragment) {
                        if (this.fragment != null) {
                            this.fragment = this.joinFraments(this.fragment, (ImmutableTrees.TextFragment)text);
                        } else {
                            this.flushFragment();
                            this.fragment = (ImmutableTrees.TextFragment)text;
                        }
                    }
                    if (!(text instanceof ImmutableTrees.Newline)) continue;
                    this.flushNewline();
                }
            }

            void flushFragment() {
                if (this.fragment != null && !this.fragment.value().isEmpty()) {
                    results.add(ImmutableTrees.TextLine.builder().fragment(this.fragment).build());
                }
                this.fragment = null;
            }

            void flushNewline() {
                results.add(ImmutableTrees.TextLine.builder().fragment(this.fragment != null ? this.fragment : ImmutableTrees.TextFragment.of("")).newline(true).build());
                this.fragment = null;
            }

            ImmutableTrees.TextFragment joinFraments(ImmutableTrees.TextFragment left, ImmutableTrees.TextFragment right) {
                return ImmutableTrees.TextFragment.of(left.value().concat(right.value()));
            }
        }
        new Normalizer().collect();
        return template.withParts(results);
    }
}

