/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import org.immutables.generator.processor.Trees;
import org.immutables.generator.processor.TreesAst;
import org.immutables.trees.ast.Extractions;
import org.parboiled.BaseParser;
import org.parboiled.Rule;
import org.parboiled.annotations.DontLabel;
import org.parboiled.annotations.ExplicitActionsOnly;
import org.parboiled.annotations.MemoMismatches;
import org.parboiled.annotations.SuppressNode;
import org.parboiled.annotations.SuppressSubnodes;

@ExplicitActionsOnly
public class Parser
extends BaseParser<Object> {
    Rule COMMENT = this.Literal("--");
    Rule ASSIGN = this.Literal("=");
    Rule DOT = this.Literal(".");
    Rule COMMA = this.Literal(",");
    Rule ELLIPSIS = this.Literal("...");
    Rule IN = this.Literal("in");
    Rule FOR = this.Literal("for");
    Rule LET = this.Literal("let");
    Rule IF = this.Literal("if");
    Rule ELSE = this.Literal("else");
    Rule TEMPLATE = this.Literal("template");
    Rule PUBLIC = this.Literal("public");
    private static final String KEYWORD_IN = "in";
    private static final String KEYWORD_FOR = "for";
    private static final String KEYWORD_LET = "let";
    private static final String KEYWORD_IF = "if";
    private static final String KEYWORD_ELSE = "else";
    private static final String KEYWORD_TEMPLATE = "template";
    private static final String KEYWORD_PUBLIC = "public";

    public Rule Unit() {
        return this.Sequence(TreesAst.Unit.builder(), this.Spacing(), new Object[]{this.OneOrMore(this.Sequence(this.FirstOf(this.OpeningDirective(this.Comment()), this.TemplateDirective(), new Object[0]), TreesAst.Unit.addParts(), new Object[]{this.Spacing()})), EOI, TreesAst.Unit.build()});
    }

    Rule Comment() {
        return this.Sequence(this.COMMENT, this.Optional(this.TextBlock(), Extractions.popped(), new Object[0]), new Object[]{TreesAst.Comment.of()});
    }

    Rule TextBlock() {
        return this.Sequence(TreesAst.TextBlock.builder(), this.TextFragment(), new Object[]{TreesAst.TextBlock.addParts(TreesAst.TextFragment.of()), this.ZeroOrMore(this.Sequence(this.Newline(), TreesAst.TextBlock.addParts(TreesAst.Newline.of()), new Object[]{this.TextFragment(), TreesAst.TextBlock.addParts(TreesAst.TextFragment.of())})), TreesAst.TextBlock.build()});
    }

    Rule TemplateDirective() {
        return this.Sequence(TreesAst.Template.builder(), this.TemplateStart(), new Object[]{this.TemplateBody(), this.TemplateEnd(), TreesAst.Template.build()});
    }

    Rule TemplateStart() {
        return this.OpeningDirective(this.Template());
    }

    Rule TemplateEnd() {
        return this.ClosingDirective(this.TEMPLATE);
    }

    Rule TemplateBody() {
        return this.Sequence(this.TextBlock(), TreesAst.Template.addParts(), new Object[]{this.ZeroOrMore(this.Sequence(this.Directive(), TreesAst.Template.addParts(), new Object[]{this.TextBlock(), TreesAst.Template.addParts()}))});
    }

    Rule DirectiveStart() {
        return this.OpeningDirective(this.FirstOf(this.Comment(), this.Let(), new Object[]{this.If(), this.ElseIf(), this.Else(), this.For(), this.InvokeString(), this.InvokeStart()}));
    }

    Rule InvokeString() {
        return this.Sequence(this.StringLiteral(), TreesAst.InvokeString.of(), new Object[0]);
    }

    Rule InvokeEnd() {
        return this.Sequence(this.AccessExpression(), TreesAst.InvokeEnd.of(), new Object[0]);
    }

    Rule InvokeStart() {
        return this.Sequence(TreesAst.Invoke.builder(), this.AccessExpression(), new Object[]{TreesAst.Invoke.access(), this.Optional(this.Expression(), TreesAst.Invoke.invoke(), new Object[0]), TreesAst.Invoke.build()});
    }

    Rule DirectiveEnd() {
        return this.ClosingDirective(this.FirstOf(this.IfEnd(), this.LetEnd(), new Object[]{this.ForEnd(), this.InvokeEnd()}));
    }

    Rule IfEnd() {
        return this.Sequence(this.IF, TreesAst.IfEnd.of(), new Object[0]);
    }

    Rule LetEnd() {
        return this.Sequence(this.LET, TreesAst.LetEnd.of(), new Object[0]);
    }

    Rule ForEnd() {
        return this.Sequence(this.FOR, TreesAst.ForEnd.of(), new Object[0]);
    }

    Rule Directive() {
        return this.FirstOf(this.DirectiveEnd(), this.DirectiveStart(), new Object[0]);
    }

    Rule OpeningDirective(Rule directive) {
        return this.Sequence("[", directive, new Object[]{"]"});
    }

    Rule ClosingDirective(Rule directive) {
        return this.Sequence("[/", directive, new Object[]{"]"});
    }

    Rule Parens(Rule expression) {
        return this.Sequence(this.Literal("("), expression, new Object[]{this.Literal(")")});
    }

    Rule AccessExpression() {
        return this.Sequence(TreesAst.SimpleAccessExpression.builder(), this.Identifier(), new Object[]{TreesAst.SimpleAccessExpression.addPath(), this.ZeroOrMore(this.Sequence(this.DOT, this.Identifier(), new Object[]{TreesAst.SimpleAccessExpression.addPath()})), TreesAst.SimpleAccessExpression.build()});
    }

    Rule GeneratorDeclaration() {
        return this.FirstOf(this.TransformGenerator(), this.AssignGenerator(), new Object[]{this.IterationGenerator()});
    }

    Rule IterationGenerator() {
        return this.Sequence(TreesAst.IterationGenerator.builder(), this.ValueDeclaration(), new Object[]{TreesAst.IterationGenerator.declaration(), this.IN, this.Expression(), TreesAst.IterationGenerator.from(), this.Optional(this.IF, this.Expression(), new Object[]{TreesAst.IterationGenerator.condition()}), TreesAst.IterationGenerator.build()});
    }

    Rule AssignGenerator() {
        return this.Sequence(TreesAst.AssignGenerator.builder(), this.ValueDeclaration(), new Object[]{TreesAst.AssignGenerator.declaration(), this.ASSIGN, this.Expression(), TreesAst.AssignGenerator.from(), TreesAst.AssignGenerator.build()});
    }

    Rule TransformGenerator() {
        return this.Sequence(TreesAst.TransformGenerator.builder(), this.ValueDeclaration(), new Object[]{TreesAst.TransformGenerator.declaration(), this.ASSIGN, this.Expression(), TreesAst.TransformGenerator.transform(), this.FOR, this.ValueDeclaration(), TreesAst.TransformGenerator.varDeclaration(), this.IN, this.Expression(), TreesAst.TransformGenerator.from(), this.Optional(this.IF, this.Expression(), new Object[]{TreesAst.TransformGenerator.condition()}), TreesAst.TransformGenerator.build()});
    }

    @DontLabel
    Rule DisambiguatedExpression() {
        return this.FirstOf(this.Parens(this.ApplyExpression()), this.ForIterationAccessExpression(), new Object[]{this.AccessExpression(), this.StringLiteral()});
    }

    Rule ForIterationAccessExpression() {
        return this.Sequence(this.FOR, this.DOT, new Object[]{this.AccessExpression(), TreesAst.ForIterationAccessExpression.of()});
    }

    Rule Expression() {
        return this.FirstOf(this.Parens(this.ApplyExpression()), this.ApplyExpression(), new Object[0]);
    }

    Rule ApplyExpression() {
        return this.Sequence(TreesAst.ApplyExpression.builder(), this.OneOrMore(this.DisambiguatedExpression(), TreesAst.ApplyExpression.addParams(), new Object[0]), new Object[]{TreesAst.ApplyExpression.build()});
    }

    Rule If() {
        return this.Sequence(this.IF, TreesAst.If.builder(), new Object[]{this.Expression(), TreesAst.If.condition(), TreesAst.If.build()});
    }

    Rule ElseIf() {
        return this.Sequence(this.ELSE, this.IF, new Object[]{TreesAst.ElseIf.builder(), this.Expression(), TreesAst.ElseIf.condition(), TreesAst.ElseIf.build()});
    }

    Rule Else() {
        return this.Sequence(this.ELSE, TreesAst.Else.of(), new Object[0]);
    }

    Rule For() {
        return this.FirstOf(this.Sequence(this.FOR, this.DOT, new Object[]{TreesAst.Invoke.builder(), this.AccessExpression(), TreesAst.ForIterationAccessExpression.of(), TreesAst.Invoke.access(), TreesAst.Invoke.build()}), this.Sequence(this.FOR, TreesAst.For.builder(), new Object[]{this.ForDeclaration(), TreesAst.For.build()}), new Object[0]);
    }

    Rule ForDeclaration() {
        return this.Sequence(this.GeneratorDeclaration(), TreesAst.For.addDeclaration(), new Object[]{this.ZeroOrMore(this.Sequence(this.COMMA, this.GeneratorDeclaration(), new Object[]{TreesAst.For.addDeclaration()}))});
    }

    Rule Let() {
        return this.Sequence(this.LET, TreesAst.Let.builder(), new Object[]{this.InvokableDeclaration(), TreesAst.Let.declaration(), TreesAst.Let.build()});
    }

    Rule ValueDeclaration() {
        return this.Sequence(TreesAst.ValueDeclaration.builder(), this.Optional(this.Type(), TreesAst.ValueDeclaration.type(), new Object[0]), new Object[]{this.Name(), TreesAst.ValueDeclaration.name(), TreesAst.ValueDeclaration.build()});
    }

    Rule InvokableDeclaration() {
        return this.Sequence(TreesAst.InvokableDeclaration.builder(), this.Name(), new Object[]{TreesAst.InvokableDeclaration.name(), this.ZeroOrMore(this.ParameterDeclaration()), TreesAst.InvokableDeclaration.build()});
    }

    Rule ParameterDeclaration() {
        return this.Sequence(TreesAst.Parameter.builder(), this.Type(), new Object[]{TreesAst.Parameter.type(), this.Name(), TreesAst.Parameter.name(), TreesAst.Parameter.build(), TreesAst.InvokableDeclaration.addParameters()});
    }

    Rule Template() {
        return this.Sequence(this.TEMPLATE, this.Optional(this.PUBLIC, TreesAst.Template.isPublic(true), new Object[0]), new Object[]{this.InvokableDeclaration(), TreesAst.Template.declaration()});
    }

    Rule Name() {
        return this.Identifier();
    }

    Rule Type() {
        return this.Sequence(TreesAst.TypeDeclaration.builder(), this.TypeIdentifer(), new Object[]{TreesAst.TypeDeclaration.type(), this.Optional(this.Ellipsis(), TreesAst.TypeDeclaration.kind(Trees.TypeDeclaration.Kind.ITERABLE), new Object[0]), TreesAst.TypeDeclaration.build()});
    }

    @MemoMismatches
    @SuppressNode
    Rule Keyword() {
        return this.Sequence(this.FirstOf(KEYWORD_IN, KEYWORD_FOR, new Object[]{KEYWORD_LET, KEYWORD_IF, KEYWORD_ELSE, KEYWORD_TEMPLATE, KEYWORD_PUBLIC}), this.TestNot(this.LetterOrDigit()), new Object[0]);
    }

    @DontLabel
    @SuppressSubnodes
    Rule Literal(String string) {
        return this.Sequence(this.String(string), this.Spacing(), new Object[0]);
    }

    @SuppressSubnodes
    @MemoMismatches
    Rule Identifier() {
        return this.Sequence(this.TestNot(this.Keyword()), this.Sequence(this.Sequence(this.IdentifierStartLetter(), this.ZeroOrMore(this.LetterOrDigit()), new Object[0]), TreesAst.Identifier.of(), new Object[0]), new Object[]{this.Spacing()});
    }

    @SuppressSubnodes
    @MemoMismatches
    Rule StringLiteral() {
        return this.Sequence("'", this.ZeroOrMore(this.NoneOf("'")), new Object[]{TreesAst.StringLiteral.of(), "'", this.Spacing()});
    }

    @SuppressSubnodes
    @MemoMismatches
    Rule TypeIdentifer() {
        return this.Sequence(this.TestNot(this.Keyword()), this.Sequence(this.Sequence(this.TypeStartLetter(), this.ZeroOrMore(this.LetterOrDigit()), new Object[0]), TreesAst.TypeIdentifier.of(), new Object[0]), new Object[]{this.Spacing()});
    }

    @SuppressSubnodes
    Rule Newline() {
        return this.FirstOf("\n", "\n\r", new Object[0]);
    }

    @SuppressSubnodes
    Rule TextFragment() {
        return this.ZeroOrMore(this.NoneOf("[]\n\r"));
    }

    @SuppressSubnodes
    Rule Ellipsis() {
        return this.Sequence(this.ELLIPSIS, this.Spacing(), new Object[0]);
    }

    Rule IdentifierStartLetter() {
        return this.FirstOf(this.CharRange('a', 'z'), Character.valueOf('_'), new Object[0]);
    }

    Rule TypeStartLetter() {
        return this.CharRange('A', 'Z');
    }

    @MemoMismatches
    Rule Letter() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{Character.valueOf('_'), Character.valueOf('$')});
    }

    @MemoMismatches
    Rule LetterOrDigit() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{this.CharRange('0', '9'), Character.valueOf('_'), Character.valueOf('$')});
    }

    @SuppressNode
    Rule Spacing() {
        return this.ZeroOrMore(this.AnyOf(" \n\r\f\t"));
    }
}

