/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Singleton;
import javax.inject.Inject;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.bpmn.BPMNModel;
import org.imixs.workflow.bpmn.BPMNParser;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Singleton
@LocalBean
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class ModelService
implements ModelManager {
    private ConcurrentHashMap<String, Model> modelStore = null;
    private static Logger logger = Logger.getLogger(ModelService.class.getName());
    @Inject
    private DocumentService documentService;
    @Resource
    private SessionContext ctx;

    void init() throws AccessDeniedException {
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            logger.finest("......Initalizing ModelService...");
        }
        List<ItemCollection> col = this.documentService.getDocumentsByType("model");
        for (ItemCollection modelEntity : col) {
            List files = modelEntity.getFileData();
            for (FileData file : files) {
                if (debug) {
                    logger.finest("......loading file:" + file.getName());
                }
                byte[] rawData = file.getContent();
                ByteArrayInputStream bpmnInputStream = new ByteArrayInputStream(rawData);
                try {
                    BPMNModel model = BPMNParser.parseModel((InputStream)bpmnInputStream, (String)"UTF-8");
                    ItemCollection definition = model.getDefinition();
                    if (definition == null) continue;
                    String modelVersion = definition.getModelVersion();
                    try {
                        if (this.getModel(modelVersion) == null) continue;
                        logger.warning("Model '" + modelVersion + "' is dupplicated! Please update the model version!");
                    }
                    catch (ModelException e) {
                        this.addModel((Model)model);
                    }
                }
                catch (Exception e) {
                    logger.warning("Failed to load model '" + file.getName() + "' : " + e.getMessage());
                }
            }
        }
    }

    public void addModel(Model model) throws ModelException {
        ItemCollection definition = model.getDefinition();
        if (definition == null) {
            throw new ModelException("INVALID_MODEL", "Invalid Model: Model Definition not provided! ");
        }
        String modelVersion = definition.getModelVersion();
        if (modelVersion.isEmpty()) {
            throw new ModelException("INVALID_MODEL", "Invalid Model: Model Version not provided! ");
        }
        logger.info("\u27f3 updated model version: '" + model.getVersion() + "'");
        this.getModelStore().put(modelVersion, model);
    }

    public void removeModel(String modelversion) {
        boolean debug = logger.isLoggable(Level.FINE);
        this.getModelStore().remove(modelversion);
        if (debug) {
            logger.finest("......removed BPMNModel '" + modelversion + "'...");
        }
    }

    public Model getModel(String version) throws ModelException {
        Model model = this.getModelStore().get(version);
        if (model == null) {
            throw new ModelException("UNDEFINED_MODEL_VERSION", "Modelversion '" + version + "' not found!");
        }
        return model;
    }

    public Model getModelByWorkitem(ItemCollection workitem) throws ModelException {
        Model model;
        String workflowGroup;
        String modelVersion;
        block7: {
            boolean debug = logger.isLoggable(Level.FINE);
            modelVersion = workitem.getModelVersion();
            workflowGroup = workitem.getItemValueString("$workflowgroup");
            if (workflowGroup.isEmpty()) {
                workflowGroup = workitem.getItemValueString("txtworkflowgroup");
            }
            model = null;
            try {
                model = this.getModel(modelVersion);
            }
            catch (ModelException me) {
                String newVersion;
                model = null;
                List<String> versions = null;
                if (debug) {
                    logger.finest(me.getMessage());
                }
                if (modelVersion != null && !modelVersion.isEmpty() && !(versions = this.findVersionsByRegEx(modelVersion)).isEmpty()) {
                    newVersion = versions.get(0);
                    logger.info("...... match version '" + newVersion + "' -> by regex '" + modelVersion + "'");
                    workitem.replaceItemValue("$modelversion", (Object)newVersion);
                    model = this.getModel(newVersion);
                }
                if (model != null || workflowGroup.isEmpty() || (versions = this.findVersionsByGroup(workflowGroup)).isEmpty()) break block7;
                newVersion = versions.get(0);
                if (!modelVersion.isEmpty()) {
                    logger.warning("Deprecated model version: '" + modelVersion + "' -> migrating to '" + newVersion + "',  $workflowgroup: '" + workflowGroup + "', $uniqueid: " + workitem.getUniqueID());
                }
                workitem.replaceItemValue("$modelversion", (Object)newVersion);
                model = this.getModel(newVersion);
            }
        }
        if (model == null) {
            throw new ModelException("UNDEFINED_MODEL_VERSION", "No matching $modelversion found for '" + modelVersion + "', $workflowgroup: '" + workflowGroup + "', $uniqueid: " + workitem.getUniqueID());
        }
        return model;
    }

    public List<String> getVersions() {
        Set<String> set = this.getModelStore().keySet();
        ArrayList<String> result = new ArrayList<String>(set);
        return result;
    }

    public List<String> getLatestVersions() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> groups = this.getGroups();
        for (String group : groups) {
            String version;
            List<String> versions = this.findVersionsByGroup(group);
            if (versions == null || versions.size() <= 0 || result.contains(version = versions.get(0))) continue;
            result.add(version);
        }
        Collections.sort(result);
        return result;
    }

    public List<String> getGroups() {
        ArrayList<String> result = new ArrayList<String>();
        Collection<Model> models = this.getModelStore().values();
        for (Model amodel : models) {
            for (String group : amodel.getGroups()) {
                if (result.contains(group)) continue;
                result.add(group);
            }
        }
        Collections.sort(result);
        return result;
    }

    public List<String> findVersionsByGroup(String group) {
        boolean debug = logger.isLoggable(Level.FINE);
        ArrayList<String> result = new ArrayList<String>();
        if (debug) {
            logger.finest("......searching model versions for workflowgroup '" + group + "'...");
        }
        Collection<Model> models = this.getModelStore().values();
        for (Model amodel : models) {
            if (!amodel.getGroups().contains(group)) continue;
            result.add(amodel.getVersion());
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    public List<String> findVersionsByRegEx(String modelRegex) {
        boolean debug = logger.isLoggable(Level.FINE);
        ArrayList<String> result = new ArrayList<String>();
        if (debug) {
            logger.finest("......searching model versions for regex '" + modelRegex + "'...");
        }
        Collection<Model> models = this.getModelStore().values();
        for (Model amodel : models) {
            if (!Pattern.compile(modelRegex).matcher(amodel.getVersion()).find()) continue;
            result.add(amodel.getVersion());
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    public void saveModel(BPMNModel model) throws ModelException {
        this.saveModel(model, null);
    }

    public void saveModel(BPMNModel model, String _filename) throws ModelException {
        if (model != null) {
            boolean debug = logger.isLoggable(Level.FINE);
            this.deleteModel(model.getVersion());
            if (debug) {
                logger.finest("......save BPMNModel '" + model.getVersion() + "'...");
            }
            BPMNModel bpmnModel = model;
            this.addModel((Model)model);
            ItemCollection modelItemCol = new ItemCollection();
            modelItemCol.replaceItemValue("type", (Object)"model");
            modelItemCol.replaceItemValue("$snapshot.history", (Object)1);
            modelItemCol.replaceItemValue("$reator", (Object)this.ctx.getCallerPrincipal().getName());
            modelItemCol.replaceItemValue("name", (Object)bpmnModel.getVersion());
            modelItemCol.replaceItemValue("namcreator", (Object)this.ctx.getCallerPrincipal().getName());
            modelItemCol.replaceItemValue("txtname", (Object)bpmnModel.getVersion());
            Object filename = _filename;
            if (filename == null || ((String)filename).isEmpty()) {
                filename = bpmnModel.getVersion() + ".bpmn";
            }
            FileData fileData = new FileData((String)filename, bpmnModel.getRawData(), "application/xml", null);
            modelItemCol.addFileData(fileData);
            modelItemCol.replaceItemValue("$noindex", (Object)true);
            this.documentService.save(modelItemCol);
        }
    }

    public void deleteModel(String version) {
        if (version != null && !version.isEmpty()) {
            boolean debug = logger.isLoggable(Level.FINE);
            if (debug) {
                logger.finest("......delete BPMNModel '" + version + "'...");
            }
            List<ItemCollection> col = this.documentService.getDocumentsByType("model");
            for (ItemCollection modelEntity : col) {
                String oldVersion = modelEntity.getItemValueString("txtname");
                if (!version.equals(oldVersion)) continue;
                this.documentService.remove(modelEntity);
            }
        } else {
            logger.severe("deleteModel - invalid model version!");
            throw new InvalidAccessException("INVALID_ID", "deleteModel - invalid model version!");
        }
        this.removeModel(version);
    }

    public ItemCollection loadModelEntity(String version) {
        if (version != null && !version.isEmpty()) {
            boolean debug = logger.isLoggable(Level.FINE);
            if (debug) {
                logger.finest("......load BPMNModel Entity '" + version + "'...");
            }
            List<ItemCollection> col = this.documentService.getDocumentsByType("model");
            for (ItemCollection modelEntity : col) {
                String currentVersion = modelEntity.getItemValueString("txtname");
                if (!version.equals(currentVersion)) continue;
                return modelEntity;
            }
        } else {
            logger.severe("deleteModel - invalid model version!");
            throw new InvalidAccessException("INVALID_ID", "loadModelEntity - invalid model version!");
        }
        return null;
    }

    public String getDataObject(ItemCollection bpmnElement, String name) {
        List dataObjects = bpmnElement.getItemValue("dataObjects");
        if (dataObjects != null && dataObjects.size() > 0) {
            for (List dataObject : dataObjects) {
                String key = (String)dataObject.get(0);
                if (!name.equals(key)) continue;
                return (String)dataObject.get(1);
            }
        }
        return null;
    }

    private Map<String, Model> getModelStore() {
        if (this.modelStore == null) {
            this.modelStore = new ConcurrentHashMap();
            this.init();
        }
        return this.modelStore;
    }
}

