/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.packet.VCard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VCardProvider
implements IQProvider {
    private static final String PREFERRED_ENCODING = "UTF-8";

    public IQ parseIQ(XmlPullParser parser) throws Exception {
        StringBuilder sb = new StringBuilder();
        try {
            int event = parser.getEventType();
            while (true) {
                switch (event) {
                    case 4: {
                        sb.append(StringUtils.escapeForXML((String)parser.getText()));
                        break;
                    }
                    case 2: {
                        sb.append('<').append(parser.getName()).append('>');
                        break;
                    }
                    case 3: {
                        sb.append("</").append(parser.getName()).append('>');
                        break;
                    }
                }
                if (event != 3 || !"vCard".equals(parser.getName())) {
                    event = parser.next();
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String xmlText = sb.toString();
        return VCardProvider.createVCardFromXML(xmlText);
    }

    public static VCard createVCardFromXML(String xml) throws Exception {
        VCard vCard = new VCard();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(xml.getBytes(PREFERRED_ENCODING)));
        new VCardReader(vCard, document).initializeFields();
        return vCard;
    }

    private static class VCardReader {
        private final VCard vCard;
        private final Document document;

        VCardReader(VCard vCard, Document document) {
            this.vCard = vCard;
            this.document = document;
        }

        public void initializeFields() {
            this.vCard.setFirstName(this.getTagContents("GIVEN"));
            this.vCard.setLastName(this.getTagContents("FAMILY"));
            this.vCard.setMiddleName(this.getTagContents("MIDDLE"));
            this.setupPhoto();
            this.setupEmails();
            this.vCard.setOrganization(this.getTagContents("ORGNAME"));
            this.vCard.setOrganizationUnit(this.getTagContents("ORGUNIT"));
            this.setupSimpleFields();
            this.setupPhones();
            this.setupAddresses();
        }

        private void setupPhoto() {
            String binval = null;
            String mimetype = null;
            NodeList photo = this.document.getElementsByTagName("PHOTO");
            if (photo.getLength() != 1) {
                return;
            }
            Node photoNode = photo.item(0);
            NodeList childNodes = photoNode.getChildNodes();
            int childNodeCount = childNodes.getLength();
            ArrayList<Node> nodes = new ArrayList<Node>(childNodeCount);
            for (int i = 0; i < childNodeCount; ++i) {
                nodes.add(childNodes.item(i));
            }
            String name = null;
            String value = null;
            for (Node n : nodes) {
                name = n.getNodeName();
                value = n.getTextContent();
                if (name.equals("BINVAL")) {
                    binval = value;
                    continue;
                }
                if (!name.equals("TYPE")) continue;
                mimetype = value;
            }
            if (binval == null || mimetype == null) {
                return;
            }
            this.vCard.setAvatar(binval, mimetype);
        }

        private void setupEmails() {
            NodeList nodes = this.document.getElementsByTagName("USERID");
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                if ("WORK".equals(element.getParentNode().getFirstChild().getNodeName())) {
                    this.vCard.setEmailWork(this.getTextContent(element));
                    continue;
                }
                this.vCard.setEmailHome(this.getTextContent(element));
            }
        }

        private void setupPhones() {
            NodeList allPhones = this.document.getElementsByTagName("TEL");
            if (allPhones == null) {
                return;
            }
            for (int i = 0; i < allPhones.getLength(); ++i) {
                NodeList nodes = allPhones.item(i).getChildNodes();
                String type = null;
                String code = null;
                String value = null;
                for (int j = 0; j < nodes.getLength(); ++j) {
                    Node node = nodes.item(j);
                    if (node.getNodeType() != 1) continue;
                    String nodeName = node.getNodeName();
                    if ("NUMBER".equals(nodeName)) {
                        value = this.getTextContent(node);
                        continue;
                    }
                    if (this.isWorkHome(nodeName)) {
                        type = nodeName;
                        continue;
                    }
                    code = nodeName;
                }
                if (code == null || value == null) continue;
                if ("HOME".equals(type)) {
                    this.vCard.setPhoneHome(code, value);
                    continue;
                }
                this.vCard.setPhoneWork(code, value);
            }
        }

        private boolean isWorkHome(String nodeName) {
            return "HOME".equals(nodeName) || "WORK".equals(nodeName);
        }

        private void setupAddresses() {
            NodeList allAddresses = this.document.getElementsByTagName("ADR");
            if (allAddresses == null) {
                return;
            }
            for (int i = 0; i < allAddresses.getLength(); ++i) {
                int j;
                Element addressNode = (Element)allAddresses.item(i);
                String type = null;
                ArrayList<String> code = new ArrayList<String>();
                ArrayList<String> value = new ArrayList<String>();
                NodeList childNodes = addressNode.getChildNodes();
                for (j = 0; j < childNodes.getLength(); ++j) {
                    Node node = childNodes.item(j);
                    if (node.getNodeType() != 1) continue;
                    String nodeName = node.getNodeName();
                    if (this.isWorkHome(nodeName)) {
                        type = nodeName;
                        continue;
                    }
                    code.add(nodeName);
                    value.add(this.getTextContent(node));
                }
                for (j = 0; j < value.size(); ++j) {
                    if ("HOME".equals(type)) {
                        this.vCard.setAddressFieldHome((String)code.get(j), (String)value.get(j));
                        continue;
                    }
                    this.vCard.setAddressFieldWork((String)code.get(j), (String)value.get(j));
                }
            }
        }

        private String getTagContents(String tag) {
            NodeList nodes = this.document.getElementsByTagName(tag);
            if (nodes != null && nodes.getLength() == 1) {
                return this.getTextContent(nodes.item(0));
            }
            return null;
        }

        private void setupSimpleFields() {
            NodeList childNodes = this.document.getDocumentElement().getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                String field = element.getNodeName();
                if (element.getChildNodes().getLength() == 0) {
                    this.vCard.setField(field, "");
                    continue;
                }
                if (element.getChildNodes().getLength() != 1 || !(element.getChildNodes().item(0) instanceof Text)) continue;
                this.vCard.setField(field, this.getTextContent(element));
            }
        }

        private String getTextContent(Node node) {
            StringBuilder result = new StringBuilder();
            this.appendText(result, node);
            return result.toString();
        }

        private void appendText(StringBuilder result, Node node) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node nd = childNodes.item(i);
                String nodeValue = nd.getNodeValue();
                if (nodeValue != null) {
                    result.append(nodeValue);
                }
                this.appendText(result, nd);
            }
        }
    }
}

