/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackError;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.ping.packet.Ping;
import org.jivesoftware.smack.util.SyncPacketSend;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class PingManager {
    private static Map<Connection, PingManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private Connection connection;

    public static synchronized PingManager getInstanceFor(Connection connection) {
        PingManager pingManager = instances.get(connection);
        if (pingManager == null) {
            pingManager = new PingManager(connection);
        }
        return pingManager;
    }

    private PingManager(Connection con) {
        this.connection = con;
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(this.connection);
        if (sdm == null) {
            sdm = new ServiceDiscoveryManager(this.connection);
        }
        sdm.addFeature("urn:xmpp:ping");
        AndFilter pingPacketFilter = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Ping.class), new IQTypeFilter(IQ.Type.GET)});
        this.connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                IQ pong = IQ.createResultIQ((IQ)((Ping)packet));
                PingManager.this.connection.sendPacket((Packet)pong);
            }
        }, (PacketFilter)pingPacketFilter);
    }

    public boolean ping(String jid, long pingTimeout) {
        Ping ping = new Ping(jid);
        try {
            SyncPacketSend.getReply((Connection)this.connection, (Packet)ping);
        }
        catch (XMPPException exc) {
            return jid.equals(this.connection.getServiceName()) && exc.getSmackError() != SmackError.NO_RESPONSE_FROM_SERVER;
        }
        return true;
    }

    public boolean ping(String jid) {
        return this.ping(jid, SmackConfiguration.getPacketReplyTimeout());
    }

    public boolean isPingSupported(String jid) throws XMPPException {
        DiscoverInfo result = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(jid);
        return result.containsFeature("urn:xmpp:ping");
    }

    public boolean pingMyServer() {
        return this.ping(this.connection.getServiceName());
    }

    static {
        Connection.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(Connection connection) {
                new PingManager(connection);
            }
        });
    }
}

