/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.NodeInformationProvider;
import org.jivesoftware.smackx.entitycaps.EntityCapsManager;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

public class ServiceDiscoveryManager {
    private static final String DEFAULT_IDENTITY_NAME = "Smack";
    private static final String DEFAULT_IDENTITY_CATEGORY = "client";
    private static final String DEFAULT_IDENTITY_TYPE = "pc";
    private static List<DiscoverInfo.Identity> identities = new LinkedList<DiscoverInfo.Identity>();
    private EntityCapsManager capsManager;
    private static Map<Connection, ServiceDiscoveryManager> instances = new ConcurrentHashMap<Connection, ServiceDiscoveryManager>();
    private Connection connection;
    private final Set<String> features = new HashSet<String>();
    private DataForm extendedInfo = null;
    private Map<String, NodeInformationProvider> nodeInformationProviders = new ConcurrentHashMap<String, NodeInformationProvider>();

    public ServiceDiscoveryManager(Connection connection) {
        this.connection = connection;
        this.init();
    }

    public static ServiceDiscoveryManager getInstanceFor(Connection connection) {
        return instances.get(connection);
    }

    public static String getIdentityName() {
        DiscoverInfo.Identity identity = identities.get(0);
        if (identity != null) {
            return identity.getName();
        }
        return null;
    }

    public static void setIdentityName(String name) {
        DiscoverInfo.Identity identity = identities.remove(0);
        identity = new DiscoverInfo.Identity(DEFAULT_IDENTITY_CATEGORY, name, DEFAULT_IDENTITY_TYPE);
        identities.add(identity);
    }

    public static String getIdentityType() {
        DiscoverInfo.Identity identity = identities.get(0);
        if (identity != null) {
            return identity.getType();
        }
        return null;
    }

    public static void setIdentityType(String type) {
        DiscoverInfo.Identity identity = identities.get(0);
        if (identity != null) {
            identity.setType(type);
        } else {
            identity = new DiscoverInfo.Identity(DEFAULT_IDENTITY_CATEGORY, DEFAULT_IDENTITY_NAME, type);
            identities.add(identity);
        }
    }

    public static List<DiscoverInfo.Identity> getIdentities() {
        return Collections.unmodifiableList(identities);
    }

    private void init() {
        instances.put(this.connection, this);
        this.addFeature("http://jabber.org/protocol/disco#info");
        this.addFeature("http://jabber.org/protocol/disco#items");
        this.connection.addConnectionListener(new ConnectionListener(){

            public void connectionClosed() {
                instances.remove(ServiceDiscoveryManager.this.connection);
            }

            public void connectionClosedOnError(Exception e) {
            }

            public void reconnectionFailed(Exception e) {
            }

            public void reconnectingIn(int seconds) {
            }

            public void reconnectionSuccessful() {
            }
        });
        PacketTypeFilter packetFilter = new PacketTypeFilter(DiscoverItems.class);
        Object packetListener = new PacketListener(){

            public void processPacket(Packet packet) {
                DiscoverItems discoverItems = (DiscoverItems)packet;
                if (discoverItems != null && discoverItems.getType() == IQ.Type.GET) {
                    DiscoverItems response = new DiscoverItems();
                    response.setType(IQ.Type.RESULT);
                    response.setTo(discoverItems.getFrom());
                    response.setPacketID(discoverItems.getPacketID());
                    response.setNode(discoverItems.getNode());
                    NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverItems.getNode());
                    if (nodeInformationProvider != null) {
                        response.addItems(nodeInformationProvider.getNodeItems());
                        response.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                    } else if (discoverItems.getNode() != null) {
                        response.setType(IQ.Type.ERROR);
                        response.setError(new XMPPError(XMPPError.Condition.item_not_found));
                    }
                    ServiceDiscoveryManager.this.connection.sendPacket((Packet)response);
                }
            }
        };
        this.connection.addPacketListener(packetListener, (PacketFilter)packetFilter);
        packetFilter = new PacketTypeFilter(DiscoverInfo.class);
        packetListener = new PacketListener(){

            public void processPacket(Packet packet) {
                DiscoverInfo discoverInfo = (DiscoverInfo)packet;
                if (discoverInfo != null && discoverInfo.getType() == IQ.Type.GET) {
                    DiscoverInfo response = new DiscoverInfo();
                    response.setType(IQ.Type.RESULT);
                    response.setTo(discoverInfo.getFrom());
                    response.setPacketID(discoverInfo.getPacketID());
                    response.setNode(discoverInfo.getNode());
                    if (discoverInfo.getNode() == null) {
                        ServiceDiscoveryManager.this.addDiscoverInfoTo(response);
                    } else {
                        NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverInfo.getNode());
                        if (nodeInformationProvider != null) {
                            response.addFeatures(nodeInformationProvider.getNodeFeatures());
                            response.addIdentities(nodeInformationProvider.getNodeIdentities());
                            response.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                        } else {
                            response.setType(IQ.Type.ERROR);
                            response.setError(new XMPPError(XMPPError.Condition.item_not_found));
                        }
                    }
                    ServiceDiscoveryManager.this.connection.sendPacket((Packet)response);
                }
            }
        };
        this.connection.addPacketListener(packetListener, (PacketFilter)packetFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoverInfoTo(DiscoverInfo response) {
        response.addIdentities(identities);
        Set<String> set = this.features;
        synchronized (set) {
            Iterator<String> it = this.getFeatures();
            while (it.hasNext()) {
                response.addFeature(it.next());
            }
            response.addExtension(this.extendedInfo);
        }
    }

    private NodeInformationProvider getNodeInformationProvider(String node) {
        if (node == null) {
            return null;
        }
        return this.nodeInformationProviders.get(node);
    }

    public void setNodeInformationProvider(String node, NodeInformationProvider listener) {
        this.nodeInformationProviders.put(node, listener);
    }

    public void removeNodeInformationProvider(String node) {
        this.nodeInformationProviders.remove(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getFeatures() {
        Set<String> set = this.features;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<String>(this.features)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFeaturesList() {
        Set<String> set = this.features;
        synchronized (set) {
            return new LinkedList<String>(this.features);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(String feature) {
        Set<String> set = this.features;
        synchronized (set) {
            this.features.add(feature);
            this.renewEntityCapsVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeature(String feature) {
        Set<String> set = this.features;
        synchronized (set) {
            this.features.remove(feature);
            this.renewEntityCapsVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean includesFeature(String feature) {
        Set<String> set = this.features;
        synchronized (set) {
            return this.features.contains(feature);
        }
    }

    public void setExtendedInfo(DataForm info) {
        this.extendedInfo = info;
        this.renewEntityCapsVersion();
    }

    public DataForm getExtendedInfo() {
        return this.extendedInfo;
    }

    public List<PacketExtension> getExtendedInfoAsList() {
        ArrayList<DataForm> res = null;
        if (this.extendedInfo != null) {
            res = new ArrayList<DataForm>(1);
            res.add(this.extendedInfo);
        }
        return res;
    }

    public void removeExtendedInfo() {
        this.extendedInfo = null;
        this.renewEntityCapsVersion();
    }

    public DiscoverInfo discoverInfo(String entityID) throws XMPPException {
        if (entityID == null) {
            return this.discoverInfo(null, null);
        }
        DiscoverInfo info = EntityCapsManager.getDiscoverInfoByUser(entityID);
        if (info != null) {
            return info;
        }
        EntityCapsManager.NodeVerHash nvh = EntityCapsManager.getNodeVerHashByJid(entityID);
        info = this.discoverInfo(entityID, nvh != null ? nvh.getNodeVer() : null);
        if (nvh != null && EntityCapsManager.verifyDiscoverInfoVersion(nvh.getVer(), nvh.getHash(), info)) {
            EntityCapsManager.addDiscoverInfoByNode(nvh.getNodeVer(), info);
        }
        return info;
    }

    public DiscoverInfo discoverInfo(String entityID, String node) throws XMPPException {
        DiscoverInfo disco = new DiscoverInfo();
        disco.setType(IQ.Type.GET);
        disco.setTo(entityID);
        disco.setNode(node);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(disco.getPacketID()));
        this.connection.sendPacket((Packet)disco);
        IQ result = (IQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from the server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
        return (DiscoverInfo)result;
    }

    public DiscoverItems discoverItems(String entityID) throws XMPPException {
        return this.discoverItems(entityID, null);
    }

    public DiscoverItems discoverItems(String entityID, String node) throws XMPPException {
        DiscoverItems disco = new DiscoverItems();
        disco.setType(IQ.Type.GET);
        disco.setTo(entityID);
        disco.setNode(node);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(disco.getPacketID()));
        this.connection.sendPacket((Packet)disco);
        IQ result = (IQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from the server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
        return (DiscoverItems)result;
    }

    public boolean canPublishItems(String entityID) throws XMPPException {
        DiscoverInfo info = this.discoverInfo(entityID);
        return ServiceDiscoveryManager.canPublishItems(info);
    }

    public static boolean canPublishItems(DiscoverInfo info) {
        return info.containsFeature("http://jabber.org/protocol/disco#publish");
    }

    public void publishItems(String entityID, DiscoverItems discoverItems) throws XMPPException {
        this.publishItems(entityID, null, discoverItems);
    }

    public void publishItems(String entityID, String node, DiscoverItems discoverItems) throws XMPPException {
        discoverItems.setType(IQ.Type.SET);
        discoverItems.setTo(entityID);
        discoverItems.setNode(node);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(discoverItems.getPacketID()));
        this.connection.sendPacket((Packet)discoverItems);
        IQ result = (IQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from the server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
    }

    public void setEntityCapsManager(EntityCapsManager manager) {
        this.capsManager = manager;
    }

    private void renewEntityCapsVersion() {
        if (this.capsManager != null && this.capsManager.entityCapsEnabled()) {
            this.capsManager.updateLocalEntityCaps();
        }
    }

    static {
        Connection.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(Connection connection) {
                new ServiceDiscoveryManager(connection);
            }
        });
        identities.add(new DiscoverInfo.Identity(DEFAULT_IDENTITY_CATEGORY, DEFAULT_IDENTITY_NAME, DEFAULT_IDENTITY_TYPE));
    }
}

