/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoView;
import org.jxmpp.util.XmppStringUtils;

public class DiscoverInfo
extends IQ
implements DiscoverInfoView {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "http://jabber.org/protocol/disco#info";
    private final List<Feature> features = new ArrayList<Feature>();
    private final Set<Feature> featuresSet = new HashSet<Feature>();
    private final List<Identity> identities = new ArrayList<Identity>();
    private final Set<String> identitiesSet = new HashSet<String>();
    private String node;
    private boolean containsDuplicateFeatures;

    DiscoverInfo(DiscoverInfoBuilder builder, boolean validate) {
        super((AbstractIqBuilder)builder, ELEMENT, NAMESPACE);
        this.features.addAll(builder.getFeatures());
        this.identities.addAll(builder.getIdentities());
        this.node = builder.getNode();
        for (Feature feature : this.features) {
            boolean featureIsNew = this.featuresSet.add(feature);
            if (featureIsNew) continue;
            this.containsDuplicateFeatures = true;
        }
        for (Identity identity : this.identities) {
            this.identitiesSet.add(identity.getKey());
        }
        if (!validate) {
            return;
        }
        if (this.containsDuplicateFeatures) {
            throw new IllegalArgumentException("The disco#info request contains duplicate features.");
        }
    }

    @Deprecated
    public DiscoverInfo() {
        super(ELEMENT, NAMESPACE);
    }

    public DiscoverInfo(DiscoverInfo d) {
        super((IQ)d);
        this.node = d.getNode();
        this.features.addAll(d.features);
        this.featuresSet.addAll(d.featuresSet);
        this.identities.addAll(d.identities);
        this.identitiesSet.addAll(d.identitiesSet);
    }

    @Deprecated
    public boolean addFeature(String feature) {
        return this.addFeature(new Feature(feature));
    }

    @Deprecated
    public void addFeatures(Collection<String> featuresToAdd) {
        if (featuresToAdd == null) {
            return;
        }
        for (String feature : featuresToAdd) {
            this.addFeature(feature);
        }
    }

    @Deprecated
    public boolean addFeature(Feature feature) {
        this.features.add(feature);
        boolean featureIsNew = this.featuresSet.add(feature);
        if (!featureIsNew) {
            this.containsDuplicateFeatures = true;
        }
        return featureIsNew;
    }

    @Override
    public List<Feature> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    @Deprecated
    public void addIdentity(Identity identity) {
        this.identities.add(identity);
        this.identitiesSet.add(identity.getKey());
    }

    @Deprecated
    public void addIdentities(Collection<Identity> identitiesToAdd) {
        if (identitiesToAdd == null) {
            return;
        }
        for (Identity identity : identitiesToAdd) {
            this.addIdentity(identity);
        }
    }

    @Override
    public List<Identity> getIdentities() {
        return Collections.unmodifiableList(this.identities);
    }

    public boolean hasIdentity(String category, String type) {
        String key = XmppStringUtils.generateKey((String)category, (String)type);
        return this.identitiesSet.contains(key);
    }

    public List<Identity> getIdentities(String category, String type) {
        ArrayList<Identity> res = new ArrayList<Identity>(this.identities.size());
        for (Identity identity : this.identities) {
            if (!identity.getCategory().equals(category) || !identity.getType().equals(type)) continue;
            res.add(identity);
        }
        return res;
    }

    @Override
    public String getNode() {
        return this.node;
    }

    @Deprecated
    public void setNode(String node) {
        this.node = (String)StringUtils.requireNullOrNotEmpty((CharSequence)node, (String)"The node can not be the empty string");
    }

    public boolean containsFeature(CharSequence feature) {
        return this.features.contains(new Feature(feature));
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.optAttribute("node", this.getNode());
        xml.rightAngleBracket();
        for (Identity identity : this.identities) {
            xml.append(identity.toXML());
        }
        for (Feature feature : this.features) {
            xml.append(feature.toXML());
        }
        return xml;
    }

    public boolean containsDuplicateIdentities() {
        LinkedList<Identity> checkedIdentities = new LinkedList<Identity>();
        for (Identity i : this.identities) {
            for (Identity i2 : checkedIdentities) {
                if (!i.equals(i2)) continue;
                return true;
            }
            checkedIdentities.add(i);
        }
        return false;
    }

    public boolean containsDuplicateFeatures() {
        return this.containsDuplicateFeatures;
    }

    public DiscoverInfoBuilder asBuilder(String stanzaId) {
        return new DiscoverInfoBuilder(this, stanzaId);
    }

    @Deprecated
    public DiscoverInfo clone() {
        return new DiscoverInfo(this);
    }

    public static DiscoverInfoBuilder builder(XMPPConnection connection) {
        return new DiscoverInfoBuilder(connection);
    }

    public static DiscoverInfoBuilder builder(IqData iqData) {
        return new DiscoverInfoBuilder(iqData);
    }

    public static DiscoverInfoBuilder builder(String stanzaId) {
        return new DiscoverInfoBuilder(stanzaId);
    }

    public static final class Feature {
        private final String variable;

        public Feature(Feature feature) {
            this.variable = feature.variable;
        }

        public Feature(CharSequence variable) {
            this(variable.toString());
        }

        public Feature(String variable) {
            this.variable = (String)StringUtils.requireNotNullNorEmpty((CharSequence)variable, (String)"variable cannot be null");
        }

        public String getVar() {
            return this.variable;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement("feature");
            xml.attribute("var", this.variable);
            xml.closeEmptyElement();
            return xml;
        }

        public boolean equals(Object obj) {
            return EqualsUtil.equals((Object)this, (Object)obj, (e, o) -> e.append((Object)this.variable, (Object)o.variable));
        }

        public int hashCode() {
            return this.variable.hashCode();
        }

        public String toString() {
            return this.toXML().toString();
        }
    }

    public static final class Identity
    implements Comparable<Identity> {
        private final String category;
        private final String type;
        private final String key;
        private final String name;
        private final String lang;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        public Identity(String category, String type) {
            this(category, type, null, null);
        }

        public Identity(String category, String name, String type) {
            this(category, type, name, null);
        }

        public Identity(String category, String type, String name, String lang) {
            this.category = (String)StringUtils.requireNotNullNorEmpty((CharSequence)category, (String)"category cannot be null");
            this.type = (String)StringUtils.requireNotNullNorEmpty((CharSequence)type, (String)"type cannot be null");
            this.key = XmppStringUtils.generateKey((String)category, (String)type);
            this.name = name;
            this.lang = lang;
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getLanguage() {
            return this.lang;
        }

        private String getKey() {
            return this.key;
        }

        public boolean isOfCategoryAndType(String category, String type) {
            return this.category.equals(category) && this.type.equals(type);
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement("identity");
            xml.xmllangAttribute(this.lang);
            xml.attribute("category", this.category);
            xml.optAttribute("name", this.name);
            xml.optAttribute("type", this.type);
            xml.closeEmptyElement();
            return xml;
        }

        public boolean equals(Object obj) {
            return EqualsUtil.equals((Object)this, (Object)obj, (e, o) -> e.append((Object)this.key, (Object)o.key).append((Object)this.lang, (Object)o.lang).append((Object)this.name, (Object)o.name));
        }

        public int hashCode() {
            return this.hashCodeCache.getHashCode(c -> c.append((Object)this.key).append((Object)this.lang).append((Object)this.name));
        }

        @Override
        public int compareTo(Identity other) {
            String thisType;
            String otherLang = other.lang == null ? "" : other.lang;
            String thisLang = this.lang == null ? "" : this.lang;
            String otherType = other.type == null ? "" : other.type;
            String string = thisType = this.type == null ? "" : this.type;
            if (this.category.equals(other.category)) {
                if (thisType.equals(otherType)) {
                    if (thisLang.equals(otherLang)) {
                        return 0;
                    }
                    return thisLang.compareTo(otherLang);
                }
                return thisType.compareTo(otherType);
            }
            return this.category.compareTo(other.category);
        }

        public String toString() {
            return this.toXML().toString();
        }
    }
}

