/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqlast.packet;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LastActivity
extends IQ {
    public static final String NAMESPACE = "jabber:iq:last";
    public long lastActivity = -1L;
    public String message;

    public LastActivity() {
        this.setType(IQ.Type.GET);
    }

    public LastActivity(String to) {
        this();
        this.setTo(to);
    }

    public XmlStringBuilder getChildElementXML() {
        XmlStringBuilder xml = new XmlStringBuilder();
        xml.halfOpenElement("query");
        xml.xmlnsAttribute(NAMESPACE);
        if (this.lastActivity != -1L) {
            xml.attribute("seconds", Long.toString(this.lastActivity));
        }
        xml.closeEmptyElement();
        return xml;
    }

    public void setLastActivity(long lastActivity) {
        this.lastActivity = lastActivity;
    }

    private void setMessage(String message) {
        this.message = message;
    }

    public long getIdleTime() {
        return this.lastActivity;
    }

    public String getStatusMessage() {
        return this.message;
    }

    public static class Provider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser parser) throws SmackException, XmlPullParserException {
            if (parser.getEventType() != 2) {
                throw new SmackException("Parser not in proper position, or bad XML.");
            }
            LastActivity lastActivity = new LastActivity();
            String seconds = parser.getAttributeValue("", "seconds");
            if (seconds != null) {
                try {
                    lastActivity.setLastActivity(Long.parseLong(seconds));
                }
                catch (NumberFormatException e) {
                    throw new SmackException("Could not parse last activity number", (Throwable)e);
                }
            }
            try {
                lastActivity.setMessage(parser.nextText());
            }
            catch (IOException e) {
                throw new SmackException((Throwable)e);
            }
            return lastActivity;
        }
    }
}

