/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.sid;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.ToTypeFilter;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.sid.element.OriginIdElement;

public final class StableUniqueStanzaIdManager
extends Manager {
    public static final String NAMESPACE = "urn:xmpp:sid:0";
    private static final Map<XMPPConnection, StableUniqueStanzaIdManager> INSTANCES = new WeakHashMap<XMPPConnection, StableUniqueStanzaIdManager>();
    private static boolean enabledByDefault = true;
    private static final StanzaFilter OUTGOING_FILTER = new AndFilter(new StanzaFilter[]{MessageTypeFilter.NORMAL_OR_CHAT_OR_HEADLINE, ToTypeFilter.ENTITY_FULL_OR_BARE_JID});
    private static final StanzaFilter ORIGIN_ID_FILTER = new StanzaExtensionFilter("origin-id", "urn:xmpp:sid:0");
    private static final StanzaFilter ADD_ORIGIN_ID_FILTER = new AndFilter(new StanzaFilter[]{OUTGOING_FILTER, new NotFilter(ORIGIN_ID_FILTER)});

    private StableUniqueStanzaIdManager(XMPPConnection connection) {
        super(connection);
    }

    public static void setEnabledByDefault(boolean enabled) {
        enabledByDefault = enabled;
    }

    public static synchronized StableUniqueStanzaIdManager getInstanceFor(XMPPConnection connection) {
        StableUniqueStanzaIdManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new StableUniqueStanzaIdManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    public synchronized void enable() {
        this.connection().addMessageInterceptor(OriginIdElement::addTo, arg_0 -> ((StanzaFilter)ADD_ORIGIN_ID_FILTER).accept(arg_0));
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection()).addFeature(NAMESPACE);
    }

    public synchronized void disable() {
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection()).removeFeature(NAMESPACE);
        this.connection().removeMessageInterceptor(OriginIdElement::addTo);
    }

    public synchronized boolean isEnabled() {
        ServiceDiscoveryManager disco = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection());
        return disco.includesFeature(NAMESPACE);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                if (enabledByDefault) {
                    StableUniqueStanzaIdManager.getInstanceFor(connection).enable();
                }
            }
        });
    }
}

