/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.message_fastening;

import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public final class MessageFasteningManager
extends Manager {
    public static final String NAMESPACE = "urn:xmpp:fasten:0";
    private static boolean ENABLED_BY_DEFAULT = false;
    private static final WeakHashMap<XMPPConnection, MessageFasteningManager> INSTANCES = new WeakHashMap();

    private MessageFasteningManager(XMPPConnection connection) {
        super(connection);
    }

    public static synchronized MessageFasteningManager getInstanceFor(XMPPConnection connection) {
        MessageFasteningManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new MessageFasteningManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    public static synchronized void setEnabledByDefault(boolean enabled) {
        ENABLED_BY_DEFAULT = enabled;
    }

    public void announceSupport() {
        ServiceDiscoveryManager discoveryManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection());
        discoveryManager.addFeature(NAMESPACE);
    }

    public void stopAnnouncingSupport() {
        ServiceDiscoveryManager discoveryManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection());
        discoveryManager.removeFeature(NAMESPACE);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                if (ENABLED_BY_DEFAULT) {
                    MessageFasteningManager.getInstanceFor(connection).announceSupport();
                }
            }
        });
    }
}

